/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search.extractor;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.execution.search.extractor.BucketExtractor;
import org.elasticsearch.xpack.sql.querydsl.container.GroupByRef;
import org.elasticsearch.xpack.sql.util.DateUtils;

public class CompositeKeyExtractor
implements BucketExtractor {
    static final String NAME = "k";
    private final String key;
    private final GroupByRef.Property property;
    private final TimeZone timeZone;
    private final ZoneId zoneId;

    public CompositeKeyExtractor(String key, GroupByRef.Property property, TimeZone timeZone) {
        this.key = key;
        this.property = property;
        this.timeZone = timeZone;
        this.zoneId = timeZone != null ? timeZone.toZoneId() : null;
    }

    CompositeKeyExtractor(StreamInput in) throws IOException {
        this.key = in.readString();
        this.property = (GroupByRef.Property)in.readEnum(GroupByRef.Property.class);
        this.timeZone = in.readBoolean() ? TimeZone.getTimeZone(in.readString()) : null;
        this.zoneId = this.timeZone != null ? this.timeZone.toZoneId() : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.key);
        out.writeEnum((Enum)this.property);
        if (this.timeZone == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeString(this.timeZone.getID());
        }
    }

    String key() {
        return this.key;
    }

    GroupByRef.Property property() {
        return this.property;
    }

    TimeZone timeZone() {
        return this.timeZone;
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public Object extract(MultiBucketsAggregation.Bucket bucket) {
        if (this.property == GroupByRef.Property.COUNT) {
            return bucket.getDocCount();
        }
        Object m = bucket.getKey();
        if (!(m instanceof Map)) {
            throw new SqlIllegalArgumentException("Unexpected bucket returned: {}", m);
        }
        Object object = ((Map)m).get(this.key);
        if (this.timeZone != null) {
            if (object == null) {
                return object;
            }
            if (object instanceof Long) {
                object = DateUtils.of((Long)object, this.zoneId);
            } else {
                throw new SqlIllegalArgumentException("Invalid date key returned: {}", object);
            }
        }
        return object;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.property, this.timeZone});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeKeyExtractor other = (CompositeKeyExtractor)obj;
        return Objects.equals(this.key, other.key) && Objects.equals((Object)this.property, (Object)other.property) && Objects.equals(this.timeZone, other.timeZone);
    }

    public String toString() {
        return "|" + this.key + "|";
    }
}

