/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.oauth2;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.security.action.token.InvalidateTokenAction;
import org.elasticsearch.xpack.core.security.action.token.InvalidateTokenRequest;
import org.elasticsearch.xpack.core.security.action.token.InvalidateTokenResponse;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public final class RestInvalidateTokenAction
extends SecurityBaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestInvalidateTokenAction.class));
    static final ConstructingObjectParser<Tuple<String, String>, Void> PARSER = new ConstructingObjectParser("invalidate_token", a -> new Tuple((Object)((String)a[0]), (Object)((String)a[1])));

    public RestInvalidateTokenAction(Settings settings, RestController controller, XPackLicenseState xPackLicenseState) {
        super(settings, xPackLicenseState);
        controller.registerWithDeprecatedHandler(RestRequest.Method.DELETE, "/_security/oauth2/token", (RestHandler)this, RestRequest.Method.DELETE, "/_xpack/security/oauth2/token", deprecationLogger);
    }

    public String getName() {
        return "security_invalidate_token_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            InvalidateTokenRequest.Type type;
            String tokenString;
            Tuple tuple = (Tuple)PARSER.parse(parser, null);
            String token = (String)tuple.v1();
            String refreshToken = (String)tuple.v2();
            if (Strings.hasLength((String)token) && Strings.hasLength((String)refreshToken)) {
                throw new IllegalArgumentException("only one of [token, refresh_token] may be sent per request");
            }
            if (Strings.hasLength((String)token)) {
                tokenString = token;
                type = InvalidateTokenRequest.Type.ACCESS_TOKEN;
            } else if (Strings.hasLength((String)refreshToken)) {
                tokenString = refreshToken;
                type = InvalidateTokenRequest.Type.REFRESH_TOKEN;
            } else {
                tokenString = null;
                type = null;
            }
            InvalidateTokenRequest tokenRequest = new InvalidateTokenRequest(tokenString, type);
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((Action)InvalidateTokenAction.INSTANCE, (ActionRequest)tokenRequest, (ActionListener)new RestBuilderListener<InvalidateTokenResponse>(channel){

                public RestResponse buildResponse(InvalidateTokenResponse invalidateResp, XContentBuilder builder) throws Exception {
                    return new BytesRestResponse(RestStatus.OK, builder.startObject().field("created", invalidateResp.isCreated()).endObject());
                }
            });
            return restChannelConsumer;
        }
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("token", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("refresh_token", new String[0]));
    }
}

