/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support.mapper;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.security.ScrollHelper;
import org.elasticsearch.xpack.core.security.action.realm.ClearRealmCacheRequest;
import org.elasticsearch.xpack.core.security.action.rolemapping.DeleteRoleMappingRequest;
import org.elasticsearch.xpack.core.security.action.rolemapping.PutRoleMappingRequest;
import org.elasticsearch.xpack.core.security.authc.support.mapper.ExpressionRoleMapping;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.ExpressionModel;
import org.elasticsearch.xpack.core.security.client.SecurityClient;
import org.elasticsearch.xpack.security.authc.support.CachingRealm;
import org.elasticsearch.xpack.security.authc.support.UserRoleMapper;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public class NativeRoleMappingStore
implements UserRoleMapper {
    private static final Logger logger = LogManager.getLogger(NativeRoleMappingStore.class);
    static final String DOC_TYPE_FIELD = "doc_type";
    static final String DOC_TYPE_ROLE_MAPPING = "role-mapping";
    private static final String ID_PREFIX = "role-mapping_";
    private static final String SECURITY_GENERIC_TYPE = "doc";
    private static final ActionListener<Object> NO_OP_ACTION_LISTENER = new ActionListener<Object>(){

        public void onResponse(Object o) {
        }

        public void onFailure(Exception e) {
        }
    };
    private final Settings settings;
    private final Client client;
    private final SecurityIndexManager securityIndex;
    private final List<String> realmsToRefresh = new CopyOnWriteArrayList<String>();

    public NativeRoleMappingStore(Settings settings, Client client, SecurityIndexManager securityIndex) {
        this.settings = settings;
        this.client = client;
        this.securityIndex = securityIndex;
    }

    private String getNameFromId(String id) {
        assert (id.startsWith(ID_PREFIX));
        return id.substring(ID_PREFIX.length());
    }

    private String getIdForName(String name) {
        return ID_PREFIX + name;
    }

    void loadMappings(ActionListener<List<ExpressionRoleMapping>> listener) {
        if (!this.securityIndex.isIndexUpToDate()) {
            listener.onFailure((Exception)new IllegalStateException("Security index is not on the current version - the native realm will not be operational until the upgrade API is run on the security index"));
            return;
        }
        TermQueryBuilder query = QueryBuilders.termQuery((String)DOC_TYPE_FIELD, (String)DOC_TYPE_ROLE_MAPPING);
        Supplier supplier = this.client.threadPool().getThreadContext().newRestorableContext(false);
        try (ThreadContext.StoredContext ignore = ClientHelper.stashWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security");){
            SearchRequest request = (SearchRequest)this.client.prepareSearch(new String[]{".security"}).setScroll((TimeValue)SearchService.DEFAULT_KEEPALIVE_SETTING.get(this.settings)).setTypes(new String[]{SECURITY_GENERIC_TYPE}).setQuery((QueryBuilder)query).setSize(1000).setFetchSource(true).request();
            request.indicesOptions().ignoreUnavailable();
            ScrollHelper.fetchAllByEntity((Client)this.client, (SearchRequest)request, (ActionListener)new ContextPreservingActionListener(supplier, ActionListener.wrap(mappings -> listener.onResponse(mappings.stream().filter(Objects::nonNull).collect(Collectors.toList())), ex -> {
                logger.error((Message)new ParameterizedMessage("failed to load role mappings from index [{}] skipping all mappings.", (Object)".security"), (Throwable)ex);
                listener.onResponse(Collections.emptyList());
            })), doc -> this.buildMapping(this.getNameFromId(doc.getId()), doc.getSourceRef()));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ExpressionRoleMapping buildMapping(String id, BytesReference source) {
        try (StreamInput stream = source.streamInput();){
            ExpressionRoleMapping expressionRoleMapping;
            block14: {
                XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);
                try {
                    expressionRoleMapping = ExpressionRoleMapping.parse((String)id, (XContentParser)parser);
                    if (parser == null) break block14;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return expressionRoleMapping;
        }
        catch (Exception e) {
            logger.warn((Message)new ParameterizedMessage("Role mapping [{}] cannot be parsed and will be skipped", (Object)id), (Throwable)e);
            return null;
        }
    }

    public void putRoleMapping(PutRoleMappingRequest request, ActionListener<Boolean> listener) {
        this.modifyMapping(request.getName(), this::innerPutMapping, request, listener);
    }

    public void deleteRoleMapping(DeleteRoleMappingRequest request, ActionListener<Boolean> listener) {
        this.modifyMapping(request.getName(), this::innerDeleteMapping, request, listener);
    }

    private <Request, Result> void modifyMapping(String name, CheckedBiConsumer<Request, ActionListener<Result>, Exception> inner, Request request, ActionListener<Result> listener) {
        if (!this.securityIndex.isIndexUpToDate()) {
            listener.onFailure((Exception)new IllegalStateException("Security index is not on the current version - the native realm will not be operational until the upgrade API is run on the security index"));
        } else {
            try {
                inner.accept(request, (Object)ActionListener.wrap(r -> this.refreshRealms(listener, r), arg_0 -> listener.onFailure(arg_0)));
            }
            catch (Exception e) {
                logger.error((Message)new ParameterizedMessage("failed to modify role-mapping [{}]", (Object)name), (Throwable)e);
                listener.onFailure(e);
            }
        }
    }

    private void innerPutMapping(PutRoleMappingRequest request, final ActionListener<Boolean> listener) {
        final ExpressionRoleMapping mapping = request.getMapping();
        this.securityIndex.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
            XContentBuilder xContentBuilder;
            try {
                xContentBuilder = mapping.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS, true);
            }
            catch (IOException e) {
                listener.onFailure((Exception)e);
                return;
            }
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)((IndexRequest)((IndexRequestBuilder)this.client.prepareIndex(".security", SECURITY_GENERIC_TYPE, this.getIdForName(mapping.getName())).setSource(xContentBuilder).setRefreshPolicy(request.getRefreshPolicy())).request()), (ActionListener)new ActionListener<IndexResponse>(){

                public void onResponse(IndexResponse indexResponse) {
                    boolean created = indexResponse.getResult() == DocWriteResponse.Result.CREATED;
                    listener.onResponse((Object)created);
                }

                public void onFailure(Exception e) {
                    logger.error((Message)new ParameterizedMessage("failed to put role-mapping [{}]", (Object)mapping.getName()), (Throwable)e);
                    listener.onFailure(e);
                }
            }, (arg_0, arg_1) -> ((Client)this.client).index(arg_0, arg_1));
        });
    }

    private void innerDeleteMapping(final DeleteRoleMappingRequest request, final ActionListener<Boolean> listener) {
        SecurityIndexManager frozenSecurityIndex = this.securityIndex.freeze();
        if (!frozenSecurityIndex.indexExists()) {
            listener.onResponse((Object)false);
        } else if (!this.securityIndex.isAvailable()) {
            listener.onFailure((Exception)frozenSecurityIndex.getUnavailableReason());
        } else {
            this.securityIndex.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)((DeleteRequest)((DeleteRequestBuilder)this.client.prepareDelete(".security", SECURITY_GENERIC_TYPE, this.getIdForName(request.getName())).setRefreshPolicy(request.getRefreshPolicy())).request()), (ActionListener)new ActionListener<DeleteResponse>(){

                public void onResponse(DeleteResponse deleteResponse) {
                    boolean deleted = deleteResponse.getResult() == DocWriteResponse.Result.DELETED;
                    listener.onResponse((Object)deleted);
                }

                public void onFailure(Exception e) {
                    logger.error((Message)new ParameterizedMessage("failed to delete role-mapping [{}]", (Object)request.getName()), (Throwable)e);
                    listener.onFailure(e);
                }
            }, (arg_0, arg_1) -> ((Client)this.client).delete(arg_0, arg_1)));
        }
    }

    public void getRoleMappings(final Set<String> names, final ActionListener<List<ExpressionRoleMapping>> listener) {
        if (names == null || names.isEmpty()) {
            this.getMappings(listener);
        } else {
            this.getMappings(new ActionListener<List<ExpressionRoleMapping>>(){

                public void onResponse(List<ExpressionRoleMapping> mappings) {
                    List filtered = mappings.stream().filter(m -> names.contains(m.getName())).collect(Collectors.toList());
                    listener.onResponse(filtered);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
    }

    private void getMappings(ActionListener<List<ExpressionRoleMapping>> listener) {
        if (this.securityIndex.isAvailable()) {
            this.loadMappings(listener);
        } else {
            logger.info("The security index is not yet available - no role mappings can be loaded");
            if (logger.isDebugEnabled()) {
                logger.debug("Security Index [{}] [exists: {}] [available: {}] [mapping up to date: {}]", (Object)".security", (Object)this.securityIndex.indexExists(), (Object)this.securityIndex.isAvailable(), (Object)this.securityIndex.isMappingUpToDate());
            }
            listener.onResponse(Collections.emptyList());
        }
    }

    public void usageStats(ActionListener<Map<String, Object>> listener) {
        if (!this.securityIndex.isAvailable()) {
            this.reportStats(listener, Collections.emptyList());
        } else {
            this.getMappings((ActionListener<List<ExpressionRoleMapping>>)ActionListener.wrap(mappings -> this.reportStats(listener, (List<ExpressionRoleMapping>)mappings), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private void reportStats(ActionListener<Map<String, Object>> listener, List<ExpressionRoleMapping> mappings) {
        HashMap<String, Number> usageStats = new HashMap<String, Number>();
        usageStats.put("size", mappings.size());
        usageStats.put("enabled", mappings.stream().filter(ExpressionRoleMapping::isEnabled).count());
        listener.onResponse(usageStats);
    }

    public void onSecurityIndexStateChange(SecurityIndexManager.State previousState, SecurityIndexManager.State currentState) {
        if (SecurityIndexManager.isMoveFromRedToNonRed(previousState, currentState) || SecurityIndexManager.isIndexDeleted(previousState, currentState) || previousState.isIndexUpToDate != currentState.isIndexUpToDate) {
            this.refreshRealms(NO_OP_ACTION_LISTENER, null);
        }
    }

    private <Result> void refreshRealms(ActionListener<Result> listener, Result result) {
        String[] realmNames = this.realmsToRefresh.toArray(new String[this.realmsToRefresh.size()]);
        SecurityClient securityClient = new SecurityClient((ElasticsearchClient)this.client);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)((ClearRealmCacheRequest)securityClient.prepareClearRealmCache().realms(realmNames).request()), (ActionListener)ActionListener.wrap(response -> {
            logger.debug(() -> new ParameterizedMessage("Cleared cached in realms [{}] due to role mapping change", (Object)Arrays.toString(realmNames)));
            listener.onResponse(result);
        }, ex -> {
            logger.warn("Failed to clear cache for realms [{}]", (Object)Arrays.toString(realmNames));
            listener.onFailure(ex);
        }), (arg_0, arg_1) -> ((SecurityClient)securityClient).clearRealmCache(arg_0, arg_1));
    }

    @Override
    public void resolveRoles(UserRoleMapper.UserData user, ActionListener<Set<String>> listener) {
        this.getRoleMappings(null, (ActionListener<List<ExpressionRoleMapping>>)ActionListener.wrap(mappings -> {
            ExpressionModel model = user.asModel();
            Stream<ExpressionRoleMapping> stream = mappings.stream().filter(ExpressionRoleMapping::isEnabled).filter(m -> m.getExpression().match(model));
            if (logger.isTraceEnabled()) {
                stream = stream.map(m -> {
                    logger.trace("User [{}] matches role-mapping [{}] with roles [{}]", (Object)user.getUsername(), (Object)m.getName(), (Object)m.getRoles());
                    return m;
                });
            }
            Set roles = stream.flatMap(m -> m.getRoles().stream()).collect(Collectors.toSet());
            logger.debug("Mapping user [{}] to roles [{}]", (Object)user, roles);
            listener.onResponse(roles);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void refreshRealmOnChange(CachingRealm realm) {
        this.realmsToRefresh.add(realm.name());
    }
}

