/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.role;

import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.role.DeleteRoleRequest;
import org.elasticsearch.xpack.core.security.action.role.DeleteRoleResponse;
import org.elasticsearch.xpack.core.security.authz.store.ReservedRolesStore;
import org.elasticsearch.xpack.security.authz.store.NativeRolesStore;

public class TransportDeleteRoleAction
extends HandledTransportAction<DeleteRoleRequest, DeleteRoleResponse> {
    private final NativeRolesStore rolesStore;

    @Inject
    public TransportDeleteRoleAction(ActionFilters actionFilters, NativeRolesStore rolesStore, TransportService transportService) {
        super("cluster:admin/xpack/security/role/delete", transportService, actionFilters, DeleteRoleRequest::new);
        this.rolesStore = rolesStore;
    }

    protected void doExecute(Task task, DeleteRoleRequest request, final ActionListener<DeleteRoleResponse> listener) {
        if (ReservedRolesStore.isReserved((String)request.name())) {
            listener.onFailure((Exception)new IllegalArgumentException("role [" + request.name() + "] is reserved and cannot be deleted"));
            return;
        }
        try {
            this.rolesStore.deleteRole(request, new ActionListener<Boolean>(){

                public void onResponse(Boolean found) {
                    listener.onResponse((Object)new DeleteRoleResponse(found.booleanValue()));
                }

                public void onFailure(Exception t) {
                    listener.onFailure(t);
                }
            });
        }
        catch (Exception e) {
            this.logger.error(() -> new ParameterizedMessage("failed to delete role [{}]", (Object)request.name()), (Throwable)e);
            listener.onFailure(e);
        }
    }
}

