/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.output;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.ml.job.results.AutodetectResult;

public class AutodetectResultsParser {
    public Iterator<AutodetectResult> parseResults(InputStream in) throws ElasticsearchParseException {
        try {
            XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, in);
            XContentParser.Token token = parser.nextToken();
            if (token != XContentParser.Token.START_ARRAY) {
                throw new ElasticsearchParseException("unexpected token [" + token + "]", new Object[0]);
            }
            return new AutodetectResultIterator(in, parser);
        }
        catch (IOException e) {
            throw new ElasticsearchParseException(e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    private static class AutodetectResultIterator
    implements Iterator<AutodetectResult> {
        private static final Logger logger = LogManager.getLogger(AutodetectResultIterator.class);
        private final InputStream in;
        private final XContentParser parser;
        private XContentParser.Token token;

        private AutodetectResultIterator(InputStream in, XContentParser parser) {
            this.in = in;
            this.parser = parser;
            this.token = parser.currentToken();
        }

        @Override
        public boolean hasNext() {
            try {
                this.token = this.parser.nextToken();
            }
            catch (IOException e) {
                logger.debug("io error while parsing", (Throwable)e);
                return false;
            }
            if (this.token == XContentParser.Token.END_ARRAY) {
                return false;
            }
            if (this.token != XContentParser.Token.START_OBJECT) {
                logger.error("Expecting Json Field name token after the Start Object token");
                throw new ElasticsearchParseException("unexpected token [" + this.token + "]", new Object[0]);
            }
            return true;
        }

        @Override
        public AutodetectResult next() {
            return (AutodetectResult)AutodetectResult.PARSER.apply(this.parser, null);
        }
    }
}

