/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.CategorizerState;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;

public class StateStreamer {
    private static final Logger LOGGER = LogManager.getLogger(StateStreamer.class);
    private final Client client;
    private volatile boolean isCancelled;

    public StateStreamer(Client client) {
        this.client = Objects.requireNonNull(client);
    }

    public void cancel() {
        this.isCancelled = true;
    }

    public void restoreStateToStream(String jobId, ModelSnapshot modelSnapshot, OutputStream restoreStream) throws IOException {
        GetResponse stateResponse;
        ThreadContext.StoredContext ignore;
        String indexName = AnomalyDetectorsIndex.jobStateIndexName();
        for (String stateDocId : modelSnapshot.stateDocumentIds()) {
            if (this.isCancelled) {
                return;
            }
            LOGGER.trace("ES API CALL: get ID {} from index {}", (Object)stateDocId, (Object)indexName);
            ignore = ClientHelper.stashWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml");
            try {
                stateResponse = (GetResponse)this.client.prepareGet(indexName, "doc", stateDocId).get();
                if (!stateResponse.isExists()) {
                    LOGGER.error("Expected {} documents for model state for {} snapshot {} but failed to find {}", (Object)modelSnapshot.getSnapshotDocCount(), (Object)jobId, (Object)modelSnapshot.getSnapshotId(), (Object)stateDocId);
                    break;
                }
                this.writeStateToStream(stateResponse.getSourceAsBytesRef(), restoreStream);
            }
            finally {
                if (ignore == null) continue;
                ignore.close();
            }
        }
        int docNum = 0;
        while (true) {
            if (this.isCancelled) {
                return;
            }
            String docId = CategorizerState.documentId((String)jobId, (int)(++docNum));
            LOGGER.trace("ES API CALL: get ID {} from index {}", (Object)docId, (Object)indexName);
            ignore = ClientHelper.stashWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml");
            try {
                stateResponse = (GetResponse)this.client.prepareGet(indexName, "doc", docId).get();
                if (!stateResponse.isExists()) break;
                this.writeStateToStream(stateResponse.getSourceAsBytesRef(), restoreStream);
                continue;
            }
            finally {
                if (ignore == null) continue;
                ignore.close();
                continue;
            }
            break;
        }
    }

    private void writeStateToStream(BytesReference source, OutputStream stream) throws IOException {
        if (this.isCancelled) {
            return;
        }
        BytesRefIterator iterator = source.iterator();
        BytesRef ref = iterator.next();
        while (ref != null) {
            int length;
            for (length = ref.bytes.length; length > 0 && ref.bytes[length - 1] == 0; --length) {
            }
            if (length > 0) {
                stream.write(ref.bytes, 0, length);
            }
            ref = iterator.next();
        }
        stream.write(0);
    }
}

