/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.scroll;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesAction;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.MlStrings;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.fields.TimeBasedExtractedFields;
import org.elasticsearch.xpack.ml.datafeed.extractor.scroll.ScrollDataExtractor;
import org.elasticsearch.xpack.ml.datafeed.extractor.scroll.ScrollDataExtractorContext;

public class ScrollDataExtractorFactory
implements DataExtractorFactory {
    private final Client client;
    private final DatafeedConfig datafeedConfig;
    private final Job job;
    private final TimeBasedExtractedFields extractedFields;

    private ScrollDataExtractorFactory(Client client, DatafeedConfig datafeedConfig, Job job, TimeBasedExtractedFields extractedFields) {
        this.client = Objects.requireNonNull(client);
        this.datafeedConfig = Objects.requireNonNull(datafeedConfig);
        this.job = Objects.requireNonNull(job);
        this.extractedFields = Objects.requireNonNull(extractedFields);
    }

    @Override
    public DataExtractor newExtractor(long start, long end) {
        ScrollDataExtractorContext dataExtractorContext = new ScrollDataExtractorContext(this.job.getId(), this.extractedFields, this.datafeedConfig.getIndices(), this.datafeedConfig.getTypes(), this.datafeedConfig.getParsedQuery(), this.datafeedConfig.getScriptFields(), this.datafeedConfig.getScrollSize(), start, end, this.datafeedConfig.getHeaders());
        return new ScrollDataExtractor(this.client, dataExtractorContext);
    }

    public static void create(Client client, DatafeedConfig datafeed, Job job, ActionListener<DataExtractorFactory> listener) {
        ActionListener fieldCapabilitiesHandler = ActionListener.wrap(fieldCapabilitiesResponse -> {
            TimeBasedExtractedFields extractedFields = TimeBasedExtractedFields.build(job, datafeed, fieldCapabilitiesResponse);
            listener.onResponse((Object)new ScrollDataExtractorFactory(client, datafeed, job, extractedFields));
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                listener.onFailure((Exception)new ResourceNotFoundException("datafeed [" + datafeed.getId() + "] cannot retrieve data because index " + ((IndexNotFoundException)e).getIndex() + " does not exist", new Object[0]));
            } else if (e instanceof IllegalArgumentException) {
                listener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)("[" + datafeed.getId() + "] " + e.getMessage()), (Object[])new Object[0])));
            } else {
                listener.onFailure(e);
            }
        });
        FieldCapabilitiesRequest fieldCapabilitiesRequest = new FieldCapabilitiesRequest();
        fieldCapabilitiesRequest.indices(datafeed.getIndices().toArray(new String[datafeed.getIndices().size()]));
        String[] requestFields = (String[])job.allInputFields().stream().map(f -> MlStrings.getParentField((String)f) + "*").toArray(String[]::new);
        fieldCapabilitiesRequest.fields(requestFields);
        ClientHelper.executeWithHeaders((Map)datafeed.getHeaders(), (String)"ml", (Client)client, () -> {
            client.execute((Action)FieldCapabilitiesAction.INSTANCE, (ActionRequest)fieldCapabilitiesRequest, fieldCapabilitiesHandler);
            return null;
        });
    }
}

