/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed;

import java.util.Collections;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.core.ml.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.job.config.DataDescription;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.core.ml.job.results.Bucket;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.ml.datafeed.DatafeedJob;
import org.elasticsearch.xpack.ml.datafeed.delayeddatacheck.DelayedDataDetector;
import org.elasticsearch.xpack.ml.datafeed.delayeddatacheck.DelayedDataDetectorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorFactory;
import org.elasticsearch.xpack.ml.job.persistence.BucketsQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.notifications.Auditor;

public class DatafeedJobBuilder {
    private final Client client;
    private final JobResultsProvider jobResultsProvider;
    private final Auditor auditor;
    private final Supplier<Long> currentTimeSupplier;

    public DatafeedJobBuilder(Client client, JobResultsProvider jobResultsProvider, Auditor auditor, Supplier<Long> currentTimeSupplier) {
        this.client = client;
        this.jobResultsProvider = Objects.requireNonNull(jobResultsProvider);
        this.auditor = Objects.requireNonNull(auditor);
        this.currentTimeSupplier = Objects.requireNonNull(currentTimeSupplier);
    }

    void build(Job job, DatafeedConfig datafeed, ActionListener<DatafeedJob> listener) {
        Consumer<Context> contextHanlder = context -> {
            TimeValue frequency = DatafeedJobBuilder.getFrequencyOrDefault(datafeed, job);
            TimeValue queryDelay = datafeed.getQueryDelay();
            DelayedDataDetector delayedDataDetector = DelayedDataDetectorFactory.buildDetector(job, datafeed, this.client);
            DatafeedJob datafeedJob = new DatafeedJob(job.getId(), DatafeedJobBuilder.buildDataDescription(job), frequency.millis(), queryDelay.millis(), context.dataExtractorFactory, this.client, this.auditor, this.currentTimeSupplier, delayedDataDetector, context.latestFinalBucketEndMs, context.latestRecordTimeMs);
            listener.onResponse((Object)datafeedJob);
        };
        Context context2 = new Context();
        ActionListener dataExtractorFactoryHandler = ActionListener.wrap(dataExtractorFactory -> {
            context.dataExtractorFactory = dataExtractorFactory;
            contextHanlder.accept(context2);
        }, e -> {
            this.auditor.error(job.getId(), e.getMessage());
            listener.onFailure(e);
        });
        Consumer<DataCounts> dataCountsHandler = dataCounts -> {
            if (dataCounts.getLatestRecordTimeStamp() != null) {
                context.latestRecordTimeMs = dataCounts.getLatestRecordTimeStamp().getTime();
            }
            DataExtractorFactory.create(this.client, datafeed, job, (ActionListener<DataExtractorFactory>)dataExtractorFactoryHandler);
        };
        Consumer<QueryPage<Bucket>> bucketsHandler = buckets -> {
            if (buckets.results().size() == 1) {
                TimeValue bucketSpan = job.getAnalysisConfig().getBucketSpan();
                context.latestFinalBucketEndMs = ((Bucket)buckets.results().get(0)).getTimestamp().getTime() + bucketSpan.millis() - 1L;
            }
            this.jobResultsProvider.dataCounts(job.getId(), dataCountsHandler, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
        };
        BucketsQueryBuilder latestBucketQuery = new BucketsQueryBuilder().sortField(Result.TIMESTAMP.getPreferredName()).sortDescending(true).size(1).includeInterim(false);
        this.jobResultsProvider.bucketsViaInternalClient(job.getId(), latestBucketQuery, bucketsHandler, e -> {
            if (e instanceof ResourceNotFoundException) {
                QueryPage empty = new QueryPage(Collections.emptyList(), 0L, Bucket.RESULT_TYPE_FIELD);
                bucketsHandler.accept(empty);
            } else {
                listener.onFailure(e);
            }
        });
    }

    private static TimeValue getFrequencyOrDefault(DatafeedConfig datafeed, Job job) {
        TimeValue frequency = datafeed.getFrequency();
        if (frequency == null) {
            TimeValue bucketSpan = job.getAnalysisConfig().getBucketSpan();
            return datafeed.defaultFrequency(bucketSpan);
        }
        return frequency;
    }

    private static DataDescription buildDataDescription(Job job) {
        DataDescription.Builder dataDescription = new DataDescription.Builder();
        dataDescription.setFormat(DataDescription.DataFormat.XCONTENT);
        if (job.getDataDescription() != null) {
            dataDescription.setTimeField(job.getDataDescription().getTimeField());
        }
        dataDescription.setTimeFormat("epoch_ms");
        return dataDescription.build();
    }

    private static class Context {
        volatile long latestFinalBucketEndMs = -1L;
        volatile long latestRecordTimeMs = -1L;
        volatile DataExtractorFactory dataExtractorFactory;

        private Context() {
        }
    }
}

