/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.RemoteClusterLicenseChecker;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.StartDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedJobValidator;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.datafeed.DatafeedManager;
import org.elasticsearch.xpack.ml.datafeed.DatafeedNodeSelector;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorFactory;
import org.elasticsearch.xpack.ml.notifications.Auditor;

public class TransportStartDatafeedAction
extends TransportMasterNodeAction<StartDatafeedAction.Request, AcknowledgedResponse> {
    private final Client client;
    private final XPackLicenseState licenseState;
    private final PersistentTasksService persistentTasksService;
    private final Auditor auditor;

    @Inject
    public TransportStartDatafeedAction(TransportService transportService, ThreadPool threadPool, ClusterService clusterService, XPackLicenseState licenseState, PersistentTasksService persistentTasksService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, Auditor auditor) {
        super("cluster:admin/xpack/ml/datafeed/start", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, StartDatafeedAction.Request::new);
        this.licenseState = licenseState;
        this.persistentTasksService = persistentTasksService;
        this.client = client;
        this.auditor = auditor;
    }

    static void validate(String datafeedId, MlMetadata mlMetadata, PersistentTasksCustomMetaData tasks) {
        DatafeedConfig datafeed;
        DatafeedConfig datafeedConfig = datafeed = mlMetadata == null ? null : mlMetadata.getDatafeed(datafeedId);
        if (datafeed == null) {
            throw ExceptionsHelper.missingDatafeedException((String)datafeedId);
        }
        Job job = (Job)mlMetadata.getJobs().get(datafeed.getJobId());
        if (job == null) {
            throw ExceptionsHelper.missingJobException((String)datafeed.getJobId());
        }
        DatafeedJobValidator.validate((DatafeedConfig)datafeed, (Job)job);
        DatafeedConfig.validateAggregations((AggregatorFactories.Builder)datafeed.getParsedAggregations());
        JobState jobState = MlTasks.getJobState((String)datafeed.getJobId(), (PersistentTasksCustomMetaData)tasks);
        if (!jobState.isAnyOf(new JobState[]{JobState.OPENING, JobState.OPENED})) {
            throw ExceptionsHelper.conflictStatusException((String)("cannot start datafeed [" + datafeedId + "] because job [" + job.getId() + "] is " + jobState), (Object[])new Object[0]);
        }
    }

    static void auditDeprecations(DatafeedConfig datafeed, Job job, Auditor auditor) {
        ArrayList deprecationWarnings = new ArrayList();
        deprecationWarnings.addAll(datafeed.getAggDeprecations());
        deprecationWarnings.addAll(datafeed.getQueryDeprecations());
        if (!deprecationWarnings.isEmpty()) {
            String msg = "datafeed [" + datafeed.getId() + "] configuration has deprecations. [" + Strings.collectionToDelimitedString(deprecationWarnings, (String)", ") + "]";
            auditor.warning(job.getId(), msg);
        }
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    protected void masterOperation(StartDatafeedAction.Request request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        final StartDatafeedAction.DatafeedParams params = request.getParams();
        if (this.licenseState.isMachineLearningAllowed()) {
            ActionListener<PersistentTasksCustomMetaData.PersistentTask<StartDatafeedAction.DatafeedParams>> waitForTaskListener = new ActionListener<PersistentTasksCustomMetaData.PersistentTask<StartDatafeedAction.DatafeedParams>>(){

                public void onResponse(PersistentTasksCustomMetaData.PersistentTask<StartDatafeedAction.DatafeedParams> persistentTask) {
                    TransportStartDatafeedAction.this.waitForDatafeedStarted(persistentTask.getId(), params, (ActionListener<AcknowledgedResponse>)listener);
                }

                public void onFailure(Exception e) {
                    if (e instanceof ResourceAlreadyExistsException) {
                        TransportStartDatafeedAction.this.logger.debug("datafeed already started", (Throwable)e);
                        e = new ElasticsearchStatusException("cannot start datafeed [" + params.getDatafeedId() + "] because it has already been started", RestStatus.CONFLICT, new Object[0]);
                    }
                    listener.onFailure(e);
                }
            };
            MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)state);
            PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
            TransportStartDatafeedAction.validate(params.getDatafeedId(), mlMetadata, tasks);
            DatafeedConfig datafeed = mlMetadata.getDatafeed(params.getDatafeedId());
            Job job = (Job)mlMetadata.getJobs().get(datafeed.getJobId());
            TransportStartDatafeedAction.auditDeprecations(datafeed, job, this.auditor);
            if (RemoteClusterLicenseChecker.containsRemoteIndex((List)datafeed.getIndices())) {
                RemoteClusterLicenseChecker remoteClusterLicenseChecker = new RemoteClusterLicenseChecker(this.client, XPackLicenseState::isMachineLearningAllowedForOperationMode);
                remoteClusterLicenseChecker.checkRemoteClusterLicenses(RemoteClusterLicenseChecker.remoteClusterAliases((List)datafeed.getIndices()), ActionListener.wrap(arg_0 -> this.lambda$masterOperation$0(listener, datafeed, job, params, (ActionListener)waitForTaskListener, arg_0), e -> listener.onFailure((Exception)this.createUnknownLicenseError(datafeed.getId(), RemoteClusterLicenseChecker.remoteIndices((List)datafeed.getIndices()), (Exception)e))));
            } else {
                this.createDataExtractor(job, datafeed, params, waitForTaskListener);
            }
        } else {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
        }
    }

    private void createDataExtractor(Job job, DatafeedConfig datafeed, StartDatafeedAction.DatafeedParams params, ActionListener<PersistentTasksCustomMetaData.PersistentTask<StartDatafeedAction.DatafeedParams>> listener) {
        DataExtractorFactory.create(this.client, datafeed, job, (ActionListener<DataExtractorFactory>)ActionListener.wrap(dataExtractorFactory -> this.persistentTasksService.sendStartRequest(MlTasks.datafeedTaskId((String)params.getDatafeedId()), "xpack/ml/datafeed", (PersistentTaskParams)params, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    protected ClusterBlockException checkBlock(StartDatafeedAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private void waitForDatafeedStarted(String taskId, final StartDatafeedAction.DatafeedParams params, final ActionListener<AcknowledgedResponse> listener) {
        final DatafeedPredicate predicate = new DatafeedPredicate();
        this.persistentTasksService.waitForPersistentTaskCondition(taskId, (Predicate)predicate, params.getTimeout(), (PersistentTasksService.WaitForPersistentTaskListener)new PersistentTasksService.WaitForPersistentTaskListener<StartDatafeedAction.DatafeedParams>(){

            public void onResponse(PersistentTasksCustomMetaData.PersistentTask<StartDatafeedAction.DatafeedParams> persistentTask) {
                if (predicate.exception != null) {
                    TransportStartDatafeedAction.this.cancelDatafeedStart((PersistentTasksCustomMetaData.PersistentTask<StartDatafeedAction.DatafeedParams>)persistentTask, predicate.exception, (ActionListener<AcknowledgedResponse>)listener);
                } else {
                    listener.onResponse((Object)new AcknowledgedResponse(true));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public void onTimeout(TimeValue timeout) {
                listener.onFailure((Exception)new ElasticsearchException("Starting datafeed [" + params.getDatafeedId() + "] timed out after [" + timeout + "]", new Object[0]));
            }
        });
    }

    private void cancelDatafeedStart(final PersistentTasksCustomMetaData.PersistentTask<StartDatafeedAction.DatafeedParams> persistentTask, final Exception exception, final ActionListener<AcknowledgedResponse> listener) {
        this.persistentTasksService.sendRemoveRequest(persistentTask.getId(), new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

            public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> task) {
                listener.onFailure(exception);
            }

            public void onFailure(Exception e) {
                TransportStartDatafeedAction.this.logger.error("[" + ((StartDatafeedAction.DatafeedParams)persistentTask.getParams()).getDatafeedId() + "] Failed to cancel persistent task that could not be assigned due to [" + exception.getMessage() + "]", (Throwable)e);
                listener.onFailure(exception);
            }
        });
    }

    private ElasticsearchStatusException createUnlicensedError(String datafeedId, RemoteClusterLicenseChecker.LicenseCheck licenseCheck) {
        String message = String.format(Locale.ROOT, "cannot start datafeed [%s] as it is configured to use indices on remote cluster [%s] that is not licensed for ml; %s", datafeedId, licenseCheck.remoteClusterLicenseInfo().clusterAlias(), RemoteClusterLicenseChecker.buildErrorMessage((String)"ml", (RemoteClusterLicenseChecker.RemoteClusterLicenseInfo)licenseCheck.remoteClusterLicenseInfo(), RemoteClusterLicenseChecker::isLicensePlatinumOrTrial));
        return new ElasticsearchStatusException(message, RestStatus.BAD_REQUEST, new Object[0]);
    }

    private ElasticsearchStatusException createUnknownLicenseError(String datafeedId, List<String> remoteIndices, Exception cause) {
        int numberOfRemoteClusters = RemoteClusterLicenseChecker.remoteClusterAliases(remoteIndices).size();
        assert (numberOfRemoteClusters > 0);
        String remoteClusterQualifier = numberOfRemoteClusters == 1 ? "a remote cluster" : "remote clusters";
        String licenseTypeQualifier = numberOfRemoteClusters == 1 ? "" : "s";
        String message = String.format(Locale.ROOT, "cannot start datafeed [%s] as it uses indices on %s %s but the license type%s could not be verified", datafeedId, remoteClusterQualifier, remoteIndices, licenseTypeQualifier);
        return new ElasticsearchStatusException(message, RestStatus.BAD_REQUEST, (Throwable)cause, new Object[0]);
    }

    private /* synthetic */ void lambda$masterOperation$0(ActionListener listener, DatafeedConfig datafeed, Job job, StartDatafeedAction.DatafeedParams params, ActionListener waitForTaskListener, RemoteClusterLicenseChecker.LicenseCheck response) throws Exception {
        if (!response.isSuccess()) {
            listener.onFailure((Exception)this.createUnlicensedError(datafeed.getId(), response));
        } else {
            this.createDataExtractor(job, datafeed, params, (ActionListener<PersistentTasksCustomMetaData.PersistentTask<StartDatafeedAction.DatafeedParams>>)waitForTaskListener);
        }
    }

    private class DatafeedPredicate
    implements Predicate<PersistentTasksCustomMetaData.PersistentTask<?>> {
        private volatile Exception exception;

        private DatafeedPredicate() {
        }

        @Override
        public boolean test(PersistentTasksCustomMetaData.PersistentTask<?> persistentTask) {
            if (persistentTask == null) {
                return false;
            }
            PersistentTasksCustomMetaData.Assignment assignment = persistentTask.getAssignment();
            if (assignment != null && !assignment.equals((Object)PersistentTasksCustomMetaData.INITIAL_ASSIGNMENT) && !assignment.isAssigned()) {
                this.exception = new ElasticsearchStatusException("Could not start datafeed, allocation explanation [" + assignment.getExplanation() + "]", RestStatus.TOO_MANY_REQUESTS, new Object[0]);
                return true;
            }
            DatafeedState datafeedState = (DatafeedState)persistentTask.getState();
            return datafeedState == DatafeedState.STARTED;
        }
    }

    public static class DatafeedTask
    extends AllocatedPersistentTask
    implements StartDatafeedAction.DatafeedTaskMatcher {
        private final String datafeedId;
        private final long startTime;
        private final Long endTime;
        volatile DatafeedManager datafeedManager;

        DatafeedTask(long id, String type, String action, TaskId parentTaskId, StartDatafeedAction.DatafeedParams params, Map<String, String> headers) {
            super(id, type, action, "datafeed-" + params.getDatafeedId(), parentTaskId, headers);
            this.datafeedId = params.getDatafeedId();
            this.startTime = params.getStartTime();
            this.endTime = params.getEndTime();
        }

        public String getDatafeedId() {
            return this.datafeedId;
        }

        public long getDatafeedStartTime() {
            return this.startTime;
        }

        @Nullable
        public Long getEndTime() {
            return this.endTime;
        }

        public boolean isLookbackOnly() {
            return this.endTime != null;
        }

        protected void onCancelled() {
            this.stop(this.getReasonCancelled(), TimeValue.ZERO);
        }

        public void stop(String reason, TimeValue timeout) {
            if (this.datafeedManager != null) {
                this.datafeedManager.stopDatafeed(this, reason, timeout);
            }
        }

        public void isolate() {
            if (this.datafeedManager != null) {
                this.datafeedManager.isolateDatafeed(this.getAllocationId());
            }
        }
    }

    public static class StartDatafeedPersistentTasksExecutor
    extends PersistentTasksExecutor<StartDatafeedAction.DatafeedParams> {
        private final DatafeedManager datafeedManager;
        private final IndexNameExpressionResolver resolver;

        public StartDatafeedPersistentTasksExecutor(DatafeedManager datafeedManager) {
            super("xpack/ml/datafeed", "ml_utility");
            this.datafeedManager = datafeedManager;
            this.resolver = new IndexNameExpressionResolver();
        }

        public PersistentTasksCustomMetaData.Assignment getAssignment(StartDatafeedAction.DatafeedParams params, ClusterState clusterState) {
            return new DatafeedNodeSelector(clusterState, this.resolver, params.getDatafeedId()).selectNode();
        }

        public void validate(StartDatafeedAction.DatafeedParams params, ClusterState clusterState) {
            PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)clusterState.getMetaData().custom("persistent_tasks");
            TransportStartDatafeedAction.validate(params.getDatafeedId(), MlMetadata.getMlMetadata((ClusterState)clusterState), tasks);
            new DatafeedNodeSelector(clusterState, this.resolver, params.getDatafeedId()).checkDatafeedTaskCanBeCreated();
        }

        protected void nodeOperation(AllocatedPersistentTask allocatedPersistentTask, StartDatafeedAction.DatafeedParams params, PersistentTaskState state) {
            DatafeedTask datafeedTask = (DatafeedTask)allocatedPersistentTask;
            datafeedTask.datafeedManager = this.datafeedManager;
            this.datafeedManager.run(datafeedTask, error -> {
                if (error != null) {
                    datafeedTask.markAsFailed((Exception)error);
                } else {
                    datafeedTask.markAsCompleted();
                }
            });
        }

        protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetaData.PersistentTask<StartDatafeedAction.DatafeedParams> persistentTask, Map<String, String> headers) {
            return new DatafeedTask(id, type, action, parentTaskId, (StartDatafeedAction.DatafeedParams)persistentTask.getParams(), headers);
        }
    }
}

