/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.GetJobsAction;
import org.elasticsearch.xpack.core.ml.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.JobManager;

public class TransportGetJobsAction
extends TransportMasterNodeReadAction<GetJobsAction.Request, GetJobsAction.Response> {
    private final JobManager jobManager;

    @Inject
    public TransportGetJobsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobManager jobManager) {
        super("cluster:monitor/xpack/ml/job/get", transportService, clusterService, threadPool, actionFilters, GetJobsAction.Request::new, indexNameExpressionResolver);
        this.jobManager = jobManager;
    }

    protected String executor() {
        return "same";
    }

    protected GetJobsAction.Response newResponse() {
        return new GetJobsAction.Response();
    }

    protected void masterOperation(GetJobsAction.Request request, ClusterState state, ActionListener<GetJobsAction.Response> listener) throws Exception {
        this.logger.debug("Get job '{}'", (Object)request.getJobId());
        QueryPage<Job> jobs = this.jobManager.expandJobs(request.getJobId(), request.allowNoJobs(), state);
        listener.onResponse((Object)new GetJobsAction.Response(jobs));
    }

    protected ClusterBlockException checkBlock(GetJobsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

