/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Date;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.FinalizeJobExecutionAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class TransportFinalizeJobExecutionAction
extends TransportMasterNodeAction<FinalizeJobExecutionAction.Request, AcknowledgedResponse> {
    @Inject
    public TransportFinalizeJobExecutionAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:internal/xpack/ml/job/finalize_job_execution", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, FinalizeJobExecutionAction.Request::new);
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    protected void masterOperation(final FinalizeJobExecutionAction.Request request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) throws Exception {
        final String jobIdString = String.join((CharSequence)",", request.getJobIds());
        String source = "finalize_job_execution [" + jobIdString + "]";
        this.logger.debug("finalizing jobs [{}]", (Object)jobIdString);
        this.clusterService.submitStateUpdateTask(source, (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) {
                XPackPlugin.checkReadyForXPackCustomMetadata((ClusterState)currentState);
                MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)currentState);
                MlMetadata.Builder mlMetadataBuilder = new MlMetadata.Builder(mlMetadata);
                Date finishedTime = new Date();
                for (String jobId : request.getJobIds()) {
                    Job.Builder jobBuilder = new Job.Builder((Job)mlMetadata.getJobs().get(jobId));
                    jobBuilder.setFinishedTime(finishedTime);
                    mlMetadataBuilder.putJob(jobBuilder.build(), true);
                }
                ClusterState.Builder builder = ClusterState.builder((ClusterState)currentState);
                return builder.metaData(new MetaData.Builder(currentState.metaData()).putCustom("ml", (MetaData.Custom)mlMetadataBuilder.build())).build();
            }

            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                TransportFinalizeJobExecutionAction.this.logger.debug("finalized job [{}]", (Object)jobIdString);
                listener.onResponse((Object)new AcknowledgedResponse(true));
            }
        });
    }

    protected ClusterBlockException checkBlock(FinalizeJobExecutionAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

