/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.deprecation.DeprecationInfoAction;
import org.elasticsearch.xpack.deprecation.DeprecationChecks;

public class TransportDeprecationInfoAction
extends TransportMasterNodeReadAction<DeprecationInfoAction.Request, DeprecationInfoAction.Response> {
    private final XPackLicenseState licenseState;
    private final NodeClient client;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportDeprecationInfoAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, XPackLicenseState licenseState, NodeClient client) {
        super("cluster:admin/xpack/deprecation/info", transportService, clusterService, threadPool, actionFilters, DeprecationInfoAction.Request::new, indexNameExpressionResolver);
        this.licenseState = licenseState;
        this.client = client;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    protected String executor() {
        return "generic";
    }

    protected DeprecationInfoAction.Response newResponse() {
        return new DeprecationInfoAction.Response();
    }

    protected ClusterBlockException checkBlock(DeprecationInfoAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected final void masterOperation(DeprecationInfoAction.Request request, ClusterState state, ActionListener<DeprecationInfoAction.Response> listener) {
        if (this.licenseState.isDeprecationAllowed()) {
            NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(new String[]{"_local"}).settings(true).plugins(true);
            NodesStatsRequest nodesStatsRequest = new NodesStatsRequest(new String[]{"_local"}).fs(true);
            ThreadContext threadContext = this.client.threadPool().getThreadContext();
            ClientHelper.executeAsyncWithOrigin((ThreadContext)threadContext, (String)"deprecation", (ActionRequest)nodesInfoRequest, (ActionListener)ActionListener.wrap(nodesInfoResponse -> {
                if (nodesInfoResponse.hasFailures()) {
                    throw (FailedNodeException)nodesInfoResponse.failures().get(0);
                }
                ClientHelper.executeAsyncWithOrigin((ThreadContext)threadContext, (String)"deprecation", (ActionRequest)nodesStatsRequest, (ActionListener)ActionListener.wrap(nodesStatsResponse -> {
                    if (nodesStatsResponse.hasFailures()) {
                        throw (FailedNodeException)nodesStatsResponse.failures().get(0);
                    }
                    listener.onResponse((Object)DeprecationInfoAction.Response.from((List)nodesInfoResponse.getNodes(), (List)nodesStatsResponse.getNodes(), (ClusterState)state, (IndexNameExpressionResolver)this.indexNameExpressionResolver, (String[])request.indices(), (IndicesOptions)request.indicesOptions(), DeprecationChecks.CLUSTER_SETTINGS_CHECKS, DeprecationChecks.NODE_SETTINGS_CHECKS, DeprecationChecks.INDEX_SETTINGS_CHECKS));
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)), (arg_0, arg_1) -> ((ClusterAdminClient)this.client.admin().cluster()).nodesStats(arg_0, arg_1));
            }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((ClusterAdminClient)this.client.admin().cluster()).nodesInfo(arg_0, arg_1));
        } else {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"deprecation"));
        }
    }
}

