/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.cleaner;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractLifecycleRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.monitoring.MonitoringField;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;

public class CleanerService
extends AbstractLifecycleComponent {
    private static final Logger logger = LogManager.getLogger(CleanerService.class);
    private final XPackLicenseState licenseState;
    private final ThreadPool threadPool;
    private final ExecutionScheduler executionScheduler;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final IndicesCleaner runnable;
    private volatile TimeValue globalRetention;

    CleanerService(Settings settings, ClusterSettings clusterSettings, XPackLicenseState licenseState, ThreadPool threadPool, ExecutionScheduler executionScheduler) {
        super(settings);
        this.licenseState = licenseState;
        this.threadPool = threadPool;
        this.executionScheduler = executionScheduler;
        this.globalRetention = (TimeValue)MonitoringField.HISTORY_DURATION.get(settings);
        this.runnable = new IndicesCleaner();
        clusterSettings.addSettingsUpdateConsumer(MonitoringField.HISTORY_DURATION, this::setGlobalRetention);
    }

    public CleanerService(Settings settings, ClusterSettings clusterSettings, ThreadPool threadPool, XPackLicenseState licenseState) {
        this(settings, clusterSettings, licenseState, threadPool, new DefaultExecutionScheduler());
    }

    protected void doStart() {
        logger.debug("starting cleaning service");
        this.threadPool.schedule(this.executionScheduler.nextExecutionDelay(new DateTime((Chronology)ISOChronology.getInstance())), this.executorName(), (Runnable)((Object)this.runnable));
        logger.debug("cleaning service started");
    }

    protected void doStop() {
        logger.debug("stopping cleaning service");
        this.listeners.clear();
        logger.debug("cleaning service stopped");
    }

    protected void doClose() {
        logger.debug("closing cleaning service");
        this.runnable.cancel();
        logger.debug("cleaning service closed");
    }

    private String executorName() {
        return "generic";
    }

    public TimeValue getRetention() {
        if (this.licenseState.isUpdateRetentionAllowed() && this.globalRetention != null) {
            return this.globalRetention;
        }
        return (TimeValue)MonitoringField.HISTORY_DURATION.getDefault(Settings.EMPTY);
    }

    public void setGlobalRetention(TimeValue globalRetention) {
        if (!this.licenseState.isUpdateRetentionAllowed()) {
            logger.warn("[{}] setting will be ignored until an appropriate license is applied", (Object)MonitoringField.HISTORY_DURATION.getKey());
        }
        this.globalRetention = globalRetention;
    }

    public void add(Listener listener) {
        this.listeners.add(listener);
    }

    public void remove(Listener listener) {
        this.listeners.remove(listener);
    }

    static class DefaultExecutionScheduler
    implements ExecutionScheduler {
        DefaultExecutionScheduler() {
        }

        @Override
        public TimeValue nextExecutionDelay(DateTime now) {
            DateTime next = now.withTimeAtStartOfDay().plusHours(1);
            if (!next.isAfter((ReadableInstant)now)) {
                next = next.plusDays(1);
            }
            return TimeValue.timeValueMillis((long)(next.getMillis() - now.getMillis()));
        }
    }

    static interface ExecutionScheduler {
        public TimeValue nextExecutionDelay(DateTime var1);
    }

    class IndicesCleaner
    extends AbstractLifecycleRunnable {
        private volatile ScheduledFuture<?> future;

        IndicesCleaner() {
            super(CleanerService.this.lifecycle, logger);
        }

        protected void doRunInLifecycle() throws Exception {
            if (!CleanerService.this.licenseState.isMonitoringAllowed()) {
                logger.debug("cleaning service is disabled due to invalid license");
                return;
            }
            TimeValue retention = CleanerService.this.getRetention();
            logger.trace("cleaning up indices with retention [{}]", (Object)retention);
            for (Listener listener : CleanerService.this.listeners) {
                try {
                    listener.onCleanUpIndices(retention);
                }
                catch (Exception e) {
                    logger.error("listener failed to clean indices", (Throwable)e);
                }
            }
            logger.trace("done cleaning up indices");
        }

        protected void onAfterInLifecycle() {
            DateTime start = new DateTime((Chronology)ISOChronology.getInstance());
            TimeValue delay = CleanerService.this.executionScheduler.nextExecutionDelay(start);
            logger.debug("scheduling next execution in [{}] seconds", (Object)delay.seconds());
            try {
                this.future = CleanerService.this.threadPool.schedule(delay, CleanerService.this.executorName(), (Runnable)((Object)this));
            }
            catch (EsRejectedExecutionException e) {
                if (e.isExecutorShutdown()) {
                    logger.debug("couldn't schedule new execution of the cleaner, executor is shutting down", (Throwable)e);
                }
                throw e;
            }
        }

        public void onFailure(Exception e) {
            logger.error("failed to clean indices", (Throwable)e);
        }

        public void cancel() {
            if (this.future != null && !this.future.isCancelled()) {
                FutureUtils.cancel(this.future);
            }
        }
    }

    public static interface Listener {
        public void onCleanUpIndices(TimeValue var1);
    }
}

