/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.ParameterMap;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SearchLookup;

public abstract class TermsSetQueryScript {
    public static final String[] PARAMETERS = new String[0];
    public static final ScriptContext<Factory> CONTEXT = new ScriptContext<Factory>("terms_set", Factory.class);
    private static final Map<String, String> DEPRECATIONS;
    private final Map<String, Object> params;
    private final LeafSearchLookup leafLookup;

    public TermsSetQueryScript(Map<String, Object> params, SearchLookup lookup, LeafReaderContext leafContext) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(params);
        this.leafLookup = lookup.getLeafSearchLookup(leafContext);
        parameters.putAll(this.leafLookup.asMap());
        this.params = new ParameterMap(parameters, DEPRECATIONS);
    }

    protected TermsSetQueryScript() {
        this.params = null;
        this.leafLookup = null;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Map<String, ScriptDocValues<?>> getDoc() {
        return this.leafLookup.doc();
    }

    public void setDocument(int docid) {
        this.leafLookup.setDocument(docid);
    }

    public long runAsLong() {
        return this.execute().longValue();
    }

    public abstract Number execute();

    static {
        HashMap<String, String> deprecations = new HashMap<String, String>();
        deprecations.put("doc", "Accessing variable [doc] via [params.doc] from within a terms-set-query-script is deprecated in favor of directly accessing [doc].");
        deprecations.put("_doc", "Accessing variable [doc] via [params._doc] from within a terms-set-query-script is deprecated in favor of directly accessing [doc].");
        DEPRECATIONS = Collections.unmodifiableMap(deprecations);
    }

    public static interface Factory {
        public LeafFactory newFactory(Map<String, Object> var1, SearchLookup var2);
    }

    public static interface LeafFactory {
        public TermsSetQueryScript newInstance(LeafReaderContext var1) throws IOException;
    }
}

