/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;

public class RestPutMappingAction
extends BaseRestHandler {
    public RestPutMappingAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_mapping/", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/{type}/_mapping", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mapping/", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_mapping", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_mappings/", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/{type}/_mappings", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_mappings/{type}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_mappings/{type}", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mappings/", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_mappings", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mappings/{type}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_mappings/{type}", this);
    }

    @Override
    public String getName() {
        return "put_mapping_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        boolean includeTypeName = request.paramAsBoolean("include_type_name", true);
        PutMappingRequest putMappingRequest = Requests.putMappingRequest(Strings.splitStringByCommaToArray(request.param("index")));
        String type = request.param("type");
        if (type != null && !includeTypeName) {
            throw new IllegalArgumentException("Cannot set include_type_name=false and provide a type at the same time");
        }
        putMappingRequest.type(includeTypeName ? type : "_doc");
        putMappingRequest.source(request.requiredContent(), request.getXContentType());
        putMappingRequest.timeout(request.paramAsTime("timeout", putMappingRequest.timeout()));
        putMappingRequest.masterNodeTimeout(request.paramAsTime("master_timeout", putMappingRequest.masterNodeTimeout()));
        putMappingRequest.indicesOptions(IndicesOptions.fromRequest(request, putMappingRequest.indicesOptions()));
        return channel -> client.admin().indices().putMapping(putMappingRequest, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }
}

