/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import org.elasticsearch.common.collect.CopyOnWriteHashMap;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.mapper.FieldAliasMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;

class FieldTypeLookup
implements Iterable<MappedFieldType> {
    final CopyOnWriteHashMap<String, MappedFieldType> fullNameToFieldType;
    private final CopyOnWriteHashMap<String, String> aliasToConcreteName;

    FieldTypeLookup() {
        this.fullNameToFieldType = new CopyOnWriteHashMap();
        this.aliasToConcreteName = new CopyOnWriteHashMap();
    }

    private FieldTypeLookup(CopyOnWriteHashMap<String, MappedFieldType> fullNameToFieldType, CopyOnWriteHashMap<String, String> aliasToConcreteName) {
        this.fullNameToFieldType = fullNameToFieldType;
        this.aliasToConcreteName = aliasToConcreteName;
    }

    public FieldTypeLookup copyAndAddAll(String type, Collection<FieldMapper> fieldMappers, Collection<FieldAliasMapper> fieldAliasMappers) {
        Objects.requireNonNull(type, "type must not be null");
        if ("_default_".equals(type)) {
            throw new IllegalArgumentException("Default mappings should not be added to the lookup");
        }
        CopyOnWriteHashMap<String, MappedFieldType> fullName = this.fullNameToFieldType;
        CopyOnWriteHashMap<String, String> aliases = this.aliasToConcreteName;
        for (FieldMapper fieldMapper : fieldMappers) {
            MappedFieldType fullNameFieldType;
            MappedFieldType fieldType = fieldMapper.fieldType();
            if (Objects.equals(fieldType, fullNameFieldType = fullName.get(fieldType.name()))) continue;
            this.validateField(fullNameFieldType, fieldType, aliases);
            fullName = fullName.copyAndPut(fieldType.name(), fieldType);
        }
        for (FieldAliasMapper fieldAliasMapper : fieldAliasMappers) {
            String aliasName = fieldAliasMapper.name();
            String path = fieldAliasMapper.path();
            this.validateAlias(aliasName, path, aliases, fullName);
            aliases = aliases.copyAndPut(aliasName, path);
        }
        return new FieldTypeLookup(fullName, aliases);
    }

    private void validateField(MappedFieldType existingFieldType, MappedFieldType newFieldType, CopyOnWriteHashMap<String, String> aliasToConcreteName) {
        String fieldName = newFieldType.name();
        if (aliasToConcreteName.containsKey(fieldName)) {
            throw new IllegalArgumentException("The name for field [" + fieldName + "] has already been used to define a field alias.");
        }
        if (existingFieldType != null) {
            ArrayList<String> conflicts = new ArrayList<String>();
            existingFieldType.checkCompatibility(newFieldType, conflicts);
            if (!conflicts.isEmpty()) {
                throw new IllegalArgumentException("Mapper for [" + fieldName + "] conflicts with existing mapping:\n" + ((Object)conflicts).toString());
            }
        }
    }

    private void validateAlias(String aliasName, String path, CopyOnWriteHashMap<String, String> aliasToConcreteName, CopyOnWriteHashMap<String, MappedFieldType> fullNameToFieldType) {
        if (fullNameToFieldType.containsKey(aliasName)) {
            throw new IllegalArgumentException("The name for field alias [" + aliasName + "] has already been used to define a concrete field.");
        }
        if (path.equals(aliasName)) {
            throw new IllegalArgumentException("Invalid [path] value [" + path + "] for field alias [" + aliasName + "]: an alias cannot refer to itself.");
        }
        if (aliasToConcreteName.containsKey(path)) {
            throw new IllegalArgumentException("Invalid [path] value [" + path + "] for field alias [" + aliasName + "]: an alias cannot refer to another alias.");
        }
        if (!fullNameToFieldType.containsKey(path)) {
            throw new IllegalArgumentException("Invalid [path] value [" + path + "] for field alias [" + aliasName + "]: an alias must refer to an existing field in the mappings.");
        }
    }

    public MappedFieldType get(String field) {
        String concreteField = this.aliasToConcreteName.getOrDefault(field, field);
        return this.fullNameToFieldType.get(concreteField);
    }

    public Collection<String> simpleMatchToFullName(String pattern) {
        HashSet<String> fields = new HashSet<String>();
        for (MappedFieldType fieldType : this) {
            if (!Regex.simpleMatch(pattern, fieldType.name())) continue;
            fields.add(fieldType.name());
        }
        for (String aliasName : this.aliasToConcreteName.keySet()) {
            if (!Regex.simpleMatch(pattern, aliasName)) continue;
            fields.add(aliasName);
        }
        return fields;
    }

    @Override
    public Iterator<MappedFieldType> iterator() {
        return this.fullNameToFieldType.values().iterator();
    }
}

