/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.UnaryOperator;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.script.JodaCompatibleZonedDateTime;

public abstract class ScriptDocValues<T>
extends AbstractList<T> {
    public abstract void setNextDocId(int var1) throws IOException;

    @Override
    public final void add(int index, T element) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    @Override
    public final boolean remove(Object o) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    @Override
    public final void replaceAll(UnaryOperator<T> operator) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    @Override
    public final T set(int index, T element) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    @Override
    public final void sort(Comparator<? super T> c) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    public static final class BytesRefs
    extends BinaryScriptDocValues<BytesRef> {
        public BytesRefs(SortedBinaryDocValues in) {
            super(in);
        }

        @Override
        public BytesRef get(int index) {
            return this.values[index].toBytesRef();
        }

        public BytesRef getValue() {
            if (this.count == 0) {
                throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
            }
            return this.get(0);
        }
    }

    public static final class Strings
    extends BinaryScriptDocValues<String> {
        public Strings(SortedBinaryDocValues in) {
            super(in);
        }

        @Override
        public String get(int index) {
            return this.values[index].get().utf8ToString();
        }

        public String getValue() {
            if (this.count == 0) {
                throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
            }
            return this.get(0);
        }
    }

    static abstract class BinaryScriptDocValues<T>
    extends ScriptDocValues<T> {
        private final SortedBinaryDocValues in;
        protected BytesRefBuilder[] values = new BytesRefBuilder[0];
        protected int count;

        BinaryScriptDocValues(SortedBinaryDocValues in) {
            this.in = in;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            if (this.in.advanceExact(docId)) {
                this.resize(this.in.docValueCount());
                for (int i = 0; i < this.count; ++i) {
                    this.values[i].copyBytes(this.in.nextValue());
                }
            } else {
                this.resize(0);
            }
        }

        protected void resize(int newSize) {
            this.count = newSize;
            if (newSize > this.values.length) {
                int oldLength = this.values.length;
                this.values = ArrayUtil.grow(this.values, this.count);
                for (int i = oldLength; i < this.values.length; ++i) {
                    this.values[i] = new BytesRefBuilder();
                }
            }
        }

        @Override
        public int size() {
            return this.count;
        }
    }

    public static final class Booleans
    extends ScriptDocValues<Boolean> {
        private final SortedNumericDocValues in;
        private boolean[] values = new boolean[0];
        private int count;

        public Booleans(SortedNumericDocValues in) {
            this.in = in;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            if (this.in.advanceExact(docId)) {
                this.resize(this.in.docValueCount());
                for (int i = 0; i < this.count; ++i) {
                    this.values[i] = this.in.nextValue() == 1L;
                }
            } else {
                this.resize(0);
            }
        }

        protected void resize(int newSize) {
            this.count = newSize;
            this.values = Booleans.grow(this.values, this.count);
        }

        public boolean getValue() {
            if (this.count == 0) {
                throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
            }
            return this.values[0];
        }

        @Override
        public Boolean get(int index) {
            return this.values[index];
        }

        @Override
        public int size() {
            return this.count;
        }

        private static boolean[] grow(boolean[] array, int minSize) {
            assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
            if (array.length < minSize) {
                return Arrays.copyOf(array, ArrayUtil.oversize(minSize, 1));
            }
            return array;
        }
    }

    public static final class GeoPoints
    extends ScriptDocValues<GeoPoint> {
        private final MultiGeoPointValues in;
        private GeoPoint[] values = new GeoPoint[0];
        private int count;

        public GeoPoints(MultiGeoPointValues in) {
            this.in = in;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            if (this.in.advanceExact(docId)) {
                this.resize(this.in.docValueCount());
                for (int i = 0; i < this.count; ++i) {
                    GeoPoint point = this.in.nextValue();
                    this.values[i] = new GeoPoint(point.lat(), point.lon());
                }
            } else {
                this.resize(0);
            }
        }

        protected void resize(int newSize) {
            this.count = newSize;
            if (newSize > this.values.length) {
                int oldLength = this.values.length;
                this.values = ArrayUtil.grow(this.values, this.count);
                for (int i = oldLength; i < this.values.length; ++i) {
                    this.values[i] = new GeoPoint();
                }
            }
        }

        public GeoPoint getValue() {
            if (this.count == 0) {
                throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
            }
            return this.values[0];
        }

        public double getLat() {
            return this.getValue().lat();
        }

        public double[] getLats() {
            double[] lats = new double[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                lats[i] = this.get(i).lat();
            }
            return lats;
        }

        public double[] getLons() {
            double[] lons = new double[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                lons[i] = this.get(i).lon();
            }
            return lons;
        }

        public double getLon() {
            return this.getValue().lon();
        }

        @Override
        public GeoPoint get(int index) {
            GeoPoint point = this.values[index];
            return new GeoPoint(point.lat(), point.lon());
        }

        @Override
        public int size() {
            return this.count;
        }

        public double arcDistance(double lat, double lon) {
            GeoPoint point = this.getValue();
            return GeoUtils.arcDistance(point.lat(), point.lon(), lat, lon);
        }

        public double arcDistanceWithDefault(double lat, double lon, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.arcDistance(lat, lon);
        }

        public double planeDistance(double lat, double lon) {
            GeoPoint point = this.getValue();
            return GeoUtils.planeDistance(point.lat(), point.lon(), lat, lon);
        }

        public double planeDistanceWithDefault(double lat, double lon, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.planeDistance(lat, lon);
        }

        public double geohashDistance(String geohash) {
            GeoPoint point = this.getValue();
            return GeoUtils.arcDistance(point.lat(), point.lon(), GeoHashUtils.decodeLatitude(geohash), GeoHashUtils.decodeLongitude(geohash));
        }

        public double geohashDistanceWithDefault(String geohash, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.geohashDistance(geohash);
        }
    }

    public static final class Doubles
    extends ScriptDocValues<Double> {
        private final SortedNumericDoubleValues in;
        private double[] values = new double[0];
        private int count;

        public Doubles(SortedNumericDoubleValues in) {
            this.in = in;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            if (this.in.advanceExact(docId)) {
                this.resize(this.in.docValueCount());
                for (int i = 0; i < this.count; ++i) {
                    this.values[i] = this.in.nextValue();
                }
            } else {
                this.resize(0);
            }
        }

        protected void resize(int newSize) {
            this.count = newSize;
            this.values = ArrayUtil.grow(this.values, this.count);
        }

        public SortedNumericDoubleValues getInternalValues() {
            return this.in;
        }

        public double getValue() {
            if (this.count == 0) {
                throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
            }
            return this.values[0];
        }

        @Override
        public Double get(int index) {
            return this.values[index];
        }

        @Override
        public int size() {
            return this.count;
        }
    }

    public static final class Dates
    extends ScriptDocValues<JodaCompatibleZonedDateTime> {
        private final SortedNumericDocValues in;
        private JodaCompatibleZonedDateTime[] dates;
        private int count;

        public Dates(SortedNumericDocValues in) {
            this.in = in;
        }

        public JodaCompatibleZonedDateTime getValue() {
            if (this.count == 0) {
                throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
            }
            return this.get(0);
        }

        @Override
        public JodaCompatibleZonedDateTime get(int index) {
            if (index >= this.count) {
                throw new IndexOutOfBoundsException("attempted to fetch the [" + index + "] date when there are only [" + this.count + "] dates.");
            }
            return this.dates[index];
        }

        @Override
        public int size() {
            return this.count;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            this.count = this.in.advanceExact(docId) ? this.in.docValueCount() : 0;
            this.refreshArray();
        }

        void refreshArray() throws IOException {
            if (this.count == 0) {
                return;
            }
            if (this.dates == null || this.count > this.dates.length) {
                this.dates = new JodaCompatibleZonedDateTime[this.count];
            }
            for (int i = 0; i < this.count; ++i) {
                this.dates[i] = new JodaCompatibleZonedDateTime(Instant.ofEpochMilli(this.in.nextValue()), ZoneOffset.UTC);
            }
        }
    }

    public static final class Longs
    extends ScriptDocValues<Long> {
        private final SortedNumericDocValues in;
        private long[] values = new long[0];
        private int count;

        public Longs(SortedNumericDocValues in) {
            this.in = in;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            if (this.in.advanceExact(docId)) {
                this.resize(this.in.docValueCount());
                for (int i = 0; i < this.count; ++i) {
                    this.values[i] = this.in.nextValue();
                }
            } else {
                this.resize(0);
            }
        }

        protected void resize(int newSize) {
            this.count = newSize;
            this.values = ArrayUtil.grow(this.values, this.count);
        }

        public long getValue() {
            if (this.count == 0) {
                throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
            }
            return this.values[0];
        }

        @Override
        public Long get(int index) {
            return this.values[index];
        }

        @Override
        public int size() {
            return this.count;
        }
    }
}

