/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.cursors.IntCursor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.NetworkExceptionHelper;
import org.elasticsearch.common.transport.PortsRange;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.http.BindHttpException;
import org.elasticsearch.http.DefaultRestChannel;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpHandlingSettings;
import org.elasticsearch.http.HttpInfo;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpServerChannel;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.HttpStats;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BindTransportException;

public abstract class AbstractHttpServerTransport
extends AbstractLifecycleComponent
implements HttpServerTransport {
    private static final Logger logger = LogManager.getLogger(AbstractHttpServerTransport.class);
    protected final Settings settings;
    public final HttpHandlingSettings handlingSettings;
    protected final NetworkService networkService;
    protected final BigArrays bigArrays;
    protected final ThreadPool threadPool;
    protected final HttpServerTransport.Dispatcher dispatcher;
    private final NamedXContentRegistry xContentRegistry;
    protected final PortsRange port;
    protected final ByteSizeValue maxContentLength;
    private final String[] bindHosts;
    private final String[] publishHosts;
    private volatile BoundTransportAddress boundAddress;
    private final AtomicLong totalChannelsAccepted = new AtomicLong();
    private final Set<HttpChannel> httpChannels = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<HttpServerChannel> httpServerChannels = Collections.newSetFromMap(new ConcurrentHashMap());

    protected AbstractHttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, HttpServerTransport.Dispatcher dispatcher) {
        super(settings);
        this.settings = settings;
        this.networkService = networkService;
        this.bigArrays = bigArrays;
        this.threadPool = threadPool;
        this.xContentRegistry = xContentRegistry;
        this.dispatcher = dispatcher;
        this.handlingSettings = HttpHandlingSettings.fromSettings(settings);
        List<String> httpBindHost = HttpTransportSettings.SETTING_HTTP_BIND_HOST.get(settings);
        this.bindHosts = (httpBindHost.isEmpty() ? NetworkService.GLOBAL_NETWORK_BIND_HOST_SETTING.get(settings) : httpBindHost).toArray(Strings.EMPTY_ARRAY);
        List<String> httpPublishHost = HttpTransportSettings.SETTING_HTTP_PUBLISH_HOST.get(settings);
        this.publishHosts = (httpPublishHost.isEmpty() ? NetworkService.GLOBAL_NETWORK_PUBLISH_HOST_SETTING.get(settings) : httpPublishHost).toArray(Strings.EMPTY_ARRAY);
        this.port = HttpTransportSettings.SETTING_HTTP_PORT.get(settings);
        this.maxContentLength = HttpTransportSettings.SETTING_HTTP_MAX_CONTENT_LENGTH.get(settings);
    }

    @Override
    public BoundTransportAddress boundAddress() {
        return this.boundAddress;
    }

    @Override
    public HttpInfo info() {
        BoundTransportAddress boundTransportAddress = this.boundAddress();
        if (boundTransportAddress == null) {
            return null;
        }
        return new HttpInfo(boundTransportAddress, this.maxContentLength.getBytes());
    }

    @Override
    public HttpStats stats() {
        return new HttpStats(this.httpChannels.size(), this.totalChannelsAccepted.get());
    }

    protected void bindServer() {
        InetAddress publishInetAddress;
        InetAddress[] hostAddresses;
        try {
            hostAddresses = this.networkService.resolveBindHostAddresses(this.bindHosts);
        }
        catch (IOException e) {
            throw new BindHttpException("Failed to resolve host [" + Arrays.toString(this.bindHosts) + "]", e);
        }
        ArrayList<TransportAddress> boundAddresses = new ArrayList<TransportAddress>(hostAddresses.length);
        for (InetAddress address : hostAddresses) {
            boundAddresses.add(this.bindAddress(address));
        }
        try {
            publishInetAddress = this.networkService.resolvePublishHostAddresses(this.publishHosts);
        }
        catch (Exception e) {
            throw new BindTransportException("Failed to resolve publish address", e);
        }
        int publishPort = AbstractHttpServerTransport.resolvePublishPort(this.settings, boundAddresses, publishInetAddress);
        TransportAddress publishAddress = new TransportAddress(new InetSocketAddress(publishInetAddress, publishPort));
        this.boundAddress = new BoundTransportAddress(boundAddresses.toArray(new TransportAddress[0]), publishAddress);
        logger.info("{}", (Object)this.boundAddress);
    }

    private TransportAddress bindAddress(InetAddress hostAddress) {
        AtomicReference boundSocket = new AtomicReference();
        AtomicReference lastException = new AtomicReference();
        boolean success = this.port.iterate(portNumber -> {
            try {
                Set<HttpServerChannel> set = this.httpServerChannels;
                synchronized (set) {
                    HttpServerChannel httpServerChannel = this.bind(new InetSocketAddress(hostAddress, portNumber));
                    this.httpServerChannels.add(httpServerChannel);
                    boundSocket.set(httpServerChannel.getLocalAddress());
                }
            }
            catch (Exception e) {
                lastException.set(e);
                return false;
            }
            return true;
        });
        if (!success) {
            throw new BindHttpException("Failed to bind to [" + this.port.getPortRangeString() + "]", (Throwable)lastException.get());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Bound http to address {{}}", (Object)NetworkAddress.format((InetSocketAddress)boundSocket.get()));
        }
        return new TransportAddress((InetSocketAddress)boundSocket.get());
    }

    protected abstract HttpServerChannel bind(InetSocketAddress var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() {
        Set<HttpServerChannel> set = this.httpServerChannels;
        synchronized (set) {
            if (!this.httpServerChannels.isEmpty()) {
                try {
                    CloseableChannel.closeChannels(new ArrayList<HttpServerChannel>(this.httpServerChannels), true);
                }
                catch (Exception e) {
                    logger.warn("exception while closing channels", (Throwable)e);
                }
                finally {
                    this.httpServerChannels.clear();
                }
            }
        }
        try {
            CloseableChannel.closeChannels(new ArrayList<HttpChannel>(this.httpChannels), true);
        }
        catch (Exception e) {
            logger.warn("unexpected exception while closing http channels", (Throwable)e);
        }
        this.httpChannels.clear();
        this.stopInternal();
    }

    @Override
    protected void doClose() {
    }

    protected abstract void stopInternal();

    static int resolvePublishPort(Settings settings, List<TransportAddress> boundAddresses, InetAddress publishInetAddress) {
        int publishPort = HttpTransportSettings.SETTING_HTTP_PUBLISH_PORT.get(settings);
        if (publishPort < 0) {
            for (TransportAddress boundAddress : boundAddresses) {
                InetAddress boundInetAddress = boundAddress.address().getAddress();
                if (!boundInetAddress.isAnyLocalAddress() && !boundInetAddress.equals(publishInetAddress)) continue;
                publishPort = boundAddress.getPort();
                break;
            }
        }
        if (publishPort < 0) {
            IntHashSet ports = new IntHashSet();
            for (TransportAddress boundAddress : boundAddresses) {
                ports.add(boundAddress.getPort());
            }
            if (ports.size() == 1) {
                publishPort = ((IntCursor)ports.iterator().next()).value;
            }
        }
        if (publishPort < 0) {
            throw new BindHttpException("Failed to auto-resolve http publish port, multiple bound addresses " + boundAddresses + " with distinct ports and none of them matched the publish address (" + publishInetAddress + "). Please specify a unique port by setting " + HttpTransportSettings.SETTING_HTTP_PORT.getKey() + " or " + HttpTransportSettings.SETTING_HTTP_PUBLISH_PORT.getKey());
        }
        return publishPort;
    }

    protected void onException(HttpChannel channel, Exception e) {
        if (!this.lifecycle.started()) {
            CloseableChannel.closeChannel(channel);
            return;
        }
        if (NetworkExceptionHelper.isCloseConnectionException(e)) {
            logger.trace(() -> new ParameterizedMessage("close connection exception caught while handling client http traffic, closing connection {}", (Object)channel), (Throwable)e);
            CloseableChannel.closeChannel(channel);
        } else if (NetworkExceptionHelper.isConnectException(e)) {
            logger.trace(() -> new ParameterizedMessage("connect exception caught while handling client http traffic, closing connection {}", (Object)channel), (Throwable)e);
            CloseableChannel.closeChannel(channel);
        } else if (e instanceof CancelledKeyException) {
            logger.trace(() -> new ParameterizedMessage("cancelled key exception caught while handling client http traffic, closing connection {}", (Object)channel), (Throwable)e);
            CloseableChannel.closeChannel(channel);
        } else {
            logger.warn(() -> new ParameterizedMessage("caught exception while handling client http traffic, closing connection {}", (Object)channel), (Throwable)e);
            CloseableChannel.closeChannel(channel);
        }
    }

    protected void onServerException(HttpServerChannel channel, Exception e) {
        logger.error(new ParameterizedMessage("exception from http server channel caught on transport layer [channel={}]", (Object)channel), (Throwable)e);
    }

    protected void onNonChannelException(Exception exception) {
        String threadName = Thread.currentThread().getName();
        logger.warn(new ParameterizedMessage("exception caught on transport layer [thread={}]", (Object)threadName), (Throwable)exception);
    }

    protected void serverAcceptedChannel(HttpChannel httpChannel) {
        boolean addedOnThisCall = this.httpChannels.add(httpChannel);
        assert (addedOnThisCall) : "Channel should only be added to http channel set once";
        this.totalChannelsAccepted.incrementAndGet();
        httpChannel.addCloseListener(ActionListener.wrap(() -> this.httpChannels.remove(httpChannel)));
        logger.trace(() -> new ParameterizedMessage("Http channel accepted: {}", (Object)httpChannel));
    }

    public void incomingRequest(HttpRequest httpRequest, HttpChannel httpChannel) {
        this.handleIncomingRequest(httpRequest, httpChannel, null);
    }

    public void incomingRequestError(HttpRequest httpRequest, HttpChannel httpChannel, Exception exception) {
        this.handleIncomingRequest(httpRequest, httpChannel, exception);
    }

    void dispatchRequest(RestRequest restRequest, RestChannel channel, Throwable badRequestCause) {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            if (badRequestCause != null) {
                this.dispatcher.dispatchBadRequest(restRequest, channel, threadContext, badRequestCause);
            } else {
                this.dispatcher.dispatchRequest(restRequest, channel, threadContext);
            }
        }
    }

    private void handleIncomingRequest(HttpRequest httpRequest, HttpChannel httpChannel, Exception exception) {
        DefaultRestChannel innerChannel;
        RestRequest innerRestRequest;
        Exception badRequestCause = exception;
        try {
            innerRestRequest = RestRequest.request(this.xContentRegistry, httpRequest, httpChannel);
        }
        catch (RestRequest.ContentTypeHeaderException e) {
            badRequestCause = ExceptionsHelper.useOrSuppress(badRequestCause, e);
            innerRestRequest = this.requestWithoutContentTypeHeader(httpRequest, httpChannel, badRequestCause);
        }
        catch (RestRequest.BadParameterException e) {
            badRequestCause = ExceptionsHelper.useOrSuppress(badRequestCause, e);
            innerRestRequest = RestRequest.requestWithoutParameters(this.xContentRegistry, httpRequest, httpChannel);
        }
        RestRequest restRequest = innerRestRequest;
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try {
            innerChannel = new DefaultRestChannel(httpChannel, httpRequest, restRequest, this.bigArrays, this.handlingSettings, threadContext);
        }
        catch (IllegalArgumentException e) {
            badRequestCause = ExceptionsHelper.useOrSuppress(badRequestCause, e);
            RestRequest innerRequest = RestRequest.requestWithoutParameters(this.xContentRegistry, httpRequest, httpChannel);
            innerChannel = new DefaultRestChannel(httpChannel, httpRequest, innerRequest, this.bigArrays, this.handlingSettings, threadContext);
        }
        DefaultRestChannel channel = innerChannel;
        this.dispatchRequest(restRequest, channel, badRequestCause);
    }

    private RestRequest requestWithoutContentTypeHeader(HttpRequest httpRequest, HttpChannel httpChannel, Exception badRequestCause) {
        HttpRequest httpRequestWithoutContentType = httpRequest.removeHeader("Content-Type");
        try {
            return RestRequest.request(this.xContentRegistry, httpRequestWithoutContentType, httpChannel);
        }
        catch (RestRequest.BadParameterException e) {
            badRequestCause.addSuppressed(e);
            return RestRequest.requestWithoutParameters(this.xContentRegistry, httpRequestWithoutContentType, httpChannel);
        }
    }
}

