/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.Manifest;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.MetaDataStateFormat;
import org.elasticsearch.gateway.WriteStateException;
import org.elasticsearch.index.Index;

public class MetaStateService {
    private static final Logger logger = LogManager.getLogger(MetaStateService.class);
    private final NodeEnvironment nodeEnv;
    private final NamedXContentRegistry namedXContentRegistry;
    protected MetaDataStateFormat<MetaData> META_DATA_FORMAT = MetaData.FORMAT;
    protected MetaDataStateFormat<IndexMetaData> INDEX_META_DATA_FORMAT = IndexMetaData.FORMAT;
    protected MetaDataStateFormat<Manifest> MANIFEST_FORMAT = Manifest.FORMAT;

    public MetaStateService(NodeEnvironment nodeEnv, NamedXContentRegistry namedXContentRegistry) {
        this.nodeEnv = nodeEnv;
        this.namedXContentRegistry = namedXContentRegistry;
    }

    Tuple<Manifest, MetaData> loadFullState() throws IOException {
        MetaData.Builder metaDataBuilder;
        Manifest manifest = this.MANIFEST_FORMAT.loadLatestState(logger, this.namedXContentRegistry, this.nodeEnv.nodeDataPaths());
        if (manifest == null) {
            return this.loadFullStateBWC();
        }
        if (manifest.isGlobalGenerationMissing()) {
            metaDataBuilder = MetaData.builder();
        } else {
            MetaData globalMetaData = this.META_DATA_FORMAT.loadGeneration(logger, this.namedXContentRegistry, manifest.getGlobalGeneration(), this.nodeEnv.nodeDataPaths());
            if (globalMetaData != null) {
                metaDataBuilder = MetaData.builder(globalMetaData);
            } else {
                throw new IOException("failed to find global metadata [generation: " + manifest.getGlobalGeneration() + "]");
            }
        }
        for (Map.Entry<Index, Long> entry : manifest.getIndexGenerations().entrySet()) {
            String indexFolderName;
            Index index = entry.getKey();
            long generation = entry.getValue();
            IndexMetaData indexMetaData = this.INDEX_META_DATA_FORMAT.loadGeneration(logger, this.namedXContentRegistry, generation, this.nodeEnv.resolveIndexFolder(indexFolderName = index.getUUID()));
            if (indexMetaData != null) {
                metaDataBuilder.put(indexMetaData, false);
                continue;
            }
            throw new IOException("failed to find metadata for existing index " + index.getName() + " [location: " + indexFolderName + ", generation: " + generation + "]");
        }
        return new Tuple<Manifest, MetaData>(manifest, metaDataBuilder.build());
    }

    private Tuple<Manifest, MetaData> loadFullStateBWC() throws IOException {
        MetaData.Builder metaDataBuilder;
        HashMap<Index, Long> indices = new HashMap<Index, Long>();
        Tuple<MetaData, Long> metaDataAndGeneration = this.META_DATA_FORMAT.loadLatestStateWithGeneration(logger, this.namedXContentRegistry, this.nodeEnv.nodeDataPaths());
        MetaData globalMetaData = metaDataAndGeneration.v1();
        long globalStateGeneration = metaDataAndGeneration.v2();
        if (globalMetaData != null) {
            metaDataBuilder = MetaData.builder(globalMetaData);
            assert (Version.CURRENT.major < 8) : "failed to find manifest file, which is mandatory staring with Elasticsearch version 8.0";
        } else {
            metaDataBuilder = MetaData.builder();
        }
        for (String indexFolderName : this.nodeEnv.availableIndexFolders()) {
            Tuple<IndexMetaData, Long> indexMetaDataAndGeneration = this.INDEX_META_DATA_FORMAT.loadLatestStateWithGeneration(logger, this.namedXContentRegistry, this.nodeEnv.resolveIndexFolder(indexFolderName));
            assert (Version.CURRENT.major < 8) : "failed to find manifest file, which is mandatory staring with Elasticsearch version 8.0";
            IndexMetaData indexMetaData = indexMetaDataAndGeneration.v1();
            long generation = indexMetaDataAndGeneration.v2();
            if (indexMetaData != null) {
                indices.put(indexMetaData.getIndex(), generation);
                metaDataBuilder.put(indexMetaData, false);
                continue;
            }
            logger.debug("[{}] failed to find metadata for existing index location", (Object)indexFolderName);
        }
        Manifest manifest = Manifest.unknownCurrentTermAndVersion(globalStateGeneration, indices);
        return new Tuple<Manifest, MetaData>(manifest, metaDataBuilder.build());
    }

    @Nullable
    public IndexMetaData loadIndexState(Index index) throws IOException {
        return this.INDEX_META_DATA_FORMAT.loadLatestState(logger, this.namedXContentRegistry, this.nodeEnv.indexPaths(index));
    }

    List<IndexMetaData> loadIndicesStates(Predicate<String> excludeIndexPathIdsPredicate) throws IOException {
        ArrayList<IndexMetaData> indexMetaDataList = new ArrayList<IndexMetaData>();
        for (String indexFolderName : this.nodeEnv.availableIndexFolders(excludeIndexPathIdsPredicate)) {
            assert (!excludeIndexPathIdsPredicate.test(indexFolderName)) : "unexpected folder " + indexFolderName + " which should have been excluded";
            IndexMetaData indexMetaData = this.INDEX_META_DATA_FORMAT.loadLatestState(logger, this.namedXContentRegistry, this.nodeEnv.resolveIndexFolder(indexFolderName));
            if (indexMetaData != null) {
                String indexPathId = indexMetaData.getIndex().getUUID();
                if (indexFolderName.equals(indexPathId)) {
                    indexMetaDataList.add(indexMetaData);
                    continue;
                }
                throw new IllegalStateException("[" + indexFolderName + "] invalid index folder name, rename to [" + indexPathId + "]");
            }
            logger.debug("[{}] failed to find metadata for existing index location", (Object)indexFolderName);
        }
        return indexMetaDataList;
    }

    public Manifest loadManifestOrEmpty() throws IOException {
        Manifest manifest = this.MANIFEST_FORMAT.loadLatestState(logger, this.namedXContentRegistry, this.nodeEnv.nodeDataPaths());
        if (manifest == null) {
            manifest = Manifest.empty();
        }
        return manifest;
    }

    MetaData loadGlobalState() throws IOException {
        return this.META_DATA_FORMAT.loadLatestState(logger, this.namedXContentRegistry, this.nodeEnv.nodeDataPaths());
    }

    public long writeManifestAndCleanup(String reason, Manifest manifest) throws WriteStateException {
        logger.trace("[_meta] writing state, reason [{}]", (Object)reason);
        try {
            long generation = this.MANIFEST_FORMAT.writeAndCleanup(manifest, this.nodeEnv.nodeDataPaths());
            logger.trace("[_meta] state written (generation: {})", (Object)generation);
            return generation;
        }
        catch (WriteStateException ex) {
            throw new WriteStateException(ex.isDirty(), "[_meta]: failed to write meta state", ex);
        }
    }

    public long writeIndex(String reason, IndexMetaData indexMetaData) throws WriteStateException {
        Index index = indexMetaData.getIndex();
        logger.trace("[{}] writing state, reason [{}]", (Object)index, (Object)reason);
        try {
            long generation = this.INDEX_META_DATA_FORMAT.write(indexMetaData, this.nodeEnv.indexPaths(indexMetaData.getIndex()));
            logger.trace("[{}] state written", (Object)index);
            return generation;
        }
        catch (WriteStateException ex) {
            throw new WriteStateException(false, "[" + index + "]: failed to write index state", ex);
        }
    }

    long writeGlobalState(String reason, MetaData metaData) throws WriteStateException {
        logger.trace("[_global] writing state, reason [{}]", (Object)reason);
        try {
            long generation = this.META_DATA_FORMAT.write(metaData, this.nodeEnv.nodeDataPaths());
            logger.trace("[_global] state written");
            return generation;
        }
        catch (WriteStateException ex) {
            throw new WriteStateException(false, "[_global]: failed to write global state", ex);
        }
    }

    void cleanupGlobalState(long currentGeneration) {
        this.META_DATA_FORMAT.cleanupOldFiles(currentGeneration, this.nodeEnv.nodeDataPaths());
    }

    public void cleanupIndex(Index index, long currentGeneration) {
        this.INDEX_META_DATA_FORMAT.cleanupOldFiles(currentGeneration, this.nodeEnv.indexPaths(index));
    }

    public void writeIndexAndUpdateManifest(String reason, IndexMetaData metaData) throws IOException {
        long generation = this.writeIndex(reason, metaData);
        Manifest manifest = this.loadManifestOrEmpty();
        HashMap<Index, Long> indices = new HashMap<Index, Long>(manifest.getIndexGenerations());
        indices.put(metaData.getIndex(), generation);
        manifest = new Manifest(manifest.getCurrentTerm(), manifest.getClusterStateVersion(), manifest.getGlobalGeneration(), indices);
        this.writeManifestAndCleanup(reason, manifest);
        this.cleanupIndex(metaData.getIndex(), generation);
    }

    public void writeGlobalStateAndUpdateManifest(String reason, MetaData metaData) throws IOException {
        long generation = this.writeGlobalState(reason, metaData);
        Manifest manifest = this.loadManifestOrEmpty();
        manifest = new Manifest(manifest.getCurrentTerm(), manifest.getClusterStateVersion(), generation, manifest.getIndexGenerations());
        this.writeManifestAndCleanup(reason, manifest);
        this.cleanupGlobalState(generation);
    }
}

