/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.Scheduler;

public class Retry {
    private final BackoffPolicy backoffPolicy;
    private final Scheduler scheduler;

    public Retry(BackoffPolicy backoffPolicy, Scheduler scheduler) {
        this.backoffPolicy = backoffPolicy;
        this.scheduler = scheduler;
    }

    public void withBackoff(BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, BulkRequest bulkRequest, ActionListener<BulkResponse> listener) {
        RetryHandler r = new RetryHandler(this.backoffPolicy, consumer, listener, this.scheduler);
        r.execute(bulkRequest);
    }

    public PlainActionFuture<BulkResponse> withBackoff(BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, BulkRequest bulkRequest) {
        PlainActionFuture<BulkResponse> future = PlainActionFuture.newFuture();
        this.withBackoff(consumer, bulkRequest, future);
        return future;
    }

    static class RetryHandler
    implements ActionListener<BulkResponse> {
        private static final RestStatus RETRY_STATUS = RestStatus.TOO_MANY_REQUESTS;
        private static final Logger logger = LogManager.getLogger(RetryHandler.class);
        private final Scheduler scheduler;
        private final BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer;
        private final ActionListener<BulkResponse> listener;
        private final Iterator<TimeValue> backoff;
        private final List<BulkItemResponse> responses = new ArrayList<BulkItemResponse>();
        private final long startTimestampNanos;
        private volatile BulkRequest currentBulkRequest;
        private volatile ScheduledFuture<?> scheduledRequestFuture;

        RetryHandler(BackoffPolicy backoffPolicy, BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, ActionListener<BulkResponse> listener, Scheduler scheduler) {
            this.backoff = backoffPolicy.iterator();
            this.consumer = consumer;
            this.listener = listener;
            this.scheduler = scheduler;
            this.startTimestampNanos = System.nanoTime();
        }

        @Override
        public void onResponse(BulkResponse bulkItemResponses) {
            if (!bulkItemResponses.hasFailures()) {
                this.addResponses(bulkItemResponses, r -> true);
                this.finishHim();
            } else if (this.canRetry(bulkItemResponses)) {
                this.addResponses(bulkItemResponses, r -> !r.isFailed());
                this.retry(this.createBulkRequestForRetry(bulkItemResponses));
            } else {
                this.addResponses(bulkItemResponses, r -> true);
                this.finishHim();
            }
        }

        @Override
        public void onFailure(Exception e) {
            try {
                this.listener.onFailure(e);
            }
            finally {
                FutureUtils.cancel(this.scheduledRequestFuture);
            }
        }

        private void retry(BulkRequest bulkRequestForRetry) {
            assert (this.backoff.hasNext());
            TimeValue next = this.backoff.next();
            logger.trace("Retry of bulk request scheduled in {} ms.", (Object)next.millis());
            Runnable command = this.scheduler.preserveContext(() -> this.execute(bulkRequestForRetry));
            this.scheduledRequestFuture = this.scheduler.schedule(next, "same", command);
        }

        private BulkRequest createBulkRequestForRetry(BulkResponse bulkItemResponses) {
            BulkRequest requestToReissue = new BulkRequest();
            int index = 0;
            for (BulkItemResponse bulkItemResponse : bulkItemResponses.getItems()) {
                if (bulkItemResponse.isFailed()) {
                    requestToReissue.add(this.currentBulkRequest.requests().get(index));
                }
                ++index;
            }
            return requestToReissue;
        }

        private boolean canRetry(BulkResponse bulkItemResponses) {
            if (!this.backoff.hasNext()) {
                return false;
            }
            for (BulkItemResponse bulkItemResponse : bulkItemResponses) {
                RestStatus status;
                if (!bulkItemResponse.isFailed() || (status = bulkItemResponse.status()) == RETRY_STATUS) continue;
                return false;
            }
            return true;
        }

        private void finishHim() {
            try {
                this.listener.onResponse(this.getAccumulatedResponse());
            }
            finally {
                FutureUtils.cancel(this.scheduledRequestFuture);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addResponses(BulkResponse response, Predicate<BulkItemResponse> filter) {
            for (BulkItemResponse bulkItemResponse : response) {
                if (!filter.test(bulkItemResponse)) continue;
                List<BulkItemResponse> list = this.responses;
                synchronized (list) {
                    this.responses.add(bulkItemResponse);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BulkResponse getAccumulatedResponse() {
            BulkItemResponse[] itemResponses;
            List<BulkItemResponse> list = this.responses;
            synchronized (list) {
                itemResponses = this.responses.toArray(new BulkItemResponse[1]);
            }
            long stopTimestamp = System.nanoTime();
            long totalLatencyMs = TimeValue.timeValueNanos(stopTimestamp - this.startTimestampNanos).millis();
            return new BulkResponse(itemResponses, totalLatencyMs);
        }

        public void execute(BulkRequest bulkRequest) {
            this.currentBulkRequest = bulkRequest;
            this.consumer.accept(bulkRequest, this);
        }
    }
}

