/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.bootstrap;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public class GetDiscoveredNodesRequest
extends ActionRequest {
    private int waitForNodes = 1;
    @Nullable
    private TimeValue timeout = TimeValue.timeValueSeconds(30L);
    private List<String> requiredNodes = Collections.emptyList();

    public GetDiscoveredNodesRequest() {
    }

    public GetDiscoveredNodesRequest(StreamInput in) throws IOException {
        super(in);
        this.waitForNodes = in.readInt();
        this.timeout = in.readOptionalTimeValue();
        this.requiredNodes = in.readList(StreamInput::readString);
    }

    public void setWaitForNodes(int waitForNodes) {
        if (waitForNodes < 1) {
            throw new IllegalArgumentException("always finds at least one node, waiting for [" + waitForNodes + "] is not allowed");
        }
        this.waitForNodes = waitForNodes;
    }

    public int getWaitForNodes() {
        return this.waitForNodes;
    }

    public void setTimeout(@Nullable TimeValue timeout) {
        if (timeout != null && timeout.compareTo(TimeValue.ZERO) < 0) {
            throw new IllegalArgumentException("negative timeout of [" + timeout + "] is not allowed");
        }
        this.timeout = timeout;
    }

    @Nullable
    public TimeValue getTimeout() {
        return this.timeout;
    }

    public List<String> getRequiredNodes() {
        return this.requiredNodes;
    }

    public void setRequiredNodes(List<String> requiredNodes) {
        this.requiredNodes = requiredNodes;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeInt(this.waitForNodes);
        out.writeOptionalTimeValue(this.timeout);
        out.writeStringList(this.requiredNodes);
    }

    public String toString() {
        return "GetDiscoveredNodesRequest{waitForNodes=" + this.waitForNodes + ", timeout=" + this.timeout + ", requiredNodes=" + this.requiredNodes + "}";
    }
}

