/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.nio;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.http.HttpHandlingSettings;
import org.elasticsearch.http.HttpPipelinedRequest;
import org.elasticsearch.http.nio.HttpWriteOperation;
import org.elasticsearch.http.nio.NettyAdaptor;
import org.elasticsearch.http.nio.NioHttpChannel;
import org.elasticsearch.http.nio.NioHttpPipeliningHandler;
import org.elasticsearch.http.nio.NioHttpRequest;
import org.elasticsearch.http.nio.NioHttpResponse;
import org.elasticsearch.http.nio.NioHttpServerTransport;
import org.elasticsearch.http.nio.cors.NioCorsConfig;
import org.elasticsearch.http.nio.cors.NioCorsHandler;
import org.elasticsearch.nio.FlushOperation;
import org.elasticsearch.nio.InboundChannelBuffer;
import org.elasticsearch.nio.ReadWriteHandler;
import org.elasticsearch.nio.SocketChannelContext;
import org.elasticsearch.nio.WriteOperation;

public class HttpReadWriteHandler
implements ReadWriteHandler {
    private final NettyAdaptor adaptor;
    private final NioHttpChannel nioHttpChannel;
    private final NioHttpServerTransport transport;

    public HttpReadWriteHandler(NioHttpChannel nioHttpChannel, NioHttpServerTransport transport, HttpHandlingSettings settings, NioCorsConfig corsConfig) {
        this.nioHttpChannel = nioHttpChannel;
        this.transport = transport;
        ArrayList<Object> handlers = new ArrayList<Object>(5);
        HttpRequestDecoder decoder = new HttpRequestDecoder(settings.getMaxInitialLineLength(), settings.getMaxHeaderSize(), settings.getMaxChunkSize());
        decoder.setCumulator(ByteToMessageDecoder.COMPOSITE_CUMULATOR);
        handlers.add(decoder);
        handlers.add(new HttpContentDecompressor());
        handlers.add(new HttpResponseEncoder());
        handlers.add(new HttpObjectAggregator(settings.getMaxContentLength()));
        if (settings.isCompression()) {
            handlers.add(new HttpContentCompressor(settings.getCompressionLevel()));
        }
        if (settings.isCorsEnabled()) {
            handlers.add((Object)new NioCorsHandler(corsConfig));
        }
        handlers.add((Object)new NioHttpPipeliningHandler(transport.getLogger(), settings.getPipeliningMaxEvents()));
        this.adaptor = new NettyAdaptor(handlers.toArray(new ChannelHandler[0]));
        this.adaptor.addCloseListener((v, e) -> nioHttpChannel.close());
    }

    public int consumeReads(InboundChannelBuffer channelBuffer) throws IOException {
        Object message;
        int bytesConsumed = this.adaptor.read(channelBuffer.sliceAndRetainPagesTo(channelBuffer.getIndex()));
        while ((message = this.adaptor.pollInboundMessage()) != null) {
            this.handleRequest(message);
        }
        return bytesConsumed;
    }

    public WriteOperation createWriteOperation(SocketChannelContext context, Object message, BiConsumer<Void, Exception> listener) {
        assert (message instanceof NioHttpResponse) : "This channel only supports messages that are of type: " + NioHttpResponse.class + ". Found type: " + message.getClass() + ".";
        return new HttpWriteOperation(context, (NioHttpResponse)((Object)message), listener);
    }

    public List<FlushOperation> writeToBytes(WriteOperation writeOperation) {
        this.adaptor.write(writeOperation);
        return this.pollFlushOperations();
    }

    public List<FlushOperation> pollFlushOperations() {
        FlushOperation flushOperation;
        ArrayList<FlushOperation> copiedOperations = new ArrayList<FlushOperation>(this.adaptor.getOutboundCount());
        while ((flushOperation = this.adaptor.pollOutboundOperation()) != null) {
            copiedOperations.add(flushOperation);
        }
        return copiedOperations;
    }

    public void close() throws IOException {
        try {
            this.adaptor.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(Object msg) {
        HttpPipelinedRequest pipelinedRequest = (HttpPipelinedRequest)msg;
        FullHttpRequest request = (FullHttpRequest)pipelinedRequest.getRequest();
        try {
            DefaultFullHttpRequest copiedRequest = new DefaultFullHttpRequest(request.protocolVersion(), request.method(), request.uri(), Unpooled.copiedBuffer((ByteBuf)request.content()), request.headers(), request.trailingHeaders());
            NioHttpRequest httpRequest = new NioHttpRequest((FullHttpRequest)copiedRequest, pipelinedRequest.getSequence());
            if (request.decoderResult().isFailure()) {
                Throwable cause = request.decoderResult().cause();
                if (cause instanceof Error) {
                    ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
                    this.transport.incomingRequestError(httpRequest, this.nioHttpChannel, new Exception(cause));
                } else {
                    this.transport.incomingRequestError(httpRequest, this.nioHttpChannel, (Exception)cause);
                }
            } else {
                this.transport.incomingRequest(httpRequest, this.nioHttpChannel);
            }
        }
        finally {
            request.release();
        }
    }
}

