/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.nio;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;

class ByteBufUtils {
    ByteBufUtils() {
    }

    static ByteBuf toByteBuf(BytesReference reference) {
        if (reference.length() == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (reference instanceof ByteBufBytesReference) {
            return ((ByteBufBytesReference)reference).toByteBuf();
        }
        BytesRefIterator iterator = reference.iterator();
        ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>(3);
        try {
            BytesRef slice;
            while ((slice = iterator.next()) != null) {
                buffers.add(Unpooled.wrappedBuffer((byte[])slice.bytes, (int)slice.offset, (int)slice.length));
            }
            if (buffers.size() == 1) {
                return (ByteBuf)buffers.get(0);
            }
            CompositeByteBuf composite = Unpooled.compositeBuffer((int)buffers.size());
            composite.addComponents(true, buffers);
            return composite;
        }
        catch (IOException ex) {
            throw new AssertionError("no IO happens here", ex);
        }
    }

    static BytesReference toBytesReference(ByteBuf buffer) {
        return new ByteBufBytesReference(buffer, buffer.readableBytes());
    }

    private static class ByteBufStreamInput
    extends StreamInput {
        private final ByteBuf buffer;
        private final int endIndex;

        ByteBufStreamInput(ByteBuf buffer, int length) {
            if (length > buffer.readableBytes()) {
                throw new IndexOutOfBoundsException();
            }
            this.buffer = buffer;
            int startIndex = buffer.readerIndex();
            this.endIndex = startIndex + length;
            buffer.markReaderIndex();
        }

        public BytesReference readBytesReference(int length) throws IOException {
            return super.readBytesReference(length);
        }

        public BytesRef readBytesRef(int length) throws IOException {
            return super.readBytesRef(length);
        }

        public int available() throws IOException {
            return this.endIndex - this.buffer.readerIndex();
        }

        protected void ensureCanReadBytes(int length) throws EOFException {
            int bytesAvailable = this.endIndex - this.buffer.readerIndex();
            if (bytesAvailable < length) {
                throw new EOFException("tried to read: " + length + " bytes but only " + bytesAvailable + " remaining");
            }
        }

        public void mark(int readlimit) {
            this.buffer.markReaderIndex();
        }

        public boolean markSupported() {
            return true;
        }

        public int read() throws IOException {
            if (this.available() == 0) {
                return -1;
            }
            return this.buffer.readByte() & 0xFF;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            int available = this.available();
            if (available == 0) {
                return -1;
            }
            len = Math.min(available, len);
            this.buffer.readBytes(b, off, len);
            return len;
        }

        public void reset() throws IOException {
            this.buffer.resetReaderIndex();
        }

        public long skip(long n) throws IOException {
            if (n > Integer.MAX_VALUE) {
                return this.skipBytes(Integer.MAX_VALUE);
            }
            return this.skipBytes((int)n);
        }

        public int skipBytes(int n) throws IOException {
            int nBytes = Math.min(this.available(), n);
            this.buffer.skipBytes(nBytes);
            return nBytes;
        }

        public byte readByte() throws IOException {
            try {
                return this.buffer.readByte();
            }
            catch (IndexOutOfBoundsException ex) {
                EOFException eofException = new EOFException();
                eofException.initCause(ex);
                throw eofException;
            }
        }

        public void readBytes(byte[] b, int offset, int len) throws IOException {
            int read = this.read(b, offset, len);
            if (read < len) {
                throw new IndexOutOfBoundsException();
            }
        }

        public void close() throws IOException {
        }
    }

    private static class ByteBufBytesReference
    extends BytesReference {
        private final ByteBuf buffer;
        private final int length;
        private final int offset;

        ByteBufBytesReference(ByteBuf buffer, int length) {
            this.buffer = buffer;
            this.length = length;
            this.offset = buffer.readerIndex();
            assert (length <= buffer.readableBytes()) : "length[" + length + "] > " + buffer.readableBytes();
        }

        public byte get(int index) {
            return this.buffer.getByte(this.offset + index);
        }

        public int length() {
            return this.length;
        }

        public BytesReference slice(int from, int length) {
            return new ByteBufBytesReference(this.buffer.slice(this.offset + from, length), length);
        }

        public StreamInput streamInput() {
            return new ByteBufStreamInput(this.buffer.duplicate(), this.length);
        }

        public void writeTo(OutputStream os) throws IOException {
            this.buffer.getBytes(this.offset, os, this.length);
        }

        ByteBuf toByteBuf() {
            return this.buffer.duplicate();
        }

        public String utf8ToString() {
            return this.buffer.toString(this.offset, this.length, StandardCharsets.UTF_8);
        }

        public BytesRef toBytesRef() {
            if (this.buffer.hasArray()) {
                return new BytesRef(this.buffer.array(), this.buffer.arrayOffset() + this.offset, this.length);
            }
            byte[] copy = new byte[this.length];
            this.buffer.getBytes(this.offset, copy);
            return new BytesRef(copy);
        }

        public long ramBytesUsed() {
            return this.buffer.capacity();
        }
    }
}

