/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.TimeZone;
import org.elasticsearch.xpack.sql.proto.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateUtils {
    private static final DateTimeFormatter UTC_DATE_FORMATTER = ISODateTimeFormat.dateOptionalTimeParser().withZoneUTC();
    public static TimeZone UTC_TZ = TimeZone.getTimeZone("UTC");
    public static ZoneId UTC_ZI = ZoneId.of("Z");

    private DateUtils() {
    }

    public static ZonedDateTime of(long millis) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), UTC_ZI);
    }

    public static ZonedDateTime of(long millis, ZoneId id) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), id);
    }

    public static ZonedDateTime of(String dateFormat) {
        return DateUtils.of(UTC_DATE_FORMATTER.parseDateTime(dateFormat));
    }

    public static ZonedDateTime of(DateTime dateTime) {
        LocalDateTime ldt = LocalDateTime.of(dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth(), dateTime.getHourOfDay(), dateTime.getMinuteOfHour(), dateTime.getSecondOfMinute(), dateTime.getMillisOfSecond() * 1000000);
        return ZonedDateTime.ofStrict(ldt, ZoneOffset.ofTotalSeconds(dateTime.getZone().getOffset((ReadableInstant)dateTime) / 1000), org.elasticsearch.common.time.DateUtils.dateTimeZoneToZoneId((DateTimeZone)dateTime.getZone()));
    }

    public static String toString(ZonedDateTime dateTime) {
        return StringUtils.toString((Object)dateTime);
    }
}

