/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.type;

import java.sql.JDBCType;
import java.sql.SQLType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.xpack.sql.type.ExtTypes;

public enum DataType {
    NULL(JDBCType.NULL, 0, 0, 0, false, false, false),
    UNSUPPORTED(JDBCType.OTHER, 0, 0, 0, false, false, false),
    BOOLEAN(JDBCType.BOOLEAN, 1, 1, 1, false, false, false),
    BYTE(JDBCType.TINYINT, 1, 3, 5, true, false, true),
    SHORT(JDBCType.SMALLINT, 2, 5, 6, true, false, true),
    INTEGER(JDBCType.INTEGER, 4, 10, 11, true, false, true),
    LONG(JDBCType.BIGINT, 8, 19, 20, true, false, true),
    DOUBLE(JDBCType.DOUBLE, 8, 15, 25, false, true, true),
    FLOAT(JDBCType.REAL, 4, 7, 15, false, true, true),
    HALF_FLOAT(JDBCType.FLOAT, 8, 16, 25, false, true, true),
    SCALED_FLOAT(JDBCType.FLOAT, 8, 19, 25, false, true, true),
    KEYWORD(JDBCType.VARCHAR, Integer.MAX_VALUE, 256, 0, false, false, true),
    TEXT(JDBCType.VARCHAR, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, false, false, false),
    OBJECT(JDBCType.STRUCT, -1, 0, 0, false, false, false),
    NESTED(JDBCType.STRUCT, -1, 0, 0, false, false, false),
    BINARY(JDBCType.VARBINARY, -1, Integer.MAX_VALUE, 0, false, false, false),
    DATE(JDBCType.TIMESTAMP, 8, 24, 24, false, false, true),
    IP(JDBCType.VARCHAR, 39, 39, 0, false, false, true),
    INTERVAL_YEAR(ExtTypes.INTERVAL_YEAR, 4, 7, 7, false, false, false),
    INTERVAL_MONTH(ExtTypes.INTERVAL_MONTH, 4, 7, 7, false, false, false),
    INTERVAL_DAY(ExtTypes.INTERVAL_DAY, 8, 23, 23, false, false, false),
    INTERVAL_HOUR(ExtTypes.INTERVAL_HOUR, 8, 23, 23, false, false, false),
    INTERVAL_MINUTE(ExtTypes.INTERVAL_MINUTE, 8, 23, 23, false, false, false),
    INTERVAL_SECOND(ExtTypes.INTERVAL_SECOND, 8, 23, 23, false, false, false),
    INTERVAL_YEAR_TO_MONTH(ExtTypes.INTERVAL_YEAR_TO_MONTH, 4, 7, 7, false, false, false),
    INTERVAL_DAY_TO_HOUR(ExtTypes.INTERVAL_DAY_TO_HOUR, 8, 23, 23, false, false, false),
    INTERVAL_DAY_TO_MINUTE(ExtTypes.INTERVAL_DAY_TO_MINUTE, 8, 23, 23, false, false, false),
    INTERVAL_DAY_TO_SECOND(ExtTypes.INTERVAL_DAY_TO_SECOND, 8, 23, 23, false, false, false),
    INTERVAL_HOUR_TO_MINUTE(ExtTypes.INTERVAL_HOUR_TO_MINUTE, 8, 23, 23, false, false, false),
    INTERVAL_HOUR_TO_SECOND(ExtTypes.INTERVAL_HOUR_TO_SECOND, 8, 23, 23, false, false, false),
    INTERVAL_MINUTE_TO_SECOND(ExtTypes.INTERVAL_MINUTE_TO_SECOND, 8, 23, 23, false, false, false);

    private static final Map<String, DataType> odbcToEs;
    public final String esType = this.name().toLowerCase(Locale.ROOT);
    public final SQLType sqlType;
    public final int size;
    public final int defaultPrecision;
    public final int displaySize;
    private final boolean isInteger;
    private final boolean isRational;
    public final boolean defaultDocValues;

    private DataType(SQLType sqlType, int size, int defaultPrecision, int displaySize, boolean isInteger, boolean isRational, boolean defaultDocValues) {
        this.sqlType = sqlType;
        this.size = size;
        this.defaultPrecision = defaultPrecision;
        this.displaySize = displaySize;
        this.isInteger = isInteger;
        this.isRational = isRational;
        this.defaultDocValues = defaultDocValues;
    }

    public String sqlName() {
        return this.sqlType.getName();
    }

    public boolean isInteger() {
        return this.isInteger;
    }

    public boolean isRational() {
        return this.isRational;
    }

    public boolean isNumeric() {
        return this.isInteger || this.isRational;
    }

    public boolean isSigned() {
        return this.isNumeric();
    }

    public boolean isString() {
        return this == KEYWORD || this == TEXT;
    }

    public boolean isPrimitive() {
        return this != OBJECT && this != NESTED;
    }

    public static DataType fromOdbcType(String odbcType) {
        return odbcToEs.get(odbcType);
    }

    public static DataType fromTypeName(String esType) {
        try {
            return DataType.valueOf(esType.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ex) {
            return UNSUPPORTED;
        }
    }

    static {
        odbcToEs = new HashMap<String, DataType>(36);
        odbcToEs.put("SQL_BIT", BOOLEAN);
        odbcToEs.put("SQL_TINYINT", BYTE);
        odbcToEs.put("SQL_SMALLINT", SHORT);
        odbcToEs.put("SQL_INTEGER", INTEGER);
        odbcToEs.put("SQL_BIGINT", LONG);
        odbcToEs.put("SQL_FLOAT", FLOAT);
        odbcToEs.put("SQL_REAL", FLOAT);
        odbcToEs.put("SQL_DOUBLE", DOUBLE);
        odbcToEs.put("SQL_DECIMAL", DOUBLE);
        odbcToEs.put("SQL_NUMERIC", DOUBLE);
        odbcToEs.put("SQL_GUID", KEYWORD);
        odbcToEs.put("SQL_CHAR", KEYWORD);
        odbcToEs.put("SQL_WCHAR", KEYWORD);
        odbcToEs.put("SQL_VARCHAR", TEXT);
        odbcToEs.put("SQL_WVARCHAR", TEXT);
        odbcToEs.put("SQL_LONGVARCHAR", TEXT);
        odbcToEs.put("SQL_WLONGVARCHAR", TEXT);
        odbcToEs.put("SQL_BINARY", BINARY);
        odbcToEs.put("SQL_VARBINARY", BINARY);
        odbcToEs.put("SQL_LONGVARBINARY", BINARY);
        odbcToEs.put("SQL_DATE", DATE);
        odbcToEs.put("SQL_TIME", DATE);
        odbcToEs.put("SQL_TIMESTAMP", DATE);
        odbcToEs.put("SQL_INTERVAL_HOUR_TO_MINUTE", INTERVAL_HOUR_TO_MINUTE);
        odbcToEs.put("SQL_INTERVAL_HOUR_TO_SECOND", INTERVAL_HOUR_TO_SECOND);
        odbcToEs.put("SQL_INTERVAL_MINUTE_TO_SECOND", INTERVAL_MINUTE_TO_SECOND);
        odbcToEs.put("SQL_INTERVAL_MONTH", INTERVAL_MONTH);
        odbcToEs.put("SQL_INTERVAL_YEAR", INTERVAL_YEAR);
        odbcToEs.put("SQL_INTERVAL_YEAR_TO_MONTH", INTERVAL_YEAR_TO_MONTH);
        odbcToEs.put("SQL_INTERVAL_DAY", INTERVAL_DAY);
        odbcToEs.put("SQL_INTERVAL_HOUR", INTERVAL_HOUR);
        odbcToEs.put("SQL_INTERVAL_MINUTE", INTERVAL_MINUTE);
        odbcToEs.put("SQL_INTERVAL_SECOND", INTERVAL_SECOND);
        odbcToEs.put("SQL_INTERVAL_DAY_TO_HOUR", INTERVAL_DAY_TO_HOUR);
        odbcToEs.put("SQL_INTERVAL_DAY_TO_MINUTE", INTERVAL_DAY_TO_MINUTE);
        odbcToEs.put("SQL_INTERVAL_DAY_TO_SECOND", INTERVAL_DAY_TO_SECOND);
    }
}

