/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.stats;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.xpack.core.watcher.common.stats.Counters;
import org.elasticsearch.xpack.sql.stats.FeatureMetric;
import org.elasticsearch.xpack.sql.stats.QueryMetric;

public class Metrics {
    private final Map<QueryMetric, Map<OperationType, CounterMetric>> opsByTypeMetrics;
    private final Map<FeatureMetric, CounterMetric> featuresMetrics;
    private final CounterMetric translateMetric;
    protected static String QPREFIX = "queries.";
    protected static String FPREFIX = "features.";
    protected static String TRANSLATE_METRIC = "queries.translate.count";

    public Metrics() {
        LinkedHashMap qMap = new LinkedHashMap();
        for (QueryMetric metric : QueryMetric.values()) {
            LinkedHashMap<OperationType, CounterMetric> metricsMap = new LinkedHashMap<OperationType, CounterMetric>(OperationType.values().length);
            for (OperationType type : OperationType.values()) {
                metricsMap.put(type, new CounterMetric());
            }
            qMap.put(metric, Collections.unmodifiableMap(metricsMap));
        }
        this.opsByTypeMetrics = Collections.unmodifiableMap(qMap);
        LinkedHashMap<FeatureMetric, CounterMetric> fMap = new LinkedHashMap<FeatureMetric, CounterMetric>(FeatureMetric.values().length);
        for (FeatureMetric featureMetric : FeatureMetric.values()) {
            fMap.put(featureMetric, new CounterMetric());
        }
        this.featuresMetrics = Collections.unmodifiableMap(fMap);
        this.translateMetric = new CounterMetric();
    }

    public void total(QueryMetric metric) {
        this.inc(metric, OperationType.TOTAL);
    }

    public void failed(QueryMetric metric) {
        this.inc(metric, OperationType.FAILED);
    }

    public void paging(QueryMetric metric) {
        this.inc(metric, OperationType.PAGING);
    }

    public void translate() {
        this.translateMetric.inc();
    }

    private void inc(QueryMetric metric, OperationType op) {
        this.opsByTypeMetrics.get((Object)metric).get((Object)op).inc();
    }

    public void inc(FeatureMetric metric) {
        this.featuresMetrics.get((Object)metric).inc();
    }

    public Counters stats() {
        Counters counters = new Counters(new String[0]);
        for (Map.Entry<QueryMetric, Map<OperationType, CounterMetric>> entry : this.opsByTypeMetrics.entrySet()) {
            for (OperationType type : OperationType.values()) {
                counters.inc(QPREFIX + entry.getKey().toString() + "." + type.toString(), entry.getValue().get((Object)type).count());
                counters.inc(QPREFIX + "_all." + type.toString(), entry.getValue().get((Object)type).count());
            }
        }
        for (Map.Entry<Enum, Map<OperationType, Object>> entry : this.featuresMetrics.entrySet()) {
            counters.inc(FPREFIX + ((FeatureMetric)entry.getKey()).toString(), ((CounterMetric)entry.getValue()).count());
        }
        counters.inc(TRANSLATE_METRIC, this.translateMetric.count());
        return counters;
    }

    private static enum OperationType {
        FAILED,
        PAGING,
        TOTAL;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

