/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.container;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.execution.search.AggRef;
import org.elasticsearch.xpack.sql.execution.search.FieldExtraction;
import org.elasticsearch.xpack.sql.execution.search.SourceGenerator;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.LiteralAttribute;
import org.elasticsearch.xpack.sql.expression.function.ScoreAttribute;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunctionAttribute;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.querydsl.agg.Aggs;
import org.elasticsearch.xpack.sql.querydsl.agg.GroupByKey;
import org.elasticsearch.xpack.sql.querydsl.agg.LeafAgg;
import org.elasticsearch.xpack.sql.querydsl.container.ComputedRef;
import org.elasticsearch.xpack.sql.querydsl.container.GlobalCountRef;
import org.elasticsearch.xpack.sql.querydsl.container.GroupByRef;
import org.elasticsearch.xpack.sql.querydsl.container.SearchHitFieldRef;
import org.elasticsearch.xpack.sql.querydsl.container.Sort;
import org.elasticsearch.xpack.sql.querydsl.query.BoolQuery;
import org.elasticsearch.xpack.sql.querydsl.query.MatchAll;
import org.elasticsearch.xpack.sql.querydsl.query.NestedQuery;
import org.elasticsearch.xpack.sql.querydsl.query.Query;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.util.CollectionUtils;

public class QueryContainer {
    private final Aggs aggs;
    private final Query query;
    private final List<FieldExtraction> columns;
    private final Map<Attribute, Attribute> aliases;
    private final Map<String, GroupByKey> pseudoFunctions;
    private final Map<Attribute, Pipe> scalarFunctions;
    private final Set<Sort> sort;
    private final int limit;
    private final boolean aggsOnly;

    public QueryContainer() {
        this(null, null, null, null, null, null, null, -1);
    }

    public QueryContainer(Query query, Aggs aggs, List<FieldExtraction> refs, Map<Attribute, Attribute> aliases, Map<String, GroupByKey> pseudoFunctions, Map<Attribute, Pipe> scalarFunctions, Set<Sort> sort, int limit) {
        this.query = query;
        this.aggs = aggs == null ? new Aggs() : aggs;
        this.aliases = aliases == null || aliases.isEmpty() ? Collections.emptyMap() : aliases;
        this.pseudoFunctions = pseudoFunctions == null || pseudoFunctions.isEmpty() ? Collections.emptyMap() : pseudoFunctions;
        this.scalarFunctions = scalarFunctions == null || scalarFunctions.isEmpty() ? Collections.emptyMap() : scalarFunctions;
        this.columns = refs == null || refs.isEmpty() ? Collections.emptyList() : refs;
        this.sort = sort == null || sort.isEmpty() ? Collections.emptySet() : sort;
        this.limit = limit;
        this.aggsOnly = this.columns.stream().allMatch(FieldExtraction::supportedByAggsOnlyQuery);
    }

    public Query query() {
        return this.query;
    }

    public Aggs aggs() {
        return this.aggs;
    }

    public List<FieldExtraction> columns() {
        return this.columns;
    }

    public Map<Attribute, Attribute> aliases() {
        return this.aliases;
    }

    public Map<String, GroupByKey> pseudoFunctions() {
        return this.pseudoFunctions;
    }

    public Set<Sort> sort() {
        return this.sort;
    }

    public int limit() {
        return this.limit;
    }

    public boolean isAggsOnly() {
        return this.aggsOnly;
    }

    public boolean hasColumns() {
        return !this.columns.isEmpty();
    }

    public QueryContainer with(Query q) {
        return new QueryContainer(q, this.aggs, this.columns, this.aliases, this.pseudoFunctions, this.scalarFunctions, this.sort, this.limit);
    }

    public QueryContainer with(List<FieldExtraction> r) {
        return new QueryContainer(this.query, this.aggs, r, this.aliases, this.pseudoFunctions, this.scalarFunctions, this.sort, this.limit);
    }

    public QueryContainer withAliases(Map<Attribute, Attribute> a) {
        return new QueryContainer(this.query, this.aggs, this.columns, a, this.pseudoFunctions, this.scalarFunctions, this.sort, this.limit);
    }

    public QueryContainer withPseudoFunctions(Map<String, GroupByKey> p) {
        return new QueryContainer(this.query, this.aggs, this.columns, this.aliases, p, this.scalarFunctions, this.sort, this.limit);
    }

    public QueryContainer with(Aggs a) {
        return new QueryContainer(this.query, a, this.columns, this.aliases, this.pseudoFunctions, this.scalarFunctions, this.sort, this.limit);
    }

    public QueryContainer withLimit(int l) {
        return l == this.limit ? this : new QueryContainer(this.query, this.aggs, this.columns, this.aliases, this.pseudoFunctions, this.scalarFunctions, this.sort, l);
    }

    public QueryContainer withScalarProcessors(Map<Attribute, Pipe> procs) {
        return new QueryContainer(this.query, this.aggs, this.columns, this.aliases, this.pseudoFunctions, procs, this.sort, this.limit);
    }

    public QueryContainer sort(Sort sortable) {
        LinkedHashSet<Sort> sort = new LinkedHashSet<Sort>(this.sort);
        sort.add(sortable);
        return new QueryContainer(this.query, this.aggs, this.columns, this.aliases, this.pseudoFunctions, this.scalarFunctions, sort, this.limit);
    }

    private String aliasName(Attribute attr) {
        return this.aliases.getOrDefault(attr, attr).name();
    }

    private FieldExtraction topHitFieldRef(FieldAttribute fieldAttr) {
        return new SearchHitFieldRef(this.aliasName(fieldAttr), fieldAttr.field().getDataType(), fieldAttr.field().isAggregatable());
    }

    private Tuple<QueryContainer, FieldExtraction> nestedHitFieldRef(FieldAttribute attr) {
        ArrayList<SearchHitFieldRef> nestedRefs = new ArrayList<SearchHitFieldRef>();
        String name = this.aliasName(attr);
        String format = attr.field().getDataType() == DataType.DATE ? "epoch_millis" : "use_field_mapping";
        Query q = QueryContainer.rewriteToContainNestedField(this.query, attr.location(), attr.nestedParent().name(), name, format, attr.field().isAggregatable());
        SearchHitFieldRef nestedFieldRef = new SearchHitFieldRef(name, attr.field().getDataType(), attr.field().isAggregatable(), attr.parent().name());
        nestedRefs.add(nestedFieldRef);
        return new Tuple((Object)new QueryContainer(q, this.aggs, this.columns, this.aliases, this.pseudoFunctions, this.scalarFunctions, this.sort, this.limit), (Object)nestedFieldRef);
    }

    static Query rewriteToContainNestedField(@Nullable Query query, Location location, String path, String name, String format, boolean hasDocValues) {
        if (query == null) {
            return new NestedQuery(location, path, Collections.singletonMap(name, new AbstractMap.SimpleImmutableEntry<Boolean, String>(hasDocValues, format)), new MatchAll(location));
        }
        if (query.containsNestedField(path, name)) {
            return query;
        }
        Query rewritten = query.addNestedField(path, name, format, hasDocValues);
        if (rewritten != query) {
            return rewritten;
        }
        NestedQuery nested = new NestedQuery(location, path, Collections.singletonMap(name, new AbstractMap.SimpleImmutableEntry<Boolean, String>(hasDocValues, format)), new MatchAll(location));
        return new BoolQuery(location, true, query, nested);
    }

    private Tuple<QueryContainer, FieldExtraction> resolvedTreeComputingRef(ScalarFunctionAttribute ta) {
        Attribute attribute = this.aliases.getOrDefault(ta, ta);
        Pipe proc = this.scalarFunctions.get(attribute);
        if (proc == null) {
            if (attribute instanceof ScalarFunctionAttribute) {
                ta = (ScalarFunctionAttribute)attribute;
            }
            proc = ta.asPipe();
        }
        class QueryAttributeResolver
        implements Pipe.AttributeResolver {
            private QueryContainer container;

            QueryAttributeResolver(QueryContainer container) {
                this.container = container;
            }

            @Override
            public FieldExtraction resolve(Attribute attribute) {
                Attribute attr = QueryContainer.this.aliases.getOrDefault(attribute, attribute);
                Tuple ref = this.container.toReference(attr);
                this.container = (QueryContainer)ref.v1();
                return (FieldExtraction)ref.v2();
            }
        }
        QueryAttributeResolver resolver = new QueryAttributeResolver(this);
        proc = proc.resolveAttributes(resolver);
        QueryContainer qContainer = resolver.container;
        LinkedHashMap<Attribute, Pipe> procs = new LinkedHashMap<Attribute, Pipe>(qContainer.scalarFunctions());
        procs.put(attribute, proc);
        qContainer = qContainer.withScalarProcessors(procs);
        return new Tuple((Object)qContainer, (Object)new ComputedRef(proc));
    }

    public QueryContainer addColumn(Attribute attr) {
        Tuple<QueryContainer, FieldExtraction> tuple = this.toReference(attr);
        return ((QueryContainer)tuple.v1()).addColumn((FieldExtraction)tuple.v2());
    }

    private Tuple<QueryContainer, FieldExtraction> toReference(Attribute attr) {
        if (attr instanceof FieldAttribute) {
            FieldAttribute fa = (FieldAttribute)attr;
            if (fa.isNested()) {
                return this.nestedHitFieldRef(fa);
            }
            return new Tuple((Object)this, (Object)this.topHitFieldRef(fa));
        }
        if (attr instanceof ScalarFunctionAttribute) {
            return this.resolvedTreeComputingRef((ScalarFunctionAttribute)attr);
        }
        if (attr instanceof LiteralAttribute) {
            return new Tuple((Object)this, (Object)new ComputedRef(((LiteralAttribute)attr).asPipe()));
        }
        if (attr instanceof ScoreAttribute) {
            return new Tuple((Object)this, (Object)new ComputedRef(((ScoreAttribute)attr).asPipe()));
        }
        throw new SqlIllegalArgumentException("Unknown output attribute {}", attr);
    }

    public QueryContainer addColumn(FieldExtraction ref) {
        return this.with(CollectionUtils.combine(this.columns, ref));
    }

    public Map<Attribute, Pipe> scalarFunctions() {
        return this.scalarFunctions;
    }

    public QueryContainer addAggCount(GroupByKey group, String functionId) {
        AggRef ref = group == null ? GlobalCountRef.INSTANCE : new GroupByRef(group.id(), GroupByRef.Property.COUNT, null);
        LinkedHashMap<String, GroupByKey> pseudoFunctions = new LinkedHashMap<String, GroupByKey>(this.pseudoFunctions);
        pseudoFunctions.put(functionId, group);
        return new QueryContainer(this.query, this.aggs, CollectionUtils.combine(this.columns, ref), this.aliases, pseudoFunctions, this.scalarFunctions, this.sort, this.limit);
    }

    public QueryContainer addAgg(String groupId, LeafAgg agg) {
        return this.with(this.aggs.addAgg(agg));
    }

    public QueryContainer addGroups(Collection<GroupByKey> values) {
        return this.with(this.aggs.addGroups(values));
    }

    public GroupByKey findGroupForAgg(String aggId) {
        return this.aggs.findGroupForAgg(aggId);
    }

    public QueryContainer updateGroup(GroupByKey group) {
        return this.with(this.aggs.updateGroup(group));
    }

    public int hashCode() {
        return Objects.hash(this.query, this.aggs, this.columns, this.aliases);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueryContainer other = (QueryContainer)obj;
        return Objects.equals(this.query, other.query) && Objects.equals(this.aggs, other.aggs) && Objects.equals(this.columns, other.columns) && Objects.equals(this.aliases, other.aliases) && Objects.equals(this.sort, other.sort) && Objects.equals(this.limit, other.limit);
    }

    public String toString() {
        String string;
        block8: {
            XContentBuilder builder = JsonXContent.contentBuilder();
            try {
                builder.humanReadable(true).prettyPrint();
                SourceGenerator.sourceBuilder(this, null, null).toXContent(builder, ToXContent.EMPTY_PARAMS);
                string = Strings.toString((XContentBuilder)builder);
                if (builder == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("error rendering", e);
                }
            }
            builder.close();
        }
        return string;
    }
}

