/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.literal;

import java.io.IOException;
import java.time.Duration;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.expression.literal.Interval;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypes;

public class IntervalDayTime
extends Interval<Duration> {
    public static final String NAME = "idt";

    private static Duration duration(StreamInput in) throws IOException {
        return Duration.ofSeconds(in.readVLong(), in.readVInt());
    }

    public IntervalDayTime(Duration interval, DataType intervalType) {
        super(interval, intervalType);
    }

    IntervalDayTime(StreamInput in) throws IOException {
        super(IntervalDayTime.duration(in), (DataType)in.readEnum(DataType.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(((Duration)this.interval()).getSeconds());
        out.writeVInt(((Duration)this.interval()).getNano());
        out.writeEnum((Enum)this.dataType());
    }

    public String getWriteableName() {
        return NAME;
    }

    public IntervalDayTime add(Interval<Duration> interval) {
        return new IntervalDayTime(((Duration)this.interval()).plus(interval.interval()), DataTypes.compatibleInterval(this.dataType(), interval.dataType()));
    }

    public IntervalDayTime sub(Interval<Duration> interval) {
        return new IntervalDayTime(((Duration)this.interval()).minus(interval.interval()), DataTypes.compatibleInterval(this.dataType(), interval.dataType()));
    }

    @Override
    public Interval<Duration> mul(long mul) {
        return new IntervalDayTime(((Duration)this.interval()).multipliedBy(mul), this.dataType());
    }
}

