/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BaseDateTimeFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeHistogramFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeProcessor;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;

public class Year
extends DateTimeHistogramFunction {
    private static long YEAR_IN_MILLIS = TimeUnit.DAYS.toMillis(1L) * 365L;

    public Year(Location location, Expression field, TimeZone timeZone) {
        super(location, field, timeZone, DateTimeProcessor.DateTimeExtractor.YEAR);
    }

    @Override
    protected NodeInfo.NodeCtor2<Expression, TimeZone, BaseDateTimeFunction> ctorForInfo() {
        return Year::new;
    }

    @Override
    protected Year replaceChild(Expression newChild) {
        return new Year(this.location(), newChild, this.timeZone());
    }

    @Override
    public String dateTimeFormat() {
        return "year";
    }

    @Override
    public Expression orderBy() {
        return this.field();
    }

    @Override
    public long interval() {
        return YEAR_IN_MILLIS;
    }
}

