/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZonedDateTime;
import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.scalar.ConfigurationFunction;
import org.elasticsearch.xpack.sql.session.Configuration;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.type.DataType;

public class CurrentDateTime
extends ConfigurationFunction {
    private final Expression precision;
    private final ZonedDateTime dateTime;

    public CurrentDateTime(Location location, Expression precision, Configuration configuration) {
        super(location, configuration, DataType.DATE);
        this.precision = precision;
        int p = precision != null ? ((Number)precision.fold()).intValue() : 0;
        this.dateTime = CurrentDateTime.nanoPrecision(this.configuration().now(), p);
    }

    @Override
    public Object fold() {
        return this.dateTime;
    }

    @Override
    protected NodeInfo<CurrentDateTime> info() {
        return NodeInfo.create(this, CurrentDateTime::new, this.precision, this.configuration());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dateTime);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CurrentDateTime other = (CurrentDateTime)obj;
        return Objects.equals(this.dateTime, other.dateTime);
    }

    static ZonedDateTime nanoPrecision(ZonedDateTime zdt, int precision) {
        if (zdt != null) {
            int nano = zdt.getNano();
            if (precision >= 0 && precision < 10) {
                nano -= nano % (int)Math.pow(10.0, 9 - precision);
                return zdt.withNano(nano);
            }
        }
        return zdt;
    }
}

