/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.action;

import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.indexing.IndexerState;
import org.elasticsearch.xpack.core.rollup.action.StopRollupJobAction;
import org.elasticsearch.xpack.core.rollup.job.RollupJobStatus;
import org.elasticsearch.xpack.rollup.action.TransportTaskHelper;
import org.elasticsearch.xpack.rollup.job.RollupJobTask;

public class TransportStopRollupAction
extends TransportTasksAction<RollupJobTask, StopRollupJobAction.Request, StopRollupJobAction.Response, StopRollupJobAction.Response> {
    private final ThreadPool threadPool;

    @Inject
    public TransportStopRollupAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool) {
        super("cluster:admin/xpack/rollup/stop", clusterService, transportService, actionFilters, StopRollupJobAction.Request::new, StopRollupJobAction.Response::new, StopRollupJobAction.Response::new, "same");
        this.threadPool = threadPool;
    }

    protected void processTasks(StopRollupJobAction.Request request, Consumer<RollupJobTask> operation) {
        TransportTaskHelper.doProcessTasks(request.getId(), operation, this.taskManager);
    }

    protected void doExecute(Task task, StopRollupJobAction.Request request, ActionListener<StopRollupJobAction.Response> listener) {
        super.doExecute(task, (BaseTasksRequest)request, listener);
    }

    protected void taskOperation(StopRollupJobAction.Request request, RollupJobTask jobTask, ActionListener<StopRollupJobAction.Response> listener) {
        if (jobTask.getConfig().getId().equals(request.getId())) {
            jobTask.stop(TransportStopRollupAction.maybeWrapWithBlocking(request, jobTask, listener, this.threadPool));
        } else {
            listener.onFailure((Exception)new RuntimeException("ID of rollup task [" + jobTask.getConfig().getId() + "] does not match request's ID [" + request.getId() + "]"));
        }
    }

    private static ActionListener<StopRollupJobAction.Response> maybeWrapWithBlocking(StopRollupJobAction.Request request, RollupJobTask jobTask, ActionListener<StopRollupJobAction.Response> listener, ThreadPool threadPool) {
        if (request.waitForCompletion()) {
            return ActionListener.wrap(response -> {
                if (response.isStopped()) {
                    threadPool.generic().execute(() -> {
                        try {
                            boolean stopped = TransportStopRollupAction.awaitBusy(() -> ((RollupJobStatus)jobTask.getStatus()).getIndexerState().equals((Object)IndexerState.STOPPED), request.timeout());
                            if (stopped) {
                                listener.onResponse(response);
                            } else {
                                listener.onFailure((Exception)new ElasticsearchTimeoutException("Timed out after [" + request.timeout().getStringRep() + "] while waiting for rollup job [" + request.getId() + "] to stop", new Object[0]));
                            }
                        }
                        catch (InterruptedException e) {
                            listener.onFailure((Exception)e);
                        }
                    });
                } else {
                    listener.onResponse(response);
                }
            }, arg_0 -> listener.onFailure(arg_0));
        }
        return listener;
    }

    private static boolean awaitBusy(BooleanSupplier breakSupplier, TimeValue maxWaitTime) throws InterruptedException {
        long maxTimeInMillis = maxWaitTime.getMillis();
        long timeInMillis = 1L;
        long sum = 0L;
        while (sum + timeInMillis < maxTimeInMillis) {
            if (breakSupplier.getAsBoolean()) {
                return true;
            }
            Thread.sleep(timeInMillis);
            sum += timeInMillis;
            timeInMillis = Math.min(1000L, timeInMillis * 2L);
        }
        timeInMillis = maxTimeInMillis - sum;
        Thread.sleep(Math.max(timeInMillis, 0L));
        return breakSupplier.getAsBoolean();
    }

    protected StopRollupJobAction.Response newResponse(StopRollupJobAction.Request request, List<StopRollupJobAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        if (!taskOperationFailures.isEmpty()) {
            throw ExceptionsHelper.convertToElastic((Exception)taskOperationFailures.get(0).getCause());
        }
        if (!failedNodeExceptions.isEmpty()) {
            throw ExceptionsHelper.convertToElastic((Exception)((Exception)failedNodeExceptions.get(0)));
        }
        if (tasks.size() == 0) {
            throw new ResourceNotFoundException("Task for Rollup Job [" + request.getId() + "] not found", new Object[0]);
        }
        assert (tasks.size() == 1);
        boolean allStopped = tasks.stream().allMatch(StopRollupJobAction.Response::isStopped);
        return new StopRollupJobAction.Response(allStopped);
    }
}

