/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.EnginePlugin;
import org.elasticsearch.plugins.PersistentTaskPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.FixedExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.ccr.CcrLicenseChecker;
import org.elasticsearch.xpack.ccr.CcrRepositoryManager;
import org.elasticsearch.xpack.ccr.CcrSettings;
import org.elasticsearch.xpack.ccr.action.AutoFollowCoordinator;
import org.elasticsearch.xpack.ccr.action.ShardChangesAction;
import org.elasticsearch.xpack.ccr.action.ShardFollowTask;
import org.elasticsearch.xpack.ccr.action.ShardFollowTasksExecutor;
import org.elasticsearch.xpack.ccr.action.TransportCcrStatsAction;
import org.elasticsearch.xpack.ccr.action.TransportDeleteAutoFollowPatternAction;
import org.elasticsearch.xpack.ccr.action.TransportFollowStatsAction;
import org.elasticsearch.xpack.ccr.action.TransportGetAutoFollowPatternAction;
import org.elasticsearch.xpack.ccr.action.TransportPauseFollowAction;
import org.elasticsearch.xpack.ccr.action.TransportPutAutoFollowPatternAction;
import org.elasticsearch.xpack.ccr.action.TransportPutFollowAction;
import org.elasticsearch.xpack.ccr.action.TransportResumeFollowAction;
import org.elasticsearch.xpack.ccr.action.TransportUnfollowAction;
import org.elasticsearch.xpack.ccr.action.bulk.BulkShardOperationsAction;
import org.elasticsearch.xpack.ccr.action.bulk.TransportBulkShardOperationsAction;
import org.elasticsearch.xpack.ccr.action.repositories.DeleteInternalCcrRepositoryAction;
import org.elasticsearch.xpack.ccr.action.repositories.PutInternalCcrRepositoryAction;
import org.elasticsearch.xpack.ccr.index.engine.FollowingEngineFactory;
import org.elasticsearch.xpack.ccr.repository.CcrRepository;
import org.elasticsearch.xpack.ccr.rest.RestCcrStatsAction;
import org.elasticsearch.xpack.ccr.rest.RestDeleteAutoFollowPatternAction;
import org.elasticsearch.xpack.ccr.rest.RestFollowStatsAction;
import org.elasticsearch.xpack.ccr.rest.RestGetAutoFollowPatternAction;
import org.elasticsearch.xpack.ccr.rest.RestPauseFollowAction;
import org.elasticsearch.xpack.ccr.rest.RestPutAutoFollowPatternAction;
import org.elasticsearch.xpack.ccr.rest.RestPutFollowAction;
import org.elasticsearch.xpack.ccr.rest.RestResumeFollowAction;
import org.elasticsearch.xpack.ccr.rest.RestUnfollowAction;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ccr.ShardFollowNodeTaskStatus;
import org.elasticsearch.xpack.core.ccr.action.CcrStatsAction;
import org.elasticsearch.xpack.core.ccr.action.DeleteAutoFollowPatternAction;
import org.elasticsearch.xpack.core.ccr.action.FollowStatsAction;
import org.elasticsearch.xpack.core.ccr.action.GetAutoFollowPatternAction;
import org.elasticsearch.xpack.core.ccr.action.PauseFollowAction;
import org.elasticsearch.xpack.core.ccr.action.PutAutoFollowPatternAction;
import org.elasticsearch.xpack.core.ccr.action.PutFollowAction;
import org.elasticsearch.xpack.core.ccr.action.ResumeFollowAction;
import org.elasticsearch.xpack.core.ccr.action.UnfollowAction;

public class Ccr
extends Plugin
implements ActionPlugin,
PersistentTaskPlugin,
EnginePlugin,
RepositoryPlugin {
    public static final String CCR_THREAD_POOL_NAME = "ccr";
    public static final String CCR_CUSTOM_METADATA_KEY = "ccr";
    public static final String CCR_CUSTOM_METADATA_LEADER_INDEX_SHARD_HISTORY_UUIDS = "leader_index_shard_history_uuids";
    public static final String CCR_CUSTOM_METADATA_LEADER_INDEX_UUID_KEY = "leader_index_uuid";
    public static final String CCR_CUSTOM_METADATA_LEADER_INDEX_NAME_KEY = "leader_index_name";
    public static final String CCR_CUSTOM_METADATA_REMOTE_CLUSTER_NAME_KEY = "remote_cluster_name";
    private final boolean enabled;
    private final Settings settings;
    private final CcrLicenseChecker ccrLicenseChecker;
    private final SetOnce<CcrRepositoryManager> repositoryManager = new SetOnce();
    private Client client;

    public Ccr(Settings settings) {
        this(settings, new CcrLicenseChecker());
    }

    Ccr(Settings settings, CcrLicenseChecker ccrLicenseChecker) {
        this.settings = settings;
        this.enabled = (Boolean)XPackSettings.CCR_ENABLED_SETTING.get(settings);
        this.ccrLicenseChecker = Objects.requireNonNull(ccrLicenseChecker);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry) {
        this.client = client;
        if (!this.enabled) {
            return Collections.emptyList();
        }
        this.repositoryManager.set((Object)new CcrRepositoryManager(this.settings, clusterService, client));
        return Arrays.asList(this.ccrLicenseChecker, new AutoFollowCoordinator(client, clusterService, this.ccrLicenseChecker));
    }

    public List<PersistentTasksExecutor<?>> getPersistentTasksExecutor(ClusterService clusterService, ThreadPool threadPool, Client client, SettingsModule settingsModule) {
        IndexScopedSettings indexScopedSettings = settingsModule.getIndexScopedSettings();
        return Collections.singletonList(new ShardFollowTasksExecutor(client, threadPool, clusterService, indexScopedSettings));
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Arrays.asList(new ActionPlugin.ActionHandler((Action)BulkShardOperationsAction.INSTANCE, TransportBulkShardOperationsAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)ShardChangesAction.INSTANCE, ShardChangesAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)PutInternalCcrRepositoryAction.INSTANCE, PutInternalCcrRepositoryAction.TransportPutInternalRepositoryAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)DeleteInternalCcrRepositoryAction.INSTANCE, DeleteInternalCcrRepositoryAction.TransportDeleteInternalRepositoryAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)FollowStatsAction.INSTANCE, TransportFollowStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)CcrStatsAction.INSTANCE, TransportCcrStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)PutFollowAction.INSTANCE, TransportPutFollowAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)ResumeFollowAction.INSTANCE, TransportResumeFollowAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)PauseFollowAction.INSTANCE, TransportPauseFollowAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)UnfollowAction.INSTANCE, TransportUnfollowAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)DeleteAutoFollowPatternAction.INSTANCE, TransportDeleteAutoFollowPatternAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)PutAutoFollowPatternAction.INSTANCE, TransportPutAutoFollowPatternAction.class, new Class[0]), new ActionPlugin.ActionHandler((Action)GetAutoFollowPatternAction.INSTANCE, TransportGetAutoFollowPatternAction.class, new Class[0]));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Arrays.asList(new RestHandler[]{new RestFollowStatsAction(settings, restController), new RestCcrStatsAction(settings, restController), new RestPutFollowAction(settings, restController), new RestResumeFollowAction(settings, restController), new RestPauseFollowAction(settings, restController), new RestUnfollowAction(settings, restController), new RestDeleteAutoFollowPatternAction(settings, restController), new RestPutAutoFollowPatternAction(settings, restController), new RestGetAutoFollowPatternAction(settings, restController)});
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Arrays.asList(new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "xpack/ccr/shard_follow_task", ShardFollowTask::new), new NamedWriteableRegistry.Entry(Task.Status.class, "shard-follow-node-task-status", ShardFollowNodeTaskStatus::new));
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return Arrays.asList(new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("xpack/ccr/shard_follow_task", new String[0]), ShardFollowTask::fromXContent), new NamedXContentRegistry.Entry(ShardFollowNodeTaskStatus.class, new ParseField("shard-follow-node-task-status", new String[0]), ShardFollowNodeTaskStatus::fromXContent));
    }

    public List<Setting<?>> getSettings() {
        return CcrSettings.getSettings();
    }

    public Optional<EngineFactory> getEngineFactory(IndexSettings indexSettings) {
        if (((Boolean)CcrSettings.CCR_FOLLOWING_INDEX_SETTING.get(indexSettings.getSettings())).booleanValue()) {
            return Optional.of(new FollowingEngineFactory());
        }
        return Optional.empty();
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new FixedExecutorBuilder(settings, "ccr", 32, 100, "xpack.ccr.ccr_thread_pool"));
    }

    public Map<String, Repository.Factory> getInternalRepositories(Environment env, NamedXContentRegistry namedXContentRegistry) {
        Repository.Factory repositoryFactory = metadata -> new CcrRepository(metadata, this.client, this.ccrLicenseChecker, this.settings);
        return Collections.singletonMap("_ccr_", repositoryFactory);
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }
}

