/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.rest.action;

import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.watcher.client.WatcherClient;
import org.elasticsearch.xpack.core.watcher.transport.actions.get.GetWatchRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.get.GetWatchResponse;
import org.elasticsearch.xpack.watcher.rest.WatcherRestHandler;

public class RestGetWatchAction
extends WatcherRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestGetWatchAction.class));

    public RestGetWatchAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerWithDeprecatedHandler(RestRequest.Method.GET, "/_watcher/watch/{id}", (RestHandler)this, RestRequest.Method.GET, URI_BASE + "/watcher/watch/{id}", deprecationLogger);
    }

    public String getName() {
        return "watcher_get_watch";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doPrepareRequest(final RestRequest request, WatcherClient client) {
        GetWatchRequest getWatchRequest = new GetWatchRequest(request.param("id"));
        return channel -> client.getWatch(getWatchRequest, (ActionListener)new RestBuilderListener<GetWatchResponse>(channel){

            public RestResponse buildResponse(GetWatchResponse response, XContentBuilder builder) throws Exception {
                builder.startObject().field("found", response.isFound()).field("_id", response.getId());
                if (response.isFound()) {
                    builder.field("_version", response.getVersion());
                    ToXContent.MapParams xContentParams = new ToXContent.MapParams(request.params());
                    builder.field("status", (ToXContent)response.getStatus(), (ToXContent.Params)xContentParams);
                    builder.field("watch", (ToXContent)response.getSource(), (ToXContent.Params)xContentParams);
                }
                builder.endObject();
                RestStatus status = response.isFound() ? RestStatus.OK : RestStatus.NOT_FOUND;
                return new BytesRestResponse(status, builder);
            }
        });
    }
}

