/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.common.text;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;

public class TextTemplate
implements ToXContent {
    private final Script script;
    private final String inlineTemplate;
    private final boolean isUsingMustache;

    public TextTemplate(String template) {
        this.script = null;
        this.inlineTemplate = template;
        this.isUsingMustache = template.contains("{{");
    }

    public TextTemplate(String template, @Nullable XContentType contentType, ScriptType type, @Nullable Map<String, Object> params) {
        HashMap<String, String> options = null;
        if (type == ScriptType.INLINE) {
            options = new HashMap<String, String>();
            if (contentType != null) {
                options.put("content_type", contentType.mediaType());
            }
        }
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        this.script = new Script(type, type == ScriptType.STORED ? null : "mustache", template, options, params);
        this.isUsingMustache = template.contains("{{");
        this.inlineTemplate = null;
    }

    public TextTemplate(Script script) {
        this.script = script;
        this.inlineTemplate = null;
        this.isUsingMustache = script.getIdOrCode().contains("{{");
    }

    public Script getScript() {
        return this.script;
    }

    public String getTemplate() {
        return this.script != null ? this.script.getIdOrCode() : this.inlineTemplate;
    }

    public boolean isUsingMustache() {
        return this.isUsingMustache;
    }

    public XContentType getContentType() {
        if (this.script == null || this.script.getOptions() == null) {
            return null;
        }
        String mediaType = (String)this.script.getOptions().get("content_type");
        if (mediaType == null) {
            return null;
        }
        return XContentType.fromMediaTypeOrFormat((String)mediaType);
    }

    public ScriptType getType() {
        return this.script != null ? this.script.getType() : ScriptType.INLINE;
    }

    public Map<String, Object> getParams() {
        return this.script != null ? this.script.getParams() : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextTemplate template1 = (TextTemplate)o;
        return Objects.equals(this.script, template1.script) && Objects.equals(this.inlineTemplate, template1.inlineTemplate);
    }

    public int hashCode() {
        return Objects.hash(this.script, this.inlineTemplate);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.script != null) {
            this.script.toXContent(builder, params);
        } else {
            builder.value(this.inlineTemplate);
        }
        return builder;
    }

    public static TextTemplate parse(XContentParser parser) throws IOException {
        if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
            return new TextTemplate(parser.text());
        }
        Script template = Script.parse((XContentParser)parser, (String)"mustache");
        return new TextTemplate(template);
    }
}

