/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.search.suggest.phrase.DirectCandidateGenerator;
import org.elasticsearch.search.suggest.phrase.WordScorer;

public final class LinearInterpolatingScorer
extends WordScorer {
    private final double unigramLambda;
    private final double bigramLambda;
    private final double trigramLambda;

    public LinearInterpolatingScorer(IndexReader reader, Terms terms, String field, double realWordLikelyhood, BytesRef separator, double trigramLambda, double bigramLambda, double unigramLambda) throws IOException {
        super(reader, terms, field, realWordLikelyhood, separator);
        double sum = unigramLambda + bigramLambda + trigramLambda;
        this.unigramLambda = unigramLambda / sum;
        this.bigramLambda = bigramLambda / sum;
        this.trigramLambda = trigramLambda / sum;
    }

    double trigramLambda() {
        return this.trigramLambda;
    }

    double bigramLambda() {
        return this.bigramLambda;
    }

    double unigramLambda() {
        return this.unigramLambda;
    }

    @Override
    protected double scoreBigram(DirectCandidateGenerator.Candidate word, DirectCandidateGenerator.Candidate w_1) throws IOException {
        LinearInterpolatingScorer.join(this.separator, this.spare, w_1.term, word.term);
        long count = this.frequency(this.spare.get());
        if (count < 1L) {
            return this.unigramLambda * this.scoreUnigram(word);
        }
        return this.bigramLambda * ((double)count / (0.5 + (double)w_1.termStats.totalTermFreq)) + this.unigramLambda * this.scoreUnigram(word);
    }

    @Override
    protected double scoreTrigram(DirectCandidateGenerator.Candidate w, DirectCandidateGenerator.Candidate w_1, DirectCandidateGenerator.Candidate w_2) throws IOException {
        LinearInterpolatingScorer.join(this.separator, this.spare, w.term, w_1.term, w_2.term);
        long count = this.frequency(this.spare.get());
        if (count < 1L) {
            return this.scoreBigram(w, w_1);
        }
        LinearInterpolatingScorer.join(this.separator, this.spare, w.term, w_1.term);
        return this.trigramLambda * ((double)count / (1.0 + (double)this.frequency(this.spare.get()))) + this.scoreBigram(w, w_1);
    }
}

