/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.ParameterMap;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SearchLookup;

public abstract class FieldScript {
    public static final String[] PARAMETERS = new String[0];
    private static final Map<String, String> DEPRECATIONS;
    private final Map<String, Object> params;
    private final LeafSearchLookup leafLookup;
    public static final ScriptContext<Factory> CONTEXT;

    public FieldScript(Map<String, Object> params, SearchLookup lookup, LeafReaderContext leafContext) {
        this.leafLookup = lookup.getLeafSearchLookup(leafContext);
        params = new HashMap<String, Object>(params);
        params.putAll(this.leafLookup.asMap());
        this.params = new ParameterMap(params, DEPRECATIONS);
    }

    protected FieldScript() {
        this.params = null;
        this.leafLookup = null;
    }

    public abstract Object execute();

    protected final LeafSearchLookup getLeafLookup() {
        return this.leafLookup;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public final Map<String, ScriptDocValues<?>> getDoc() {
        return this.leafLookup.doc();
    }

    public void setDocument(int docid) {
        this.leafLookup.setDocument(docid);
    }

    static {
        HashMap<String, String> deprecations = new HashMap<String, String>();
        deprecations.put("doc", "Accessing variable [doc] via [params.doc] from within a field script is deprecated in favor of directly accessing [doc].");
        deprecations.put("_doc", "Accessing variable [doc] via [params._doc] from within a field script is deprecated in favor of directly accessing [doc].");
        DEPRECATIONS = Collections.unmodifiableMap(deprecations);
        CONTEXT = new ScriptContext<Factory>("field", Factory.class);
    }

    public static interface Factory {
        public LeafFactory newFactory(Map<String, Object> var1, SearchLookup var2);
    }

    public static interface LeafFactory {
        public FieldScript newInstance(LeafReaderContext var1) throws IOException;
    }
}

