/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.document.DoubleRange;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatRange;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.document.InetAddressRange;
import org.apache.lucene.document.IntRange;
import org.apache.lucene.document.LongRange;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.BinaryDocValuesRangeQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.common.util.LocaleUtils;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.BinaryRangeUtil;
import org.elasticsearch.index.mapper.CustomDocValuesField;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.joda.time.DateTimeZone;

public class RangeFieldMapper
extends FieldMapper {
    public static final boolean DEFAULT_INCLUDE_UPPER = true;
    public static final boolean DEFAULT_INCLUDE_LOWER = true;
    static final Setting<Boolean> COERCE_SETTING = Setting.boolSetting("index.mapping.coerce", true, Setting.Property.IndexScope);
    private Explicit<Boolean> coerce;

    private RangeFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> coerce, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        this.coerce = coerce;
    }

    @Override
    public RangeFieldType fieldType() {
        return (RangeFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType.typeName();
    }

    @Override
    protected RangeFieldMapper clone() {
        return (RangeFieldMapper)super.clone();
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        Range range;
        if (context.externalValueSet()) {
            range = context.parseExternalValue(Range.class);
        } else {
            XContentParser parser = context.parser();
            XContentParser.Token start = parser.currentToken();
            if (start == XContentParser.Token.VALUE_NULL) {
                return;
            }
            if (start == XContentParser.Token.START_OBJECT) {
                XContentParser.Token token;
                RangeFieldType fieldType = this.fieldType();
                RangeType rangeType = fieldType.rangeType;
                String fieldName = null;
                Object from = rangeType.minValue();
                Object to = rangeType.maxValue();
                boolean includeFrom = true;
                boolean includeTo = true;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        fieldName = parser.currentName();
                        continue;
                    }
                    if (fieldName.equals(RangeQueryBuilder.GT_FIELD.getPreferredName())) {
                        includeFrom = false;
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        from = rangeType.parseFrom(fieldType, parser, this.coerce.value(), includeFrom);
                        continue;
                    }
                    if (fieldName.equals(RangeQueryBuilder.GTE_FIELD.getPreferredName())) {
                        includeFrom = true;
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        from = rangeType.parseFrom(fieldType, parser, this.coerce.value(), includeFrom);
                        continue;
                    }
                    if (fieldName.equals(RangeQueryBuilder.LT_FIELD.getPreferredName())) {
                        includeTo = false;
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        to = rangeType.parseTo(fieldType, parser, this.coerce.value(), includeTo);
                        continue;
                    }
                    if (fieldName.equals(RangeQueryBuilder.LTE_FIELD.getPreferredName())) {
                        includeTo = true;
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        to = rangeType.parseTo(fieldType, parser, this.coerce.value(), includeTo);
                        continue;
                    }
                    throw new MapperParsingException("error parsing field [" + this.name() + "], with unknown parameter [" + fieldName + "]");
                }
                range = new Range(rangeType, from, to, includeFrom, includeTo);
            } else if (this.fieldType().rangeType == RangeType.IP && start == XContentParser.Token.VALUE_STRING) {
                range = RangeFieldMapper.parseIpRangeFromCidr(parser);
            } else {
                throw new MapperParsingException("error parsing field [" + this.name() + "], expected an object but got " + parser.currentName());
            }
        }
        boolean indexed = this.fieldType.indexOptions() != IndexOptions.NONE;
        boolean docValued = this.fieldType.hasDocValues();
        boolean stored = this.fieldType.stored();
        fields.addAll(this.fieldType().rangeType.createFields(context, this.name(), range, indexed, docValued, stored));
        if (!docValued && (indexed || stored)) {
            this.createFieldNamesField(context, fields);
        }
    }

    @Override
    protected void doMerge(Mapper mergeWith) {
        super.doMerge(mergeWith);
        RangeFieldMapper other = (RangeFieldMapper)mergeWith;
        if (other.coerce.explicit()) {
            this.coerce = other.coerce;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (this.fieldType().rangeType == RangeType.DATE && (includeDefaults || this.fieldType().dateTimeFormatter() != null && !this.fieldType().dateTimeFormatter().pattern().equals(DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.pattern()))) {
            builder.field("format", this.fieldType().dateTimeFormatter().pattern());
        }
        if (this.fieldType().rangeType == RangeType.DATE && (includeDefaults || this.fieldType().dateTimeFormatter() != null && this.fieldType().dateTimeFormatter().locale() != Locale.ROOT)) {
            builder.field("locale", (Object)this.fieldType().dateTimeFormatter().locale());
        }
        if (includeDefaults || this.coerce.explicit()) {
            builder.field("coerce", this.coerce.value());
        }
    }

    private static Range parseIpRangeFromCidr(XContentParser parser) throws IOException {
        Tuple<InetAddress, Integer> cidr = InetAddresses.parseCidr(parser.text());
        byte[] lower = ((InetAddress)cidr.v1()).getAddress();
        byte[] upper = (byte[])lower.clone();
        for (int i = ((Integer)cidr.v2()).intValue(); i < 8 * lower.length; ++i) {
            int m = 1 << 7 - (i & 7);
            int n = i >> 3;
            lower[n] = (byte)(lower[n] & ~m);
            int n2 = i >> 3;
            upper[n2] = (byte)(upper[n2] | m);
        }
        try {
            return new Range(RangeType.IP, InetAddress.getByAddress(lower), InetAddress.getByAddress(upper), true, true);
        }
        catch (UnknownHostException bogus) {
            throw new AssertionError((Object)bogus);
        }
    }

    static class BinaryRangesDocValuesField
    extends CustomDocValuesField {
        private final Set<Range> ranges;
        private final RangeType rangeType;

        BinaryRangesDocValuesField(String name, Range range, RangeType rangeType) {
            super(name);
            this.rangeType = rangeType;
            this.ranges = new HashSet<Range>();
            this.add(range);
        }

        void add(Range range) {
            this.ranges.add(range);
        }

        public BytesRef binaryValue() {
            try {
                return this.rangeType.encodeRanges(this.ranges);
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to encode ranges", (Throwable)e, new Object[0]);
            }
        }
    }

    public static class Range {
        RangeType type;
        Object from;
        Object to;
        private boolean includeFrom;
        private boolean includeTo;

        public Range(RangeType type, Object from, Object to, boolean includeFrom, boolean includeTo) {
            this.type = type;
            this.from = from;
            this.to = to;
            this.includeFrom = includeFrom;
            this.includeTo = includeTo;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.includeFrom ? (char)'[' : '(');
            Object f = this.includeFrom || this.from.equals(this.type.minValue()) ? this.from : this.type.nextDown(this.from);
            Object t = this.includeTo || this.to.equals(this.type.maxValue()) ? this.to : this.type.nextUp(this.to);
            sb.append(this.type == RangeType.IP ? InetAddresses.toAddrString((InetAddress)f) : f.toString());
            sb.append(" : ");
            sb.append(this.type == RangeType.IP ? InetAddresses.toAddrString((InetAddress)t) : t.toString());
            sb.append(this.includeTo ? (char)']' : ')');
            return sb.toString();
        }
    }

    public static abstract class RangeType
    extends Enum<RangeType> {
        public static final /* enum */ RangeType IP = new RangeType("ip_range"){

            @Override
            public Field getRangeField(String name, Range r) {
                return new InetAddressRange(name, (InetAddress)r.from, (InetAddress)r.to);
            }

            @Override
            public InetAddress parseFrom(RangeFieldType fieldType, XContentParser parser, boolean coerce, boolean included) throws IOException {
                InetAddress address = InetAddresses.forString(parser.text());
                return included ? address : this.nextUp(address);
            }

            @Override
            public InetAddress parseTo(RangeFieldType fieldType, XContentParser parser, boolean coerce, boolean included) throws IOException {
                InetAddress address = InetAddresses.forString(parser.text());
                return included ? address : this.nextDown(address);
            }

            @Override
            public InetAddress parse(Object value, boolean coerce) {
                if (value instanceof InetAddress) {
                    return (InetAddress)value;
                }
                if (value instanceof BytesRef) {
                    value = ((BytesRef)value).utf8ToString();
                }
                return InetAddresses.forString(value.toString());
            }

            @Override
            public InetAddress minValue() {
                return InetAddressPoint.MIN_VALUE;
            }

            @Override
            public InetAddress maxValue() {
                return InetAddressPoint.MAX_VALUE;
            }

            @Override
            public InetAddress nextUp(Object value) {
                return InetAddressPoint.nextUp((InetAddress)((InetAddress)value));
            }

            @Override
            public InetAddress nextDown(Object value) {
                return InetAddressPoint.nextDown((InetAddress)((InetAddress)value));
            }

            @Override
            public BytesRef encodeRanges(Set<Range> ranges) throws IOException {
                byte[] encoded = new byte[5 + 32 * ranges.size()];
                ByteArrayDataOutput out = new ByteArrayDataOutput(encoded);
                out.writeVInt(ranges.size());
                for (Range range : ranges) {
                    InetAddress fromValue = (InetAddress)range.from;
                    byte[] encodedFromValue = InetAddressPoint.encode((InetAddress)fromValue);
                    out.writeBytes(encodedFromValue, 0, encodedFromValue.length);
                    InetAddress toValue = (InetAddress)range.to;
                    byte[] encodedToValue = InetAddressPoint.encode((InetAddress)toValue);
                    out.writeBytes(encodedToValue, 0, encodedToValue.length);
                }
                return new BytesRef(encoded, 0, out.getPosition());
            }

            @Override
            public Query dvRangeQuery(String field, BinaryDocValuesRangeQuery.QueryType queryType, Object from, Object to, boolean includeFrom, boolean includeTo) {
                if (!includeFrom) {
                    from = this.nextUp(from);
                }
                if (!includeTo) {
                    to = this.nextDown(to);
                }
                byte[] encodedFrom = InetAddressPoint.encode((InetAddress)((InetAddress)from));
                byte[] encodedTo = InetAddressPoint.encode((InetAddress)((InetAddress)to));
                return new BinaryDocValuesRangeQuery(field, queryType, BinaryDocValuesRangeQuery.LengthType.FIXED_16, new BytesRef(encodedFrom), new BytesRef(encodedTo), from, to);
            }

            @Override
            public Query withinQuery(String field, Object from, Object to, boolean includeLower, boolean includeUpper) {
                InetAddress lower = (InetAddress)from;
                InetAddress upper = (InetAddress)to;
                return InetAddressRange.newWithinQuery((String)field, (InetAddress)(includeLower ? lower : this.nextUp(lower)), (InetAddress)(includeUpper ? upper : this.nextDown(upper)));
            }

            @Override
            public Query containsQuery(String field, Object from, Object to, boolean includeLower, boolean includeUpper) {
                InetAddress lower = (InetAddress)from;
                InetAddress upper = (InetAddress)to;
                return InetAddressRange.newContainsQuery((String)field, (InetAddress)(includeLower ? lower : this.nextUp(lower)), (InetAddress)(includeUpper ? upper : this.nextDown(upper)));
            }

            @Override
            public Query intersectsQuery(String field, Object from, Object to, boolean includeLower, boolean includeUpper) {
                InetAddress lower = (InetAddress)from;
                InetAddress upper = (InetAddress)to;
                return InetAddressRange.newIntersectsQuery((String)field, (InetAddress)(includeLower ? lower : this.nextUp(lower)), (InetAddress)(includeUpper ? upper : this.nextDown(upper)));
            }
        };
        public static final /* enum */ RangeType DATE = new RangeType("date_range", NumberFieldMapper.NumberType.LONG){

            @Override
            public Field getRangeField(String name, Range r) {
                return new LongRange(name, new long[]{((Number)r.from).longValue()}, new long[]{((Number)r.to).longValue()});
            }

            private Number parse(DateMathParser dateMathParser, String dateStr) {
                return dateMathParser.parse(dateStr, () -> {
                    throw new IllegalArgumentException("now is not used at indexing time");
                });
            }

            @Override
            public Number parseFrom(RangeFieldType fieldType, XContentParser parser, boolean coerce, boolean included) throws IOException {
                Number value = this.parse(fieldType.dateMathParser, parser.text());
                return included ? (Number)value : (Number)this.nextUp(value);
            }

            @Override
            public Number parseTo(RangeFieldType fieldType, XContentParser parser, boolean coerce, boolean included) throws IOException {
                Number value = this.parse(fieldType.dateMathParser, parser.text());
                return included ? (Number)value : (Number)this.nextDown(value);
            }

            @Override
            public Long minValue() {
                return Long.MIN_VALUE;
            }

            @Override
            public Long maxValue() {
                return Long.MAX_VALUE;
            }

            @Override
            public Long nextUp(Object value) {
                return (long)((Long)LONG.nextUp(value));
            }

            @Override
            public Long nextDown(Object value) {
                return (long)((Long)LONG.nextDown(value));
            }

            @Override
            public BytesRef encodeRanges(Set<Range> ranges) throws IOException {
                return LONG.encodeRanges(ranges);
            }

            @Override
            public Query dvRangeQuery(String field, BinaryDocValuesRangeQuery.QueryType queryType, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return LONG.dvRangeQuery(field, queryType, from, to, includeFrom, includeTo);
            }

            @Override
            public Query rangeQuery(String field, boolean hasDocValues, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, @Nullable DateTimeZone timeZone, @Nullable DateMathParser parser, QueryShardContext context) {
                DateMathParser dateMathParser;
                DateTimeZone zone = timeZone == null ? DateTimeZone.UTC : timeZone;
                ZoneId zoneId = DateUtils.dateTimeZoneToZoneId(zone);
                DateMathParser dateMathParser2 = dateMathParser = parser == null ? DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.toDateMathParser() : parser;
                Long low = lowerTerm == null ? Long.MIN_VALUE : dateMathParser.parse(lowerTerm instanceof BytesRef ? ((BytesRef)lowerTerm).utf8ToString() : lowerTerm.toString(), context::nowInMillis, false, zoneId);
                Long high = upperTerm == null ? Long.MAX_VALUE : dateMathParser.parse(upperTerm instanceof BytesRef ? ((BytesRef)upperTerm).utf8ToString() : upperTerm.toString(), context::nowInMillis, false, zoneId);
                return super.rangeQuery(field, hasDocValues, low, high, includeLower, includeUpper, relation, zone, dateMathParser, context);
            }

            @Override
            public Query withinQuery(String field, Object from, Object to, boolean includeLower, boolean includeUpper) {
                return LONG.withinQuery(field, from, to, includeLower, includeUpper);
            }

            @Override
            public Query containsQuery(String field, Object from, Object to, boolean includeLower, boolean includeUpper) {
                return LONG.containsQuery(field, from, to, includeLower, includeUpper);
            }

            @Override
            public Query intersectsQuery(String field, Object from, Object to, boolean includeLower, boolean includeUpper) {
                return LONG.intersectsQuery(field, from, to, includeLower, includeUpper);
            }
        };
        public static final /* enum */ RangeType FLOAT = new RangeType("float_range", NumberFieldMapper.NumberType.FLOAT){

            @Override
            public Float minValue() {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }

            @Override
            public Float maxValue() {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }

            @Override
            public Float nextUp(Object value) {
                return Float.valueOf(Math.nextUp(((Number)value).floatValue()));
            }

            @Override
            public Float nextDown(Object value) {
                return Float.valueOf(Math.nextDown(((Number)value).floatValue()));
            }

            @Override
            public BytesRef encodeRanges(Set<Range> ranges) throws IOException {
                return BinaryRangeUtil.encodeFloatRanges(ranges);
            }

            @Override
            public Query dvRangeQuery(String field, BinaryDocValuesRangeQuery.QueryType queryType, Object from, Object to, boolean includeFrom, boolean includeTo) {
                if (!includeFrom) {
                    from = this.nextUp(from);
                }
                if (!includeTo) {
                    to = this.nextDown(to);
                }
                byte[] encodedFrom = BinaryRangeUtil.encodeFloat(((Float)from).floatValue());
                byte[] encodedTo = BinaryRangeUtil.encodeFloat(((Float)to).floatValue());
                return new BinaryDocValuesRangeQuery(field, queryType, BinaryDocValuesRangeQuery.LengthType.FIXED_4, new BytesRef(encodedFrom), new BytesRef(encodedTo), from, to);
            }

            @Override
            public Field getRangeField(String name, Range r) {
                return new FloatRange(name, new float[]{((Number)r.from).floatValue()}, new float[]{((Number)r.to).floatValue()});
            }

            @Override
            public Query withinQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return FloatRange.newWithinQuery((String)field, (float[])new float[]{includeFrom ? ((Float)from).floatValue() : Math.nextUp(((Float)from).floatValue())}, (float[])new float[]{includeTo ? ((Float)to).floatValue() : Math.nextDown(((Float)to).floatValue())});
            }

            @Override
            public Query containsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return FloatRange.newContainsQuery((String)field, (float[])new float[]{includeFrom ? ((Float)from).floatValue() : Math.nextUp(((Float)from).floatValue())}, (float[])new float[]{includeTo ? ((Float)to).floatValue() : Math.nextDown(((Float)to).floatValue())});
            }

            @Override
            public Query intersectsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return FloatRange.newIntersectsQuery((String)field, (float[])new float[]{includeFrom ? ((Float)from).floatValue() : Math.nextUp(((Float)from).floatValue())}, (float[])new float[]{includeTo ? ((Float)to).floatValue() : Math.nextDown(((Float)to).floatValue())});
            }
        };
        public static final /* enum */ RangeType DOUBLE = new RangeType("double_range", NumberFieldMapper.NumberType.DOUBLE){

            @Override
            public Double minValue() {
                return Double.NEGATIVE_INFINITY;
            }

            @Override
            public Double maxValue() {
                return Double.POSITIVE_INFINITY;
            }

            @Override
            public Double nextUp(Object value) {
                return Math.nextUp(((Number)value).doubleValue());
            }

            @Override
            public Double nextDown(Object value) {
                return Math.nextDown(((Number)value).doubleValue());
            }

            @Override
            public BytesRef encodeRanges(Set<Range> ranges) throws IOException {
                return BinaryRangeUtil.encodeDoubleRanges(ranges);
            }

            @Override
            public Query dvRangeQuery(String field, BinaryDocValuesRangeQuery.QueryType queryType, Object from, Object to, boolean includeFrom, boolean includeTo) {
                if (!includeFrom) {
                    from = this.nextUp(from);
                }
                if (!includeTo) {
                    to = this.nextDown(to);
                }
                byte[] encodedFrom = BinaryRangeUtil.encodeDouble((Double)from);
                byte[] encodedTo = BinaryRangeUtil.encodeDouble((Double)to);
                return new BinaryDocValuesRangeQuery(field, queryType, BinaryDocValuesRangeQuery.LengthType.FIXED_8, new BytesRef(encodedFrom), new BytesRef(encodedTo), from, to);
            }

            @Override
            public Field getRangeField(String name, Range r) {
                return new DoubleRange(name, new double[]{((Number)r.from).doubleValue()}, new double[]{((Number)r.to).doubleValue()});
            }

            @Override
            public Query withinQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return DoubleRange.newWithinQuery((String)field, (double[])new double[]{includeFrom ? (Double)from : Math.nextUp((Double)from)}, (double[])new double[]{includeTo ? (Double)to : Math.nextDown((Double)to)});
            }

            @Override
            public Query containsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return DoubleRange.newContainsQuery((String)field, (double[])new double[]{includeFrom ? (Double)from : Math.nextUp((Double)from)}, (double[])new double[]{includeTo ? (Double)to : Math.nextDown((Double)to)});
            }

            @Override
            public Query intersectsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return DoubleRange.newIntersectsQuery((String)field, (double[])new double[]{includeFrom ? (Double)from : Math.nextUp((Double)from)}, (double[])new double[]{includeTo ? (Double)to : Math.nextDown((Double)to)});
            }
        };
        public static final /* enum */ RangeType INTEGER = new RangeType("integer_range", NumberFieldMapper.NumberType.INTEGER){

            @Override
            public Integer minValue() {
                return Integer.MIN_VALUE;
            }

            @Override
            public Integer maxValue() {
                return Integer.MAX_VALUE;
            }

            @Override
            public Integer nextUp(Object value) {
                return ((Number)value).intValue() + 1;
            }

            @Override
            public Integer nextDown(Object value) {
                return ((Number)value).intValue() - 1;
            }

            @Override
            public BytesRef encodeRanges(Set<Range> ranges) throws IOException {
                return LONG.encodeRanges(ranges);
            }

            @Override
            public Query dvRangeQuery(String field, BinaryDocValuesRangeQuery.QueryType queryType, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return LONG.dvRangeQuery(field, queryType, from, to, includeFrom, includeTo);
            }

            @Override
            public Field getRangeField(String name, Range r) {
                return new IntRange(name, new int[]{((Number)r.from).intValue()}, new int[]{((Number)r.to).intValue()});
            }

            @Override
            public Query withinQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return IntRange.newWithinQuery((String)field, (int[])new int[]{(Integer)from + (includeFrom ? 0 : 1)}, (int[])new int[]{(Integer)to - (includeTo ? 0 : 1)});
            }

            @Override
            public Query containsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return IntRange.newContainsQuery((String)field, (int[])new int[]{(Integer)from + (includeFrom ? 0 : 1)}, (int[])new int[]{(Integer)to - (includeTo ? 0 : 1)});
            }

            @Override
            public Query intersectsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return IntRange.newIntersectsQuery((String)field, (int[])new int[]{(Integer)from + (includeFrom ? 0 : 1)}, (int[])new int[]{(Integer)to - (includeTo ? 0 : 1)});
            }
        };
        public static final /* enum */ RangeType LONG = new RangeType("long_range", NumberFieldMapper.NumberType.LONG){

            @Override
            public Long minValue() {
                return Long.MIN_VALUE;
            }

            @Override
            public Long maxValue() {
                return Long.MAX_VALUE;
            }

            @Override
            public Long nextUp(Object value) {
                return ((Number)value).longValue() + 1L;
            }

            @Override
            public Long nextDown(Object value) {
                return ((Number)value).longValue() - 1L;
            }

            @Override
            public BytesRef encodeRanges(Set<Range> ranges) throws IOException {
                return BinaryRangeUtil.encodeLongRanges(ranges);
            }

            @Override
            public Query dvRangeQuery(String field, BinaryDocValuesRangeQuery.QueryType queryType, Object from, Object to, boolean includeFrom, boolean includeTo) {
                if (!includeFrom) {
                    from = this.nextUp(from);
                }
                if (!includeTo) {
                    to = this.nextDown(to);
                }
                byte[] encodedFrom = BinaryRangeUtil.encodeLong(((Number)from).longValue());
                byte[] encodedTo = BinaryRangeUtil.encodeLong(((Number)to).longValue());
                return new BinaryDocValuesRangeQuery(field, queryType, BinaryDocValuesRangeQuery.LengthType.VARIABLE, new BytesRef(encodedFrom), new BytesRef(encodedTo), from, to);
            }

            @Override
            public Field getRangeField(String name, Range r) {
                return new LongRange(name, new long[]{((Number)r.from).longValue()}, new long[]{((Number)r.to).longValue()});
            }

            @Override
            public Query withinQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return LongRange.newWithinQuery((String)field, (long[])new long[]{(Long)from + (long)(includeFrom ? 0 : 1)}, (long[])new long[]{(Long)to - (long)(includeTo ? 0 : 1)});
            }

            @Override
            public Query containsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return LongRange.newContainsQuery((String)field, (long[])new long[]{(Long)from + (long)(includeFrom ? 0 : 1)}, (long[])new long[]{(Long)to - (long)(includeTo ? 0 : 1)});
            }

            @Override
            public Query intersectsQuery(String field, Object from, Object to, boolean includeFrom, boolean includeTo) {
                return LongRange.newIntersectsQuery((String)field, (long[])new long[]{(Long)from + (long)(includeFrom ? 0 : 1)}, (long[])new long[]{(Long)to - (long)(includeTo ? 0 : 1)});
            }
        };
        public final String name;
        private final NumberFieldMapper.NumberType numberType;
        private static final /* synthetic */ RangeType[] $VALUES;

        public static RangeType[] values() {
            return (RangeType[])$VALUES.clone();
        }

        public static RangeType valueOf(String name) {
            return Enum.valueOf(RangeType.class, name);
        }

        private RangeType(String name) {
            this.name = name;
            this.numberType = null;
        }

        private RangeType(String name, NumberFieldMapper.NumberType type) {
            this.name = name;
            this.numberType = type;
        }

        public final String typeName() {
            return this.name;
        }

        public abstract Field getRangeField(String var1, Range var2);

        public List<IndexableField> createFields(ParseContext context, String name, Range range, boolean indexed, boolean docValued, boolean stored) {
            assert (range != null) : "range cannot be null when creating fields";
            ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
            if (indexed) {
                fields.add((IndexableField)this.getRangeField(name, range));
            }
            if (docValued) {
                BinaryRangesDocValuesField field = (BinaryRangesDocValuesField)context.doc().getByKey(name);
                if (field == null) {
                    field = new BinaryRangesDocValuesField(name, range, this);
                    context.doc().addWithKey(name, field);
                } else {
                    field.add(range);
                }
            }
            if (stored) {
                fields.add((IndexableField)new StoredField(name, range.toString()));
            }
            return fields;
        }

        public Object parseFrom(RangeFieldType fieldType, XContentParser parser, boolean coerce, boolean included) throws IOException {
            Number value = this.numberType.parse(parser, coerce);
            return included ? (Number)value : (Number)((Number)this.nextUp(value));
        }

        public Object parseTo(RangeFieldType fieldType, XContentParser parser, boolean coerce, boolean included) throws IOException {
            Number value = this.numberType.parse(parser, coerce);
            return included ? (Number)value : (Number)((Number)this.nextDown(value));
        }

        public abstract Object minValue();

        public abstract Object maxValue();

        public abstract Object nextUp(Object var1);

        public abstract Object nextDown(Object var1);

        public abstract Query withinQuery(String var1, Object var2, Object var3, boolean var4, boolean var5);

        public abstract Query containsQuery(String var1, Object var2, Object var3, boolean var4, boolean var5);

        public abstract Query intersectsQuery(String var1, Object var2, Object var3, boolean var4, boolean var5);

        public Object parse(Object value, boolean coerce) {
            return this.numberType.parse(value, coerce);
        }

        public Query rangeQuery(String field, boolean hasDocValues, Object from, Object to, boolean includeFrom, boolean includeTo, ShapeRelation relation, @Nullable DateTimeZone timeZone, @Nullable DateMathParser dateMathParser, QueryShardContext context) {
            Object upper;
            Object lower = from == null ? this.minValue() : this.parse(from, false);
            Object object = upper = to == null ? this.maxValue() : this.parse(to, false);
            Query indexQuery = relation == ShapeRelation.WITHIN ? this.withinQuery(field, lower, upper, includeFrom, includeTo) : (relation == ShapeRelation.CONTAINS ? this.containsQuery(field, lower, upper, includeFrom, includeTo) : this.intersectsQuery(field, lower, upper, includeFrom, includeTo));
            if (hasDocValues) {
                BinaryDocValuesRangeQuery.QueryType queryType = relation == ShapeRelation.WITHIN ? BinaryDocValuesRangeQuery.QueryType.WITHIN : (relation == ShapeRelation.CONTAINS ? BinaryDocValuesRangeQuery.QueryType.CONTAINS : BinaryDocValuesRangeQuery.QueryType.INTERSECTS);
                Query dvQuery = this.dvRangeQuery(field, queryType, lower, upper, includeFrom, includeTo);
                return new IndexOrDocValuesQuery(indexQuery, dvQuery);
            }
            return indexQuery;
        }

        public abstract BytesRef encodeRanges(Set<Range> var1) throws IOException;

        public abstract Query dvRangeQuery(String var1, BinaryDocValuesRangeQuery.QueryType var2, Object var3, Object var4, boolean var5, boolean var6);

        static {
            $VALUES = new RangeType[]{IP, DATE, FLOAT, DOUBLE, INTEGER, LONG};
        }
    }

    public static final class RangeFieldType
    extends MappedFieldType {
        protected RangeType rangeType;
        protected DateFormatter dateTimeFormatter;
        protected DateMathParser dateMathParser;

        RangeFieldType(RangeType type) {
            this.rangeType = Objects.requireNonNull(type);
            this.setTokenized(false);
            this.setHasDocValues(true);
            this.setOmitNorms(true);
            if (this.rangeType == RangeType.DATE) {
                this.setDateTimeFormatter(DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER);
            }
        }

        RangeFieldType(RangeFieldType other) {
            super(other);
            this.rangeType = other.rangeType;
            if (other.dateTimeFormatter() != null) {
                this.setDateTimeFormatter(other.dateTimeFormatter);
            }
        }

        @Override
        public MappedFieldType clone() {
            return new RangeFieldType(this);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            RangeFieldType that = (RangeFieldType)((Object)o);
            return Objects.equals((Object)this.rangeType, (Object)that.rangeType) && this.rangeType == RangeType.DATE ? Objects.equals(this.dateTimeFormatter.pattern(), that.dateTimeFormatter.pattern()) && Objects.equals(this.dateTimeFormatter.locale(), that.dateTimeFormatter.locale()) : this.dateTimeFormatter == null && that.dateTimeFormatter == null;
        }

        @Override
        public int hashCode() {
            return this.dateTimeFormatter == null ? Objects.hash(new Object[]{super.hashCode(), this.rangeType}) : Objects.hash(new Object[]{super.hashCode(), this.rangeType, this.dateTimeFormatter.pattern(), this.dateTimeFormatter.locale()});
        }

        @Override
        public String typeName() {
            return this.rangeType.name;
        }

        public DateFormatter dateTimeFormatter() {
            return this.dateTimeFormatter;
        }

        public void setDateTimeFormatter(DateFormatter dateTimeFormatter) {
            this.checkIfFrozen();
            this.dateTimeFormatter = dateTimeFormatter;
            this.dateMathParser = dateTimeFormatter.toDateMathParser();
        }

        protected DateMathParser dateMathParser() {
            return this.dateMathParser;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            if (this.hasDocValues()) {
                return new DocValuesFieldExistsQuery(this.name());
            }
            return new TermQuery(new Term("_field_names", this.name()));
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            Query query = this.rangeQuery(value, value, true, true, ShapeRelation.INTERSECTS, null, null, context);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, DateTimeZone timeZone, DateMathParser parser, QueryShardContext context) {
            this.failIfNotIndexed();
            if (parser == null) {
                parser = this.dateMathParser();
            }
            return this.rangeType.rangeQuery(this.name(), this.hasDocValues(), lowerTerm, upperTerm, includeLower, includeUpper, relation, timeZone, parser, context);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        final RangeType type;

        public TypeParser(RangeType type) {
            this.type = type;
        }

        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name, this.type);
            TypeParsers.parseField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    throw new MapperParsingException("Property [null_value] is not supported for [" + this.type.name + "] field types.");
                }
                if (propName.equals("coerce")) {
                    builder.coerce(XContentMapValues.nodeBooleanValue(propNode, name + ".coerce"));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("locale")) {
                    builder.locale(LocaleUtils.parse(propNode.toString()));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("format")) {
                    builder.dateTimeFormatter(TypeParsers.parseDateTimeFormatter(propNode));
                    iterator.remove();
                    continue;
                }
                if (!TypeParsers.parseMultiField(builder, name, parserContext, propName, propNode)) continue;
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, RangeFieldMapper> {
        private Boolean coerce;
        private Locale locale;

        public Builder(String name, RangeType type) {
            super(name, new RangeFieldType(type), new RangeFieldType(type));
            this.builder = this;
            this.locale = Locale.ROOT;
        }

        @Override
        public RangeFieldType fieldType() {
            return (RangeFieldType)this.fieldType;
        }

        @Override
        public Builder docValues(boolean docValues) {
            if (docValues) {
                throw new IllegalArgumentException("field [" + this.name + "] does not currently support " + "doc_values");
            }
            return (Builder)super.docValues(docValues);
        }

        public Builder coerce(boolean coerce) {
            this.coerce = coerce;
            return (Builder)this.builder;
        }

        protected Explicit<Boolean> coerce(Mapper.BuilderContext context) {
            if (this.coerce != null) {
                return new Explicit<Boolean>(this.coerce, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(COERCE_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.COERCE;
        }

        public Builder dateTimeFormatter(DateFormatter dateTimeFormatter) {
            this.fieldType().setDateTimeFormatter(dateTimeFormatter);
            return this;
        }

        @Override
        public Builder nullValue(Object nullValue) {
            throw new IllegalArgumentException("Field [" + this.name() + "] does not support null value.");
        }

        public void locale(Locale locale) {
            this.locale = locale;
        }

        @Override
        protected void setupFieldType(Mapper.BuilderContext context) {
            super.setupFieldType(context);
            DateFormatter dateTimeFormatter = this.fieldType().dateTimeFormatter;
            if (this.fieldType().rangeType == RangeType.DATE) {
                if (!this.locale.equals(dateTimeFormatter.locale())) {
                    this.fieldType().setDateTimeFormatter(dateTimeFormatter.withLocale(this.locale));
                }
            } else if (dateTimeFormatter != null) {
                throw new IllegalArgumentException("field [" + this.name() + "] of type [" + (Object)((Object)this.fieldType().rangeType) + "] should not define a dateTimeFormatter unless it is a " + (Object)((Object)RangeType.DATE) + " type");
            }
        }

        @Override
        public RangeFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new RangeFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.coerce(context), context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final Explicit<Boolean> COERCE = new Explicit<Boolean>(true, false);
    }
}

