/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.proto;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.xpack.sql.proto.Mode;

public class RequestInfo {
    public static final String CLI = "cli";
    private static final String CANVAS = "canvas";
    public static final List<String> CLIENT_IDS = Arrays.asList("cli", "canvas");
    private Mode mode;
    private String clientId;

    public RequestInfo(Mode mode) {
        this(mode, null);
    }

    public RequestInfo(Mode mode, String clientId) {
        this.mode(mode);
        this.clientId(clientId);
    }

    public Mode mode() {
        return this.mode;
    }

    public void mode(Mode mode) {
        this.mode = mode;
    }

    public String clientId() {
        return this.clientId;
    }

    public void clientId(String clientId) {
        if (clientId != null && !CLIENT_IDS.contains(clientId = clientId.toLowerCase(Locale.ROOT))) {
            clientId = null;
        }
        this.clientId = clientId;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.clientId});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestInfo that = (RequestInfo)o;
        return Objects.equals((Object)this.mode, (Object)that.mode) && Objects.equals(this.clientId, that.clientId);
    }
}

