/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptedMetricAggContexts;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.ScriptedMetric;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class InternalScriptedMetric
extends InternalAggregation
implements ScriptedMetric {
    final Script reduceScript;
    private final List<Object> aggregation;

    InternalScriptedMetric(String name, Object aggregation, Script reduceScript, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        this(name, Collections.singletonList(aggregation), reduceScript, pipelineAggregators, metaData);
    }

    private InternalScriptedMetric(String name, List<Object> aggregation, Script reduceScript, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.aggregation = aggregation;
        this.reduceScript = reduceScript;
    }

    public InternalScriptedMetric(StreamInput in) throws IOException {
        super(in);
        this.reduceScript = in.readOptionalWriteable(Script::new);
        this.aggregation = Collections.singletonList(in.readGenericValue());
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.reduceScript);
        out.writeGenericValue(this.aggregation());
    }

    @Override
    public String getWriteableName() {
        return "scripted_metric";
    }

    @Override
    public Object aggregation() {
        if (this.aggregation.size() != 1) {
            throw new IllegalStateException("aggregation was not reduced");
        }
        return this.aggregation.get(0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        void var5_9;
        ArrayList<Object> aggregationObjects = new ArrayList<Object>();
        for (InternalAggregation internalAggregation : aggregations) {
            InternalScriptedMetric mapReduceAggregation = (InternalScriptedMetric)internalAggregation;
            aggregationObjects.addAll(mapReduceAggregation.aggregation);
        }
        InternalScriptedMetric firstAggregation = (InternalScriptedMetric)aggregations.get(0);
        if (firstAggregation.reduceScript != null && reduceContext.isFinalReduce()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (firstAggregation.reduceScript.getParams() != null) {
                params.putAll(firstAggregation.reduceScript.getParams());
            }
            ScriptedMetricAggContexts.ReduceScript.Factory factory = reduceContext.scriptService().compile(firstAggregation.reduceScript, ScriptedMetricAggContexts.ReduceScript.CONTEXT);
            ScriptedMetricAggContexts.ReduceScript script = factory.newInstance(params, aggregationObjects);
            Object scriptResult = script.execute();
            CollectionUtils.ensureNoSelfReferences(scriptResult, "reduce script");
            List<Object> list = Collections.singletonList(scriptResult);
        } else if (reduceContext.isFinalReduce()) {
            List list = Collections.singletonList(aggregationObjects);
        } else {
            ArrayList<Object> arrayList = aggregationObjects;
        }
        return new InternalScriptedMetric(firstAggregation.getName(), (List<Object>)var5_9, firstAggregation.reduceScript, this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1 && "value".equals(path.get(0))) {
            return this.aggregation();
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), this.aggregation());
    }

    @Override
    protected boolean doEquals(Object obj) {
        InternalScriptedMetric other = (InternalScriptedMetric)obj;
        return Objects.equals(this.reduceScript, other.reduceScript) && Objects.equals(this.aggregation, other.aggregation);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.reduceScript, this.aggregation);
    }
}

