/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.discovery.PeerFinder;
import org.elasticsearch.discovery.zen.UnicastHostsProvider;
import org.elasticsearch.discovery.zen.UnicastZenPing;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class UnicastConfiguredHostsResolver
extends AbstractLifecycleComponent
implements PeerFinder.ConfiguredHostsResolver {
    private static final Logger logger = LogManager.getLogger(UnicastConfiguredHostsResolver.class);
    private final Settings settings;
    private final AtomicBoolean resolveInProgress = new AtomicBoolean();
    private final TransportService transportService;
    private final UnicastHostsProvider hostsProvider;
    private final SetOnce<ExecutorService> executorService = new SetOnce();
    private final TimeValue resolveTimeout;
    private final String nodeName;

    public UnicastConfiguredHostsResolver(String nodeName, Settings settings, TransportService transportService, UnicastHostsProvider hostsProvider) {
        super(settings);
        this.settings = settings;
        this.nodeName = nodeName;
        this.transportService = transportService;
        this.hostsProvider = hostsProvider;
        this.resolveTimeout = UnicastZenPing.DISCOVERY_ZEN_PING_UNICAST_HOSTS_RESOLVE_TIMEOUT.get(settings);
    }

    @Override
    protected void doStart() {
        int concurrentConnects = UnicastZenPing.DISCOVERY_ZEN_PING_UNICAST_CONCURRENT_CONNECTS_SETTING.get(this.settings);
        logger.debug("using concurrent_connects [{}], resolve_timeout [{}]", (Object)concurrentConnects, (Object)this.resolveTimeout);
        ThreadFactory threadFactory = EsExecutors.daemonThreadFactory(this.settings, "[unicast_configured_hosts_resolver]");
        this.executorService.set((Object)EsExecutors.newScaling(this.nodeName + "/unicast_configured_hosts_resolver", 0, concurrentConnects, 60L, TimeUnit.SECONDS, threadFactory, this.transportService.getThreadPool().getThreadContext()));
    }

    @Override
    protected void doStop() {
        ThreadPool.terminate((ExecutorService)this.executorService.get(), 10L, TimeUnit.SECONDS);
    }

    @Override
    protected void doClose() {
    }

    @Override
    public void resolveConfiguredHosts(final Consumer<List<TransportAddress>> consumer) {
        if (!this.lifecycle.started()) {
            logger.debug("resolveConfiguredHosts: lifecycle is {}, not proceeding", (Object)this.lifecycle);
            return;
        }
        if (this.resolveInProgress.compareAndSet(false, true)) {
            this.transportService.getThreadPool().generic().execute(new AbstractRunnable(){

                @Override
                public void onFailure(Exception e) {
                    logger.debug("failure when resolving unicast hosts list", (Throwable)e);
                }

                @Override
                protected void doRun() {
                    if (!UnicastConfiguredHostsResolver.this.lifecycle.started()) {
                        logger.debug("resolveConfiguredHosts.doRun: lifecycle is {}, not proceeding", (Object)UnicastConfiguredHostsResolver.this.lifecycle);
                        return;
                    }
                    List<TransportAddress> providedAddresses = UnicastConfiguredHostsResolver.this.hostsProvider.buildDynamicHosts((hosts, limitPortCounts) -> UnicastZenPing.resolveHostsLists((ExecutorService)UnicastConfiguredHostsResolver.this.executorService.get(), logger, hosts, limitPortCounts, UnicastConfiguredHostsResolver.this.transportService, UnicastConfiguredHostsResolver.this.resolveTimeout));
                    consumer.accept(providedAddresses);
                }

                @Override
                public void onAfter() {
                    UnicastConfiguredHostsResolver.this.resolveInProgress.set(false);
                }

                public String toString() {
                    return "UnicastConfiguredHostsResolver resolving unicast hosts list";
                }
            });
        }
    }
}

