/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.modelsnapshots;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.GetModelSnapshotsAction;
import org.elasticsearch.xpack.core.ml.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class RestGetModelSnapshotsAction
extends BaseRestHandler {
    private static final String ALL = "_all";
    private static final String ALL_SNAPSHOT_IDS = null;
    private static final String DEFAULT_SORT = null;
    private static final String DEFAULT_START = null;
    private static final String DEFAULT_END = null;
    private static final boolean DEFAULT_DESC_ORDER = true;
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestGetModelSnapshotsAction.class));

    public RestGetModelSnapshotsAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerWithDeprecatedHandler(RestRequest.Method.GET, "/_ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/model_snapshots/{" + GetModelSnapshotsAction.Request.SNAPSHOT_ID.getPreferredName() + "}", (RestHandler)this, RestRequest.Method.GET, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/model_snapshots/{" + GetModelSnapshotsAction.Request.SNAPSHOT_ID.getPreferredName() + "}", deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, "/_ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/model_snapshots/{" + GetModelSnapshotsAction.Request.SNAPSHOT_ID.getPreferredName() + "}", (RestHandler)this, RestRequest.Method.POST, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/model_snapshots/{" + GetModelSnapshotsAction.Request.SNAPSHOT_ID.getPreferredName() + "}", deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.GET, "/_ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/model_snapshots", (RestHandler)this, RestRequest.Method.GET, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/model_snapshots", deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, "/_ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/model_snapshots", (RestHandler)this, RestRequest.Method.POST, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/model_snapshots", deprecationLogger);
    }

    public String getName() {
        return "ml_get_model_snapshot_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        GetModelSnapshotsAction.Request getModelSnapshots;
        String jobId = restRequest.param(Job.ID.getPreferredName());
        String snapshotId = restRequest.param(GetModelSnapshotsAction.Request.SNAPSHOT_ID.getPreferredName());
        if (ALL.equals(snapshotId)) {
            snapshotId = ALL_SNAPSHOT_IDS;
        }
        if (restRequest.hasContentOrSourceParam()) {
            XContentParser parser = restRequest.contentOrSourceParamParser();
            getModelSnapshots = GetModelSnapshotsAction.Request.parseRequest((String)jobId, (String)snapshotId, (XContentParser)parser);
        } else {
            getModelSnapshots = new GetModelSnapshotsAction.Request(jobId, snapshotId);
            getModelSnapshots.setSort(restRequest.param(GetModelSnapshotsAction.Request.SORT.getPreferredName(), DEFAULT_SORT));
            if (restRequest.hasParam(GetModelSnapshotsAction.Request.START.getPreferredName())) {
                getModelSnapshots.setStart(restRequest.param(GetModelSnapshotsAction.Request.START.getPreferredName(), DEFAULT_START));
            }
            if (restRequest.hasParam(GetModelSnapshotsAction.Request.END.getPreferredName())) {
                getModelSnapshots.setEnd(restRequest.param(GetModelSnapshotsAction.Request.END.getPreferredName(), DEFAULT_END));
            }
            getModelSnapshots.setDescOrder(restRequest.paramAsBoolean(GetModelSnapshotsAction.Request.DESC.getPreferredName(), true));
            getModelSnapshots.setPageParams(new PageParams(restRequest.paramAsInt(PageParams.FROM.getPreferredName(), 0), restRequest.paramAsInt(PageParams.SIZE.getPreferredName(), 100)));
        }
        return channel -> client.execute((Action)GetModelSnapshotsAction.INSTANCE, (ActionRequest)getModelSnapshots, (ActionListener)new RestToXContentListener(channel));
    }
}

