/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.job;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.PutJobAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class RestPutJobAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestPutJobAction.class));

    public RestPutJobAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerWithDeprecatedHandler(RestRequest.Method.PUT, "/_ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}", (RestHandler)this, RestRequest.Method.PUT, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}", deprecationLogger);
    }

    public String getName() {
        return "ml_put_job_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String jobId = restRequest.param(Job.ID.getPreferredName());
        XContentParser parser = restRequest.contentParser();
        PutJobAction.Request putJobRequest = PutJobAction.Request.parseRequest((String)jobId, (XContentParser)parser);
        putJobRequest.timeout(restRequest.paramAsTime("timeout", putJobRequest.timeout()));
        putJobRequest.masterNodeTimeout(restRequest.paramAsTime("master_timeout", putJobRequest.masterNodeTimeout()));
        return channel -> client.execute((Action)PutJobAction.INSTANCE, (ActionRequest)putJobRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

