/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.filestructurefinder;

import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.grok.Grok;
import org.elasticsearch.grok.ThreadWatchdog;

public class TimeoutChecker
implements Closeable {
    private static final TimeoutCheckerWatchdog timeoutCheckerWatchdog = new TimeoutCheckerWatchdog();
    public static final ThreadWatchdog watchdog = timeoutCheckerWatchdog;
    private final String operation;
    private final TimeValue timeout;
    private final Thread checkedThread;
    private final ScheduledFuture<?> future;
    private volatile boolean timeoutExceeded;

    public TimeoutChecker(String operation, TimeValue timeout, ScheduledExecutorService scheduler) {
        this.operation = operation;
        this.timeout = timeout;
        this.checkedThread = Thread.currentThread();
        timeoutCheckerWatchdog.add(this.checkedThread, timeout);
        this.future = timeout != null ? scheduler.schedule(this::setTimeoutExceeded, timeout.nanos(), TimeUnit.NANOSECONDS) : null;
    }

    @Override
    public void close() {
        FutureUtils.cancel(this.future);
        timeoutCheckerWatchdog.remove(this.checkedThread);
    }

    public void check(String where) {
        if (this.timeoutExceeded) {
            throw new ElasticsearchTimeoutException("Aborting " + this.operation + " during [" + where + "] as it has taken longer than the timeout of [" + this.timeout + "]", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> grokCaptures(Grok grok, String text, String where) {
        try {
            Map map = grok.captures(text);
            return map;
        }
        finally {
            this.check(where);
        }
    }

    private void setTimeoutExceeded() {
        this.timeoutExceeded = true;
        timeoutCheckerWatchdog.interruptLongRunningThreadIfRegistered(this.checkedThread);
    }

    static class TimeoutCheckerWatchdog
    implements ThreadWatchdog {
        final ConcurrentHashMap<Thread, Tuple<AtomicBoolean, TimeValue>> registry = new ConcurrentHashMap();

        TimeoutCheckerWatchdog() {
        }

        void add(Thread thread, TimeValue timeout) {
            Tuple<AtomicBoolean, TimeValue> previousValue = this.registry.put(thread, (Tuple<AtomicBoolean, TimeValue>)new Tuple((Object)new AtomicBoolean(false), (Object)timeout));
            assert (previousValue == null);
        }

        public void register() {
            Tuple<AtomicBoolean, TimeValue> value = this.registry.get(Thread.currentThread());
            if (value != null) {
                boolean wasFalse = ((AtomicBoolean)value.v1()).compareAndSet(false, true);
                assert (wasFalse);
            }
        }

        public long maxExecutionTimeInMillis() {
            Tuple<AtomicBoolean, TimeValue> value = this.registry.get(Thread.currentThread());
            return value != null ? ((TimeValue)value.v2()).getMillis() : Long.MAX_VALUE;
        }

        public void unregister() {
            Tuple<AtomicBoolean, TimeValue> value = this.registry.get(Thread.currentThread());
            if (value != null) {
                boolean wasTrue = ((AtomicBoolean)value.v1()).compareAndSet(true, false);
                assert (wasTrue);
            }
        }

        void remove(Thread thread) {
            Tuple<AtomicBoolean, TimeValue> previousValue = this.registry.remove(thread);
            assert (previousValue != null);
        }

        void interruptLongRunningThreadIfRegistered(Thread thread) {
            Tuple<AtomicBoolean, TimeValue> value = this.registry.get(thread);
            if (((AtomicBoolean)value.v1()).get()) {
                thread.interrupt();
            }
        }
    }
}

