/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor;

import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.rollup.action.GetRollupIndexCapsAction;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.AggregationDataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.RollupDataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.chunked.ChunkedDataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.scroll.ScrollDataExtractorFactory;

public interface DataExtractorFactory {
    public DataExtractor newExtractor(long var1, long var3);

    public static void create(Client client, DatafeedConfig datafeed, Job job, ActionListener<DataExtractorFactory> listener) {
        ActionListener factoryHandler = ActionListener.wrap(factory -> listener.onResponse((Object)(datafeed.getChunkingConfig().isEnabled() ? new ChunkedDataExtractorFactory(client, datafeed, job, (DataExtractorFactory)factory) : factory)), arg_0 -> listener.onFailure(arg_0));
        ActionListener getRollupIndexCapsActionHandler = ActionListener.wrap(response -> {
            if (response.getJobs().isEmpty()) {
                if (datafeed.hasAggregations()) {
                    factoryHandler.onResponse((Object)new AggregationDataExtractorFactory(client, datafeed, job));
                } else {
                    ScrollDataExtractorFactory.create(client, datafeed, job, (ActionListener<DataExtractorFactory>)factoryHandler);
                }
            } else if (datafeed.hasAggregations()) {
                RollupDataExtractorFactory.create(client, datafeed, job, response.getJobs(), (ActionListener<DataExtractorFactory>)factoryHandler);
            } else {
                listener.onFailure((Exception)new IllegalArgumentException("Aggregations are required when using Rollup indices"));
            }
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                listener.onFailure((Exception)new ResourceNotFoundException("datafeed [" + datafeed.getId() + "] cannot retrieve data because index " + ((IndexNotFoundException)e).getIndex() + " does not exist", new Object[0]));
            } else {
                listener.onFailure(e);
            }
        });
        GetRollupIndexCapsAction.Request request = new GetRollupIndexCapsAction.Request(datafeed.getIndices().toArray(new String[0]));
        ClientHelper.executeAsyncWithOrigin((Client)client, (String)"ml", (Action)GetRollupIndexCapsAction.INSTANCE, (ActionRequest)request, (ActionListener)getRollupIndexCapsActionHandler);
    }
}

