/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingAction;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.Index;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.action.PutJobAction;
import org.elasticsearch.xpack.core.ml.action.UpdateJobAction;
import org.elasticsearch.xpack.core.ml.job.config.DetectionRule;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskState;
import org.elasticsearch.xpack.core.ml.job.config.JobUpdate;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;

public class TransportOpenJobAction
extends TransportMasterNodeAction<OpenJobAction.Request, AcknowledgedResponse> {
    private final XPackLicenseState licenseState;
    private final PersistentTasksService persistentTasksService;
    private final Client client;
    private final JobResultsProvider jobResultsProvider;
    private static final PersistentTasksCustomMetaData.Assignment AWAITING_LAZY_ASSIGNMENT = new PersistentTasksCustomMetaData.Assignment(null, "persistent task is awaiting node assignment.");

    @Inject
    public TransportOpenJobAction(TransportService transportService, ThreadPool threadPool, XPackLicenseState licenseState, ClusterService clusterService, PersistentTasksService persistentTasksService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, JobResultsProvider jobResultsProvider) {
        super("cluster:admin/xpack/ml/job/open", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, OpenJobAction.Request::new);
        this.licenseState = licenseState;
        this.persistentTasksService = persistentTasksService;
        this.client = client;
        this.jobResultsProvider = jobResultsProvider;
    }

    static void validate(String jobId, MlMetadata mlMetadata) {
        Job job;
        Job job2 = job = mlMetadata == null ? null : (Job)mlMetadata.getJobs().get(jobId);
        if (job == null) {
            throw ExceptionsHelper.missingJobException((String)jobId);
        }
        if (job.isDeleting()) {
            throw ExceptionsHelper.conflictStatusException((String)("Cannot open job [" + jobId + "] because it is being deleted"), (Object[])new Object[0]);
        }
        if (job.getJobVersion() == null) {
            throw ExceptionsHelper.badRequestException((String)("Cannot open job [" + jobId + "] because jobs created prior to version 5.5 are not supported"), (Object[])new Object[0]);
        }
    }

    static PersistentTasksCustomMetaData.Assignment selectLeastLoadedMlNode(String jobId, ClusterState clusterState, int maxConcurrentJobAllocations, int fallbackMaxNumberOfOpenJobs, int maxMachineMemoryPercent, Logger logger) {
        DiscoveryNode minLoadedNode;
        List<String> unavailableIndices = TransportOpenJobAction.verifyIndicesPrimaryShardsAreActive(jobId, clusterState);
        if (unavailableIndices.size() != 0) {
            String reason = "Not opening job [" + jobId + "], because not all primary shards are active for the following indices [" + String.join((CharSequence)",", unavailableIndices) + "]";
            logger.debug(reason);
            return new PersistentTasksCustomMetaData.Assignment(null, reason);
        }
        LinkedList<String> reasons = new LinkedList<String>();
        long maxAvailableCount = Long.MIN_VALUE;
        long maxAvailableMemory = Long.MIN_VALUE;
        DiscoveryNode minLoadedNodeByCount = null;
        DiscoveryNode minLoadedNodeByMemory = null;
        boolean allocateByMemory = true;
        PersistentTasksCustomMetaData persistentTasks = (PersistentTasksCustomMetaData)clusterState.getMetaData().custom("persistent_tasks");
        for (DiscoveryNode node : clusterState.getNodes()) {
            long availableCount;
            Map nodeAttributes = node.getAttributes();
            String enabled = (String)nodeAttributes.get("ml.enabled");
            if (!Boolean.valueOf(enabled).booleanValue()) {
                String reason = "Not opening job [" + jobId + "] on node [" + TransportOpenJobAction.nodeNameOrId(node) + "], because this node isn't a ml node.";
                logger.trace(reason);
                reasons.add(reason);
                continue;
            }
            MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)clusterState);
            Job job = (Job)mlMetadata.getJobs().get(jobId);
            Set compatibleJobTypes = Job.getCompatibleJobTypes((Version)node.getVersion());
            if (!compatibleJobTypes.contains(job.getJobType())) {
                String reason = "Not opening job [" + jobId + "] on node [" + TransportOpenJobAction.nodeNameAndVersion(node) + "], because this node does not support jobs of type [" + job.getJobType() + "]";
                logger.trace(reason);
                reasons.add(reason);
                continue;
            }
            if (!TransportOpenJobAction.nodeSupportsModelSnapshotVersion(node, job)) {
                String reason = "Not opening job [" + jobId + "] on node [" + TransportOpenJobAction.nodeNameAndVersion(node) + "], because the job's model snapshot requires a node of version [" + job.getModelSnapshotMinVersion() + "] or higher";
                logger.trace(reason);
                reasons.add(reason);
                continue;
            }
            if (TransportOpenJobAction.jobHasRules(job) && node.getVersion().before(DetectionRule.VERSION_INTRODUCED)) {
                String reason = "Not opening job [" + jobId + "] on node [" + TransportOpenJobAction.nodeNameAndVersion(node) + "], because jobs using custom_rules require a node of version [" + DetectionRule.VERSION_INTRODUCED + "] or higher";
                logger.trace(reason);
                reasons.add(reason);
                continue;
            }
            long numberOfAssignedJobs = 0L;
            int numberOfAllocatingJobs = 0;
            long assignedJobMemory = 0L;
            if (persistentTasks != null) {
                Collection assignedTasks = persistentTasks.findTasks("xpack/ml/job", task -> node.getId().equals(task.getExecutorNode()));
                for (PersistentTasksCustomMetaData.PersistentTask assignedTask : assignedTasks) {
                    JobState jobState;
                    JobTaskState jobTaskState = (JobTaskState)assignedTask.getState();
                    if (jobTaskState == null) {
                        ++numberOfAllocatingJobs;
                        jobState = JobState.OPENING;
                    } else {
                        jobState = jobTaskState.getState();
                        if (jobTaskState.isStatusStale(assignedTask)) {
                            if (jobState == JobState.CLOSING) {
                                jobState = JobState.CLOSED;
                            } else if (jobState != JobState.FAILED) {
                                ++numberOfAllocatingJobs;
                                jobState = JobState.OPENING;
                            }
                        }
                    }
                    if (jobState.isAnyOf(new JobState[]{JobState.CLOSED, JobState.FAILED})) continue;
                    ++numberOfAssignedJobs;
                    String assignedJobId = ((OpenJobAction.JobParams)assignedTask.getParams()).getJobId();
                    Job assignedJob = (Job)mlMetadata.getJobs().get(assignedJobId);
                    assert (assignedJob != null);
                    assignedJobMemory += assignedJob.estimateMemoryFootprint();
                }
            }
            if (numberOfAllocatingJobs >= maxConcurrentJobAllocations) {
                String reason = "Not opening job [" + jobId + "] on node [" + TransportOpenJobAction.nodeNameAndMlAttributes(node) + "], because node exceeds [" + numberOfAllocatingJobs + "] the maximum number of jobs [" + maxConcurrentJobAllocations + "] in opening state";
                logger.trace(reason);
                reasons.add(reason);
                continue;
            }
            String maxNumberOfOpenJobsStr = (String)nodeAttributes.get("ml.max_open_jobs");
            int maxNumberOfOpenJobs = fallbackMaxNumberOfOpenJobs;
            if (maxNumberOfOpenJobsStr != null) {
                try {
                    maxNumberOfOpenJobs = Integer.parseInt(maxNumberOfOpenJobsStr);
                }
                catch (NumberFormatException e) {
                    String reason = "Not opening job [" + jobId + "] on node [" + TransportOpenJobAction.nodeNameAndMlAttributes(node) + "], because " + "ml.max_open_jobs" + " attribute [" + maxNumberOfOpenJobsStr + "] is not an integer";
                    logger.trace(reason);
                    reasons.add(reason);
                    continue;
                }
            }
            if ((availableCount = (long)maxNumberOfOpenJobs - numberOfAssignedJobs) == 0L) {
                String reason = "Not opening job [" + jobId + "] on node [" + TransportOpenJobAction.nodeNameAndMlAttributes(node) + "], because this node is full. Number of opened jobs [" + numberOfAssignedJobs + "], " + AutodetectProcessManager.MAX_OPEN_JOBS_PER_NODE.getKey() + " [" + maxNumberOfOpenJobs + "]";
                logger.trace(reason);
                reasons.add(reason);
                continue;
            }
            if (maxAvailableCount < availableCount) {
                maxAvailableCount = availableCount;
                minLoadedNodeByCount = node;
            }
            String machineMemoryStr = (String)nodeAttributes.get("ml.machine_memory");
            long machineMemory = -1L;
            if (machineMemoryStr != null) {
                try {
                    machineMemory = Long.parseLong(machineMemoryStr);
                }
                catch (NumberFormatException e) {
                    String reason = "Not opening job [" + jobId + "] on node [" + TransportOpenJobAction.nodeNameAndMlAttributes(node) + "], because " + "ml.machine_memory" + " attribute [" + machineMemoryStr + "] is not a long";
                    logger.trace(reason);
                    reasons.add(reason);
                    continue;
                }
            }
            if (!allocateByMemory) continue;
            if (machineMemory > 0L) {
                long availableMemory;
                long maxMlMemory = machineMemory * (long)maxMachineMemoryPercent / 100L;
                long estimatedMemoryFootprint = job.estimateMemoryFootprint();
                if (estimatedMemoryFootprint > (availableMemory = maxMlMemory - assignedJobMemory)) {
                    String reason = "Not opening job [" + jobId + "] on node [" + TransportOpenJobAction.nodeNameAndMlAttributes(node) + "], because this node has insufficient available memory. Available memory for ML [" + maxMlMemory + "], memory required by existing jobs [" + assignedJobMemory + "], estimated memory required for this job [" + estimatedMemoryFootprint + "]";
                    logger.trace(reason);
                    reasons.add(reason);
                    continue;
                }
                if (maxAvailableMemory >= availableMemory) continue;
                maxAvailableMemory = availableMemory;
                minLoadedNodeByMemory = node;
                continue;
            }
            allocateByMemory = false;
            logger.debug("Falling back to allocating job [{}] by job counts because machine memory was not available for node [{}]", (Object)jobId, (Object)TransportOpenJobAction.nodeNameAndMlAttributes(node));
        }
        DiscoveryNode discoveryNode = minLoadedNode = allocateByMemory ? minLoadedNodeByMemory : minLoadedNodeByCount;
        if (minLoadedNode != null) {
            logger.debug("selected node [{}] for job [{}]", minLoadedNode, (Object)jobId);
            return new PersistentTasksCustomMetaData.Assignment(minLoadedNode.getId(), "");
        }
        String explanation = String.join((CharSequence)"|", reasons);
        logger.debug("no node selected for job [{}], reasons [{}]", (Object)jobId, (Object)explanation);
        return new PersistentTasksCustomMetaData.Assignment(null, explanation);
    }

    static String nodeNameOrId(DiscoveryNode node) {
        String nodeNameOrID = node.getName();
        if (Strings.isNullOrEmpty((String)nodeNameOrID)) {
            nodeNameOrID = node.getId();
        }
        return nodeNameOrID;
    }

    static String nodeNameAndVersion(DiscoveryNode node) {
        String nodeNameOrID = TransportOpenJobAction.nodeNameOrId(node);
        StringBuilder builder = new StringBuilder("{").append(nodeNameOrID).append('}');
        builder.append('{').append("version=").append(node.getVersion()).append('}');
        return builder.toString();
    }

    static String nodeNameAndMlAttributes(DiscoveryNode node) {
        String nodeNameOrID = TransportOpenJobAction.nodeNameOrId(node);
        StringBuilder builder = new StringBuilder("{").append(nodeNameOrID).append('}');
        for (Map.Entry entry : node.getAttributes().entrySet()) {
            if (!((String)entry.getKey()).startsWith("ml.") && !((String)entry.getKey()).equals("node.ml")) continue;
            builder.append('{').append(entry).append('}');
        }
        return builder.toString();
    }

    static String[] indicesOfInterest(ClusterState clusterState, String job) {
        String jobResultIndex = AnomalyDetectorsIndex.getPhysicalIndexFromState((ClusterState)clusterState, (String)job);
        return new String[]{AnomalyDetectorsIndex.jobStateIndexName(), jobResultIndex, ".ml-meta"};
    }

    static List<String> verifyIndicesPrimaryShardsAreActive(String jobId, ClusterState clusterState) {
        String[] indices = TransportOpenJobAction.indicesOfInterest(clusterState, jobId);
        ArrayList<String> unavailableIndices = new ArrayList<String>(indices.length);
        for (String index : indices) {
            IndexRoutingTable routingTable;
            if (!clusterState.metaData().hasIndex(index) || (routingTable = clusterState.getRoutingTable().index(index)) != null && routingTable.allPrimaryShardsActive()) continue;
            unavailableIndices.add(index);
        }
        return unavailableIndices;
    }

    private static boolean nodeSupportsModelSnapshotVersion(DiscoveryNode node, Job job) {
        if (job.getModelSnapshotId() == null || job.getModelSnapshotMinVersion() == null) {
            return true;
        }
        return node.getVersion().onOrAfter(job.getModelSnapshotMinVersion());
    }

    private static boolean jobHasRules(Job job) {
        return job.getAnalysisConfig().getDetectors().stream().anyMatch(d -> !d.getRules().isEmpty());
    }

    static String[] mappingRequiresUpdate(ClusterState state, String[] concreteIndices, Version minVersion, Logger logger) throws IOException {
        ArrayList<String> indicesToUpdate = new ArrayList<String>();
        ImmutableOpenMap currentMapping = state.metaData().findMappings(concreteIndices, new String[]{"doc"}, MapperPlugin.NOOP_FIELD_FILTER);
        for (String index : concreteIndices) {
            ImmutableOpenMap innerMap = (ImmutableOpenMap)currentMapping.get((Object)index);
            if (innerMap != null) {
                MappingMetaData metaData = (MappingMetaData)innerMap.get((Object)"doc");
                try {
                    Map meta = (Map)metaData.sourceAsMap().get("_meta");
                    if (meta != null) {
                        String versionString = (String)meta.get("version");
                        if (versionString == null) {
                            logger.info("Version of mappings for [{}] not found, recreating", (Object)index);
                            indicesToUpdate.add(index);
                            continue;
                        }
                        Version mappingVersion = Version.fromString((String)versionString);
                        if (mappingVersion.onOrAfter(minVersion)) continue;
                        logger.info("Mappings for [{}] are outdated [{}], updating it[{}].", (Object)index, (Object)mappingVersion, (Object)Version.CURRENT);
                        indicesToUpdate.add(index);
                        continue;
                    }
                    logger.info("Version of mappings for [{}] not found, recreating", (Object)index);
                    indicesToUpdate.add(index);
                }
                catch (Exception e) {
                    logger.error((Message)new ParameterizedMessage("Failed to retrieve mapping version for [{}], recreating", (Object)index), (Throwable)e);
                    indicesToUpdate.add(index);
                }
                continue;
            }
            logger.info("No mappings found for [{}], recreating", (Object)index);
            indicesToUpdate.add(index);
        }
        return indicesToUpdate.toArray(new String[indicesToUpdate.size()]);
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    protected ClusterBlockException checkBlock(OpenJobAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(OpenJobAction.Request request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        final OpenJobAction.JobParams jobParams = request.getJobParams();
        if (this.licenseState.isMachineLearningAllowed()) {
            final ActionListener clearJobFinishTime = ActionListener.wrap(response -> {
                if (response.isAcknowledged()) {
                    this.clearJobFinishedTime(jobParams.getJobId(), listener);
                } else {
                    listener.onResponse(response);
                }
            }, arg_0 -> listener.onFailure(arg_0));
            ActionListener<PersistentTasksCustomMetaData.PersistentTask<OpenJobAction.JobParams>> waitForJobToStart = new ActionListener<PersistentTasksCustomMetaData.PersistentTask<OpenJobAction.JobParams>>(){

                public void onResponse(PersistentTasksCustomMetaData.PersistentTask<OpenJobAction.JobParams> task) {
                    TransportOpenJobAction.this.waitForJobStarted(task.getId(), jobParams, (ActionListener<AcknowledgedResponse>)clearJobFinishTime);
                }

                public void onFailure(Exception e) {
                    if (e instanceof ResourceAlreadyExistsException) {
                        e = new ElasticsearchStatusException("Cannot open job [" + jobParams.getJobId() + "] because it has already been opened", RestStatus.CONFLICT, (Throwable)e, new Object[0]);
                    }
                    listener.onFailure(e);
                }
            };
            ActionListener establishedMemoryUpdateListener = ActionListener.wrap(arg_0 -> this.lambda$masterOperation$3(jobParams, (ActionListener)waitForJobToStart, arg_0), arg_0 -> listener.onFailure(arg_0));
            ActionListener missingMappingsListener = ActionListener.wrap(response -> {
                block4: {
                    Job job;
                    block5: {
                        job = (Job)MlMetadata.getMlMetadata((ClusterState)this.clusterService.state()).getJobs().get(jobParams.getJobId());
                        if (job == null) {
                            establishedMemoryUpdateListener.onResponse(null);
                            return;
                        }
                        Version jobVersion = job.getJobVersion();
                        Long jobEstablishedModelMemory = job.getEstablishedModelMemory();
                        if (jobVersion != null && !jobVersion.before(Version.V_6_1_0)) break block4;
                        if (jobEstablishedModelMemory == null) break block5;
                        if (jobEstablishedModelMemory != 0L) break block4;
                    }
                    this.jobResultsProvider.getEstablishedMemoryUsage(job.getId(), null, null, establishedModelMemory -> {
                        if (establishedModelMemory != null && establishedModelMemory > 0L) {
                            JobUpdate update = new JobUpdate.Builder(job.getId()).setEstablishedModelMemory(establishedModelMemory).build();
                            UpdateJobAction.Request updateRequest = UpdateJobAction.Request.internal((String)job.getId(), (JobUpdate)update);
                            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)UpdateJobAction.INSTANCE, (ActionRequest)updateRequest, (ActionListener)establishedMemoryUpdateListener);
                        } else {
                            establishedMemoryUpdateListener.onResponse(null);
                        }
                    }, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
                    return;
                }
                establishedMemoryUpdateListener.onResponse(null);
            }, arg_0 -> listener.onFailure(arg_0));
            ActionListener resultsPutMappingHandler = ActionListener.wrap(response -> this.addDocMappingIfMissing(AnomalyDetectorsIndex.jobStateIndexName(), (CheckedSupplier<XContentBuilder, IOException>)((CheckedSupplier)ElasticsearchMappings::stateMapping), state, (ActionListener<Boolean>)missingMappingsListener), arg_0 -> listener.onFailure(arg_0));
            this.addDocMappingIfMissing(AnomalyDetectorsIndex.jobResultsAliasedName((String)jobParams.getJobId()), (CheckedSupplier<XContentBuilder, IOException>)((CheckedSupplier)ElasticsearchMappings::docMapping), state, (ActionListener<Boolean>)resultsPutMappingHandler);
        } else {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
        }
    }

    private void waitForJobStarted(String taskId, final OpenJobAction.JobParams jobParams, final ActionListener<AcknowledgedResponse> listener) {
        final JobPredicate predicate = new JobPredicate();
        this.persistentTasksService.waitForPersistentTaskCondition(taskId, (Predicate)predicate, jobParams.getTimeout(), (PersistentTasksService.WaitForPersistentTaskListener)new PersistentTasksService.WaitForPersistentTaskListener<OpenJobAction.JobParams>(){

            public void onResponse(PersistentTasksCustomMetaData.PersistentTask<OpenJobAction.JobParams> persistentTask) {
                if (predicate.exception != null) {
                    if (predicate.shouldCancel) {
                        TransportOpenJobAction.this.cancelJobStart((PersistentTasksCustomMetaData.PersistentTask<OpenJobAction.JobParams>)persistentTask, predicate.exception, (ActionListener<AcknowledgedResponse>)listener);
                    } else {
                        listener.onFailure(predicate.exception);
                    }
                } else {
                    listener.onResponse((Object)new AcknowledgedResponse(predicate.opened));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public void onTimeout(TimeValue timeout) {
                listener.onFailure((Exception)new ElasticsearchException("Opening job [" + jobParams.getJobId() + "] timed out after [" + timeout + "]", new Object[0]));
            }
        });
    }

    private void clearJobFinishedTime(final String jobId, final ActionListener<AcknowledgedResponse> listener) {
        this.clusterService.submitStateUpdateTask("clearing-job-finish-time-for-" + jobId, (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) {
                MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)currentState);
                MlMetadata.Builder mlMetadataBuilder = new MlMetadata.Builder(mlMetadata);
                Job.Builder jobBuilder = new Job.Builder((Job)mlMetadata.getJobs().get(jobId));
                jobBuilder.setFinishedTime(null);
                mlMetadataBuilder.putJob(jobBuilder.build(), true);
                ClusterState.Builder builder = ClusterState.builder((ClusterState)currentState);
                return builder.metaData(new MetaData.Builder(currentState.metaData()).putCustom("ml", (MetaData.Custom)mlMetadataBuilder.build())).build();
            }

            public void onFailure(String source, Exception e) {
                TransportOpenJobAction.this.logger.error("[" + jobId + "] Failed to clear finished_time; source [" + source + "]", (Throwable)e);
                listener.onResponse((Object)new AcknowledgedResponse(true));
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse((Object)new AcknowledgedResponse(true));
            }
        });
    }

    private void cancelJobStart(final PersistentTasksCustomMetaData.PersistentTask<OpenJobAction.JobParams> persistentTask, final Exception exception, final ActionListener<AcknowledgedResponse> listener) {
        this.persistentTasksService.sendRemoveRequest(persistentTask.getId(), new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

            public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> task) {
                listener.onFailure(exception);
            }

            public void onFailure(Exception e) {
                TransportOpenJobAction.this.logger.error("[" + ((OpenJobAction.JobParams)persistentTask.getParams()).getJobId() + "] Failed to cancel persistent task that could not be assigned due to [" + exception.getMessage() + "]", (Throwable)e);
                listener.onFailure(exception);
            }
        });
    }

    private void addDocMappingIfMissing(String alias, CheckedSupplier<XContentBuilder, IOException> mappingSupplier, ClusterState state, ActionListener<Boolean> listener) {
        String[] indicesThatRequireAnUpdate;
        AliasOrIndex aliasOrIndex = (AliasOrIndex)state.metaData().getAliasAndIndexLookup().get(alias);
        if (aliasOrIndex == null) {
            listener.onResponse((Object)true);
            return;
        }
        String[] concreteIndices = (String[])aliasOrIndex.getIndices().stream().map(IndexMetaData::getIndex).map(Index::getName).toArray(String[]::new);
        try {
            indicesThatRequireAnUpdate = TransportOpenJobAction.mappingRequiresUpdate(state, concreteIndices, Version.CURRENT, this.logger);
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
            return;
        }
        if (indicesThatRequireAnUpdate.length > 0) {
            try (XContentBuilder mapping = (XContentBuilder)mappingSupplier.get();){
                PutMappingRequest putMappingRequest = new PutMappingRequest(indicesThatRequireAnUpdate);
                putMappingRequest.type("doc");
                putMappingRequest.source(mapping);
                ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)PutMappingAction.INSTANCE, (ActionRequest)putMappingRequest, (ActionListener)ActionListener.wrap(response -> {
                    if (response.isAcknowledged()) {
                        listener.onResponse((Object)true);
                    } else {
                        listener.onFailure((Exception)new ElasticsearchException("Attempt to put missing mapping in indices " + Arrays.toString(indicesThatRequireAnUpdate) + " was not acknowledged", new Object[0]));
                    }
                }, arg_0 -> listener.onFailure(arg_0)));
            }
            catch (IOException e) {
                listener.onFailure((Exception)e);
            }
        } else {
            this.logger.trace("Mappings are uptodate.");
            listener.onResponse((Object)true);
        }
    }

    static ElasticsearchException makeNoSuitableNodesException(Logger logger, String jobId, String explanation) {
        String msg = "Could not open job because no suitable nodes were found, allocation explanation [" + explanation + "]";
        logger.warn("[{}] {}", (Object)jobId, (Object)msg);
        IllegalStateException detail = new IllegalStateException(msg);
        return new ElasticsearchStatusException("Could not open job because no ML nodes with sufficient capacity were found", RestStatus.TOO_MANY_REQUESTS, (Throwable)detail, new Object[0]);
    }

    private /* synthetic */ void lambda$masterOperation$3(OpenJobAction.JobParams jobParams, ActionListener waitForJobToStart, PutJobAction.Response response) throws Exception {
        this.persistentTasksService.sendStartRequest(MlTasks.jobTaskId((String)jobParams.getJobId()), "xpack/ml/job", (PersistentTaskParams)jobParams, waitForJobToStart);
    }

    private class JobPredicate
    implements Predicate<PersistentTasksCustomMetaData.PersistentTask<?>> {
        private volatile boolean opened;
        private volatile Exception exception;
        private volatile boolean shouldCancel;

        private JobPredicate() {
        }

        @Override
        public boolean test(PersistentTasksCustomMetaData.PersistentTask<?> persistentTask) {
            JobState jobState = JobState.CLOSED;
            if (persistentTask != null) {
                JobTaskState jobTaskState = (JobTaskState)persistentTask.getState();
                jobState = jobTaskState == null ? JobState.OPENING : jobTaskState.getState();
                PersistentTasksCustomMetaData.Assignment assignment = persistentTask.getAssignment();
                if (assignment != null && assignment.equals((Object)AWAITING_LAZY_ASSIGNMENT)) {
                    return true;
                }
                if (assignment != null && !assignment.equals((Object)PersistentTasksCustomMetaData.INITIAL_ASSIGNMENT) && !assignment.isAssigned()) {
                    OpenJobAction.JobParams params = (OpenJobAction.JobParams)persistentTask.getParams();
                    this.exception = TransportOpenJobAction.makeNoSuitableNodesException(TransportOpenJobAction.this.logger, params.getJobId(), assignment.getExplanation());
                    this.shouldCancel = true;
                    return true;
                }
            }
            switch (jobState) {
                case OPENING: 
                case CLOSED: {
                    return false;
                }
                case OPENED: {
                    this.opened = true;
                    return true;
                }
                case CLOSING: {
                    this.exception = ExceptionsHelper.conflictStatusException((String)("The job has been " + JobState.CLOSED + " while waiting to be " + JobState.OPENED), (Object[])new Object[0]);
                    return true;
                }
            }
            this.exception = ExceptionsHelper.serverError((String)("Unexpected job state [" + jobState + "] while waiting for job to be " + JobState.OPENED));
            return true;
        }
    }

    public static class JobTask
    extends AllocatedPersistentTask
    implements OpenJobAction.JobTaskMatcher {
        private static final Logger LOGGER = LogManager.getLogger(JobTask.class);
        private final String jobId;
        private volatile AutodetectProcessManager autodetectProcessManager;

        JobTask(String jobId, long id, String type, String action, TaskId parentTask, Map<String, String> headers) {
            super(id, type, action, "job-" + jobId, parentTask, headers);
            this.jobId = jobId;
        }

        public String getJobId() {
            return this.jobId;
        }

        protected void onCancelled() {
            String reason = this.getReasonCancelled();
            LOGGER.trace("[{}] Cancelling job task because: {}", (Object)this.jobId, (Object)reason);
            this.killJob(reason);
        }

        void killJob(String reason) {
            this.autodetectProcessManager.killProcess(this, false, reason);
        }

        void closeJob(String reason) {
            this.autodetectProcessManager.closeJob(this, false, reason);
        }
    }

    public static class OpenJobPersistentTasksExecutor
    extends PersistentTasksExecutor<OpenJobAction.JobParams> {
        private static final Logger logger = LogManager.getLogger(OpenJobPersistentTasksExecutor.class);
        private final AutodetectProcessManager autodetectProcessManager;
        private final int fallbackMaxNumberOfOpenJobs;
        private volatile int maxConcurrentJobAllocations;
        private volatile int maxMachineMemoryPercent;
        private volatile int maxLazyMLNodes;

        public OpenJobPersistentTasksExecutor(Settings settings, ClusterService clusterService, AutodetectProcessManager autodetectProcessManager) {
            super("xpack/ml/job", "ml_utility");
            this.autodetectProcessManager = autodetectProcessManager;
            this.fallbackMaxNumberOfOpenJobs = (Integer)AutodetectProcessManager.MAX_OPEN_JOBS_PER_NODE.get(settings);
            this.maxConcurrentJobAllocations = (Integer)MachineLearning.CONCURRENT_JOB_ALLOCATIONS.get(settings);
            this.maxMachineMemoryPercent = (Integer)MachineLearning.MAX_MACHINE_MEMORY_PERCENT.get(settings);
            this.maxLazyMLNodes = (Integer)MachineLearning.MAX_LAZY_ML_NODES.get(settings);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.CONCURRENT_JOB_ALLOCATIONS, this::setMaxConcurrentJobAllocations);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_MACHINE_MEMORY_PERCENT, this::setMaxMachineMemoryPercent);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_LAZY_ML_NODES, this::setMaxLazyMLNodes);
        }

        public PersistentTasksCustomMetaData.Assignment getAssignment(OpenJobAction.JobParams params, ClusterState clusterState) {
            PersistentTasksCustomMetaData.Assignment assignment = TransportOpenJobAction.selectLeastLoadedMlNode(params.getJobId(), clusterState, this.maxConcurrentJobAllocations, this.fallbackMaxNumberOfOpenJobs, this.maxMachineMemoryPercent, logger);
            if (assignment.getExecutorNode() == null) {
                int numMlNodes = 0;
                for (DiscoveryNode node : clusterState.getNodes()) {
                    if (!Boolean.valueOf((String)node.getAttributes().get("ml.enabled")).booleanValue()) continue;
                    ++numMlNodes;
                }
                if (numMlNodes < this.maxLazyMLNodes) {
                    assignment = AWAITING_LAZY_ASSIGNMENT;
                }
            }
            return assignment;
        }

        public void validate(OpenJobAction.JobParams params, ClusterState clusterState) {
            TransportOpenJobAction.validate(params.getJobId(), MlMetadata.getMlMetadata((ClusterState)clusterState));
            PersistentTasksCustomMetaData.Assignment assignment = this.getAssignment(params, clusterState);
            if (assignment.getExecutorNode() == null && !assignment.equals((Object)AWAITING_LAZY_ASSIGNMENT)) {
                throw TransportOpenJobAction.makeNoSuitableNodesException(logger, params.getJobId(), assignment.getExplanation());
            }
        }

        protected void nodeOperation(AllocatedPersistentTask task, OpenJobAction.JobParams params, PersistentTaskState state) {
            JobTask jobTask = (JobTask)task;
            jobTask.autodetectProcessManager = this.autodetectProcessManager;
            JobTaskState jobTaskState = (JobTaskState)state;
            if (jobTaskState != null && jobTaskState.getState().isAnyOf(new JobState[]{JobState.FAILED, JobState.CLOSING})) {
                return;
            }
            this.autodetectProcessManager.openJob(jobTask, e2 -> {
                if (e2 == null) {
                    task.markAsCompleted();
                } else {
                    task.markAsFailed(e2);
                }
            });
        }

        protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetaData.PersistentTask<OpenJobAction.JobParams> persistentTask, Map<String, String> headers) {
            return new JobTask(((OpenJobAction.JobParams)persistentTask.getParams()).getJobId(), id, type, action, parentTaskId, headers);
        }

        void setMaxConcurrentJobAllocations(int maxConcurrentJobAllocations) {
            logger.info("Changing [{}] from [{}] to [{}]", (Object)MachineLearning.CONCURRENT_JOB_ALLOCATIONS.getKey(), (Object)this.maxConcurrentJobAllocations, (Object)maxConcurrentJobAllocations);
            this.maxConcurrentJobAllocations = maxConcurrentJobAllocations;
        }

        void setMaxMachineMemoryPercent(int maxMachineMemoryPercent) {
            logger.info("Changing [{}] from [{}] to [{}]", (Object)MachineLearning.MAX_MACHINE_MEMORY_PERCENT.getKey(), (Object)this.maxMachineMemoryPercent, (Object)maxMachineMemoryPercent);
            this.maxMachineMemoryPercent = maxMachineMemoryPercent;
        }

        void setMaxLazyMLNodes(int maxLazyMLNodes) {
            logger.info("Changing [{}] from [{}] to [{}]", (Object)MachineLearning.MAX_LAZY_ML_NODES.getKey(), (Object)this.maxLazyMLNodes, (Object)maxLazyMLNodes);
            this.maxLazyMLNodes = maxLazyMLNodes;
        }
    }
}

