/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.get.GetAction;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.GetFiltersAction;
import org.elasticsearch.xpack.core.ml.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;
import org.elasticsearch.xpack.ml.utils.MlIndicesUtils;

public class TransportGetFiltersAction
extends HandledTransportAction<GetFiltersAction.Request, GetFiltersAction.Response> {
    private final Client client;

    @Inject
    public TransportGetFiltersAction(TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/xpack/ml/filters/get", transportService, actionFilters, GetFiltersAction.Request::new);
        this.client = client;
    }

    protected void doExecute(Task task, GetFiltersAction.Request request, ActionListener<GetFiltersAction.Response> listener) {
        String filterId = request.getFilterId();
        if (!Strings.isNullOrEmpty((String)filterId)) {
            this.getFilter(filterId, listener);
        } else {
            PageParams pageParams = request.getPageParams();
            if (pageParams == null) {
                pageParams = PageParams.defaultParams();
            }
            this.getFilters(pageParams, listener);
        }
    }

    private void getFilter(String filterId, final ActionListener<GetFiltersAction.Response> listener) {
        GetRequest getRequest = new GetRequest(".ml-meta", "doc", MlFilter.documentId((String)filterId));
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)GetAction.INSTANCE, (ActionRequest)getRequest, (ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse getDocResponse) {
                block15: {
                    try {
                        if (getDocResponse.isExists()) {
                            BytesReference docSource = getDocResponse.getSourceAsBytesRef();
                            try (StreamInput stream = docSource.streamInput();
                                 XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                                MlFilter filter = ((MlFilter.Builder)MlFilter.LENIENT_PARSER.apply(parser, null)).build();
                                QueryPage responseBody = new QueryPage(Collections.singletonList(filter), 1L, MlFilter.RESULTS_FIELD);
                                GetFiltersAction.Response filterResponse = new GetFiltersAction.Response(responseBody);
                                listener.onResponse((Object)filterResponse);
                                break block15;
                            }
                        }
                        this.onFailure((Exception)QueryPage.emptyQueryPage((ParseField)MlFilter.RESULTS_FIELD));
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private void getFilters(PageParams pageParams, final ActionListener<GetFiltersAction.Response> listener) {
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().from(pageParams.getFrom()).size(pageParams.getSize()).query((QueryBuilder)QueryBuilders.termQuery((String)MlFilter.TYPE.getPreferredName(), (String)"filter"));
        SearchRequest searchRequest = new SearchRequest(new String[]{".ml-meta"}).indicesOptions(MlIndicesUtils.addIgnoreUnavailable(SearchRequest.DEFAULT_INDICES_OPTIONS)).source(sourceBuilder);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse response) {
                ArrayList<MlFilter> docs = new ArrayList<MlFilter>();
                for (SearchHit hit : response.getHits().getHits()) {
                    BytesReference docSource = hit.getSourceRef();
                    try (StreamInput stream = docSource.streamInput();
                         XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                        docs.add(((MlFilter.Builder)MlFilter.LENIENT_PARSER.apply(parser, null)).build());
                    }
                    catch (IOException e) {
                        this.onFailure(e);
                    }
                }
                GetFiltersAction.Response filterResponse = new GetFiltersAction.Response(new QueryPage(docs, (long)docs.size(), MlFilter.RESULTS_FIELD));
                listener.onResponse((Object)filterResponse);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        }, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }
}

