/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsStatsAction;
import org.elasticsearch.xpack.core.ml.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;

public class TransportGetDatafeedsStatsAction
extends TransportMasterNodeReadAction<GetDatafeedsStatsAction.Request, GetDatafeedsStatsAction.Response> {
    @Inject
    public TransportGetDatafeedsStatsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:monitor/xpack/ml/datafeeds/stats/get", transportService, clusterService, threadPool, actionFilters, GetDatafeedsStatsAction.Request::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "same";
    }

    protected GetDatafeedsStatsAction.Response newResponse() {
        return new GetDatafeedsStatsAction.Response();
    }

    protected void masterOperation(GetDatafeedsStatsAction.Request request, ClusterState state, ActionListener<GetDatafeedsStatsAction.Response> listener) throws Exception {
        this.logger.debug("Get stats for datafeed '{}'", (Object)request.getDatafeedId());
        MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)state);
        Set expandedDatafeedIds = mlMetadata.expandDatafeedIds(request.getDatafeedId(), request.allowNoDatafeeds());
        PersistentTasksCustomMetaData tasksInProgress = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
        List results = expandedDatafeedIds.stream().map(datafeedId -> TransportGetDatafeedsStatsAction.getDatafeedStats(datafeedId, state, tasksInProgress)).collect(Collectors.toList());
        QueryPage statsPage = new QueryPage(results, (long)results.size(), DatafeedConfig.RESULTS_FIELD);
        listener.onResponse((Object)new GetDatafeedsStatsAction.Response(statsPage));
    }

    private static GetDatafeedsStatsAction.Response.DatafeedStats getDatafeedStats(String datafeedId, ClusterState state, PersistentTasksCustomMetaData tasks) {
        PersistentTasksCustomMetaData.PersistentTask task = MlTasks.getDatafeedTask((String)datafeedId, (PersistentTasksCustomMetaData)tasks);
        DatafeedState datafeedState = MlTasks.getDatafeedState((String)datafeedId, (PersistentTasksCustomMetaData)tasks);
        DiscoveryNode node = null;
        String explanation = null;
        if (task != null) {
            node = state.nodes().get(task.getExecutorNode());
            explanation = task.getAssignment().getExplanation();
        }
        return new GetDatafeedsStatsAction.Response.DatafeedStats(datafeedId, datafeedState, node, explanation);
    }

    protected ClusterBlockException checkBlock(GetDatafeedsStatsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

