/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.DeleteCalendarAction;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;

public class TransportDeleteCalendarAction
extends HandledTransportAction<DeleteCalendarAction.Request, AcknowledgedResponse> {
    private final Client client;
    private final JobManager jobManager;
    private final JobResultsProvider jobResultsProvider;

    @Inject
    public TransportDeleteCalendarAction(TransportService transportService, ActionFilters actionFilters, Client client, JobManager jobManager, JobResultsProvider jobResultsProvider) {
        super("cluster:admin/xpack/ml/calendars/delete", transportService, actionFilters, DeleteCalendarAction.Request::new);
        this.client = client;
        this.jobManager = jobManager;
        this.jobResultsProvider = jobResultsProvider;
    }

    protected void doExecute(Task task, DeleteCalendarAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        String calendarId = request.getCalendarId();
        ActionListener calendarListener = ActionListener.wrap(calendar -> {
            DeleteByQueryRequest dbqRequest = this.buildDeleteByQuery(calendarId);
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)DeleteByQueryAction.INSTANCE, (ActionRequest)dbqRequest, (ActionListener)ActionListener.wrap(response -> {
                if (response.getDeleted() == 0L) {
                    listener.onFailure((Exception)new ResourceNotFoundException("No calendar with id [" + calendarId + "]", new Object[0]));
                    return;
                }
                this.jobManager.updateProcessOnCalendarChanged(calendar.getJobIds());
                listener.onResponse((Object)new AcknowledgedResponse(true));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0));
        this.jobResultsProvider.calendar(calendarId, (ActionListener<Calendar>)calendarListener);
    }

    private DeleteByQueryRequest buildDeleteByQuery(String calendarId) {
        DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{".ml-meta"});
        request.setSlices(5);
        request.setRefresh(true);
        TermsQueryBuilder query = QueryBuilders.termsQuery((String)Calendar.ID.getPreferredName(), (String[])new String[]{calendarId});
        request.setQuery((QueryBuilder)query);
        return request;
    }
}

