/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.nio.cors;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.http.nio.NioHttpResponse;
import org.elasticsearch.http.nio.cors.NioCorsConfig;

public class NioCorsHandler
extends ChannelDuplexHandler {
    public static final String ANY_ORIGIN = "*";
    private static Pattern SCHEME_PATTERN = Pattern.compile("^https?://");
    private final NioCorsConfig config;
    private FullHttpRequest request;

    public NioCorsHandler(NioCorsConfig config) {
        if (config == null) {
            throw new NullPointerException();
        }
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        assert (msg instanceof FullHttpRequest) : "Invalid message type: " + msg.getClass();
        if (this.config.isCorsSupportEnabled()) {
            this.request = (FullHttpRequest)msg;
            if (NioCorsHandler.isPreflightRequest((HttpRequest)this.request)) {
                try {
                    this.handlePreflight(ctx, (HttpRequest)this.request);
                    return;
                }
                finally {
                    this.releaseRequest();
                }
            }
            if (this.config.isShortCircuit() && !this.validateOrigin()) {
                try {
                    NioCorsHandler.forbidden(ctx, (HttpRequest)this.request);
                    return;
                }
                finally {
                    this.releaseRequest();
                }
            }
        }
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        assert (msg instanceof NioHttpResponse) : "Invalid message type: " + msg.getClass();
        NioHttpResponse response = (NioHttpResponse)((Object)msg);
        NioCorsHandler.setCorsResponseHeaders((HttpRequest)response.getRequest().nettyRequest(), (HttpResponse)response, this.config);
        ctx.write((Object)response, promise);
    }

    public static void setCorsResponseHeaders(HttpRequest request, HttpResponse resp, NioCorsConfig config) {
        String originHeaderVal;
        if (!config.isCorsSupportEnabled()) {
            return;
        }
        String originHeader = request.headers().get((CharSequence)HttpHeaderNames.ORIGIN);
        if (!Strings.isNullOrEmpty((String)originHeader) && (originHeaderVal = config.isAnyOriginSupported() ? ANY_ORIGIN : (config.isOriginAllowed(originHeader) || NioCorsHandler.isSameOrigin(originHeader, request.headers().get((CharSequence)HttpHeaderNames.HOST)) ? originHeader : null)) != null) {
            resp.headers().add((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)originHeaderVal);
        }
        if (config.isCredentialsAllowed()) {
            resp.headers().add((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)"true");
        }
    }

    private void releaseRequest() {
        this.request.release();
        this.request = null;
    }

    private void handlePreflight(ChannelHandlerContext ctx, HttpRequest request) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.OK, true, true);
        if (this.setOrigin((HttpResponse)response)) {
            this.setAllowMethods((HttpResponse)response);
            this.setAllowHeaders((HttpResponse)response);
            this.setAllowCredentials((HttpResponse)response);
            this.setMaxAge((HttpResponse)response);
            this.setPreflightHeaders((HttpResponse)response);
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            NioCorsHandler.forbidden(ctx, request);
        }
    }

    private static void forbidden(ChannelHandlerContext ctx, HttpRequest request) {
        ctx.writeAndFlush((Object)new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.FORBIDDEN)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static boolean isSameOrigin(String origin, String host) {
        String originDomain;
        return !Strings.isNullOrEmpty((String)host) && host.equals(originDomain = SCHEME_PATTERN.matcher(origin).replaceFirst(""));
    }

    private void setPreflightHeaders(HttpResponse response) {
        response.headers().add(this.config.preflightResponseHeaders());
    }

    private boolean setOrigin(HttpResponse response) {
        String origin = this.request.headers().get((CharSequence)HttpHeaderNames.ORIGIN);
        if (!Strings.isNullOrEmpty((String)origin)) {
            if (this.config.isAnyOriginSupported()) {
                if (this.config.isCredentialsAllowed()) {
                    this.echoRequestOrigin(response);
                    NioCorsHandler.setVaryHeader(response);
                } else {
                    NioCorsHandler.setAnyOrigin(response);
                }
                return true;
            }
            if (this.config.isOriginAllowed(origin)) {
                NioCorsHandler.setOrigin(response, origin);
                NioCorsHandler.setVaryHeader(response);
                return true;
            }
        }
        return false;
    }

    private boolean validateOrigin() {
        if (this.config.isAnyOriginSupported()) {
            return true;
        }
        String origin = this.request.headers().get((CharSequence)HttpHeaderNames.ORIGIN);
        if (Strings.isNullOrEmpty((String)origin)) {
            return true;
        }
        if (NioCorsHandler.isSameOrigin(origin, this.request.headers().get((CharSequence)HttpHeaderNames.HOST))) {
            return true;
        }
        return this.config.isOriginAllowed(origin);
    }

    private void echoRequestOrigin(HttpResponse response) {
        NioCorsHandler.setOrigin(response, this.request.headers().get((CharSequence)HttpHeaderNames.ORIGIN));
    }

    private static void setVaryHeader(HttpResponse response) {
        response.headers().set((CharSequence)HttpHeaderNames.VARY, (Object)HttpHeaderNames.ORIGIN);
    }

    private static void setAnyOrigin(HttpResponse response) {
        NioCorsHandler.setOrigin(response, ANY_ORIGIN);
    }

    private static void setOrigin(HttpResponse response, String origin) {
        response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)origin);
    }

    private void setAllowCredentials(HttpResponse response) {
        if (this.config.isCredentialsAllowed() && !response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN).equals(ANY_ORIGIN)) {
            response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)"true");
        }
    }

    private static boolean isPreflightRequest(HttpRequest request) {
        HttpHeaders headers = request.headers();
        return request.method().equals((Object)HttpMethod.OPTIONS) && headers.contains((CharSequence)HttpHeaderNames.ORIGIN) && headers.contains((CharSequence)HttpHeaderNames.ACCESS_CONTROL_REQUEST_METHOD);
    }

    private void setAllowMethods(HttpResponse response) {
        response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS, (Iterable)this.config.allowedRequestMethods().stream().map(m -> m.name().trim()).collect(Collectors.toList()));
    }

    private void setAllowHeaders(HttpResponse response) {
        response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, this.config.allowedRequestHeaders());
    }

    private void setMaxAge(HttpResponse response) {
        response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_MAX_AGE, (Object)this.config.maxAge());
    }
}

