/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.nio;

import io.netty.handler.codec.http.HttpMethod;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.http.AbstractHttpServerTransport;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpServerChannel;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.http.nio.HttpReadWriteHandler;
import org.elasticsearch.http.nio.NioHttpChannel;
import org.elasticsearch.http.nio.NioHttpServerChannel;
import org.elasticsearch.http.nio.cors.NioCorsConfig;
import org.elasticsearch.http.nio.cors.NioCorsConfigBuilder;
import org.elasticsearch.nio.BytesChannelContext;
import org.elasticsearch.nio.ChannelFactory;
import org.elasticsearch.nio.EventHandler;
import org.elasticsearch.nio.InboundChannelBuffer;
import org.elasticsearch.nio.NioGroup;
import org.elasticsearch.nio.NioSelector;
import org.elasticsearch.nio.NioServerSocketChannel;
import org.elasticsearch.nio.NioSocketChannel;
import org.elasticsearch.nio.ReadWriteHandler;
import org.elasticsearch.nio.ServerChannelContext;
import org.elasticsearch.nio.SocketChannelContext;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.threadpool.ThreadPool;

public class NioHttpServerTransport
extends AbstractHttpServerTransport {
    private static final Logger logger = LogManager.getLogger(NioHttpServerTransport.class);
    public static final Setting<Integer> NIO_HTTP_ACCEPTOR_COUNT = Setting.intSetting((String)"http.nio.acceptor_count", (int)1, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Integer> NIO_HTTP_WORKER_COUNT = new Setting("http.nio.worker_count", s -> Integer.toString(EsExecutors.numberOfProcessors((Settings)s) * 2), s -> Setting.parseInt((String)s, (int)1, (String)"http.nio.worker_count"), new Setting.Property[]{Setting.Property.NodeScope});
    protected final PageCacheRecycler pageCacheRecycler;
    protected final NioCorsConfig corsConfig;
    protected final boolean tcpNoDelay;
    protected final boolean tcpKeepAlive;
    protected final boolean reuseAddress;
    protected final int tcpSendBufferSize;
    protected final int tcpReceiveBufferSize;
    private NioGroup nioGroup;
    private ChannelFactory<NioHttpServerChannel, NioHttpChannel> channelFactory;

    public NioHttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, PageCacheRecycler pageCacheRecycler, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, HttpServerTransport.Dispatcher dispatcher) {
        super(settings, networkService, bigArrays, threadPool, xContentRegistry, dispatcher);
        this.pageCacheRecycler = pageCacheRecycler;
        ByteSizeValue maxChunkSize = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_CHUNK_SIZE.get(settings);
        ByteSizeValue maxHeaderSize = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_HEADER_SIZE.get(settings);
        ByteSizeValue maxInitialLineLength = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_INITIAL_LINE_LENGTH.get(settings);
        int pipeliningMaxEvents = (Integer)HttpTransportSettings.SETTING_PIPELINING_MAX_EVENTS.get(settings);
        this.corsConfig = NioHttpServerTransport.buildCorsConfig(settings);
        this.tcpNoDelay = (Boolean)HttpTransportSettings.SETTING_HTTP_TCP_NO_DELAY.get(settings);
        this.tcpKeepAlive = (Boolean)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_ALIVE.get(settings);
        this.reuseAddress = (Boolean)HttpTransportSettings.SETTING_HTTP_TCP_REUSE_ADDRESS.get(settings);
        this.tcpSendBufferSize = Math.toIntExact(((ByteSizeValue)HttpTransportSettings.SETTING_HTTP_TCP_SEND_BUFFER_SIZE.get(settings)).getBytes());
        this.tcpReceiveBufferSize = Math.toIntExact(((ByteSizeValue)HttpTransportSettings.SETTING_HTTP_TCP_RECEIVE_BUFFER_SIZE.get(settings)).getBytes());
        logger.debug("using max_chunk_size[{}], max_header_size[{}], max_initial_line_length[{}], max_content_length[{}], pipelining_max_events[{}]", (Object)maxChunkSize, (Object)maxHeaderSize, (Object)maxInitialLineLength, (Object)this.maxContentLength, (Object)pipeliningMaxEvents);
    }

    public Logger getLogger() {
        return logger;
    }

    protected void doStart() {
        boolean success = false;
        try {
            int acceptorCount = (Integer)NIO_HTTP_ACCEPTOR_COUNT.get(this.settings);
            int workerCount = (Integer)NIO_HTTP_WORKER_COUNT.get(this.settings);
            this.nioGroup = new NioGroup(EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"http_server_acceptor"), acceptorCount, EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"http_server_worker"), workerCount, s -> new EventHandler(arg_0 -> ((NioHttpServerTransport)this).onNonChannelException(arg_0), s));
            this.channelFactory = this.channelFactory();
            this.bindServer();
            success = true;
        }
        catch (IOException e) {
            throw new ElasticsearchException((Throwable)e);
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    protected void stopInternal() {
        try {
            this.nioGroup.close();
        }
        catch (Exception e) {
            logger.warn("unexpected exception while stopping nio group", (Throwable)e);
        }
    }

    protected HttpServerChannel bind(InetSocketAddress socketAddress) throws IOException {
        return (HttpServerChannel)this.nioGroup.bindServerChannel(socketAddress, this.channelFactory);
    }

    protected ChannelFactory<NioHttpServerChannel, NioHttpChannel> channelFactory() {
        return new HttpChannelFactory();
    }

    static NioCorsConfig buildCorsConfig(Settings settings) {
        NioCorsConfigBuilder builder;
        if (!((Boolean)HttpTransportSettings.SETTING_CORS_ENABLED.get(settings)).booleanValue()) {
            return NioCorsConfigBuilder.forOrigins(new String[0]).disable().build();
        }
        String origin = (String)HttpTransportSettings.SETTING_CORS_ALLOW_ORIGIN.get(settings);
        if (Strings.isNullOrEmpty((String)origin)) {
            builder = NioCorsConfigBuilder.forOrigins(new String[0]);
        } else if (origin.equals("*")) {
            builder = NioCorsConfigBuilder.forAnyOrigin();
        } else {
            try {
                Pattern p = RestUtils.checkCorsSettingForRegex((String)origin);
                builder = p == null ? NioCorsConfigBuilder.forOrigins(RestUtils.corsSettingAsArray((String)origin)) : NioCorsConfigBuilder.forPattern(p);
            }
            catch (PatternSyntaxException e) {
                throw new SettingsException("Bad regex in [" + HttpTransportSettings.SETTING_CORS_ALLOW_ORIGIN.getKey() + "]: [" + origin + "]", (Throwable)e);
            }
        }
        if (((Boolean)HttpTransportSettings.SETTING_CORS_ALLOW_CREDENTIALS.get(settings)).booleanValue()) {
            builder.allowCredentials();
        }
        String[] strMethods = Strings.tokenizeToStringArray((String)((String)HttpTransportSettings.SETTING_CORS_ALLOW_METHODS.get(settings)), (String)",");
        HttpMethod[] methods = (HttpMethod[])Arrays.stream(strMethods).map(HttpMethod::valueOf).toArray(HttpMethod[]::new);
        return builder.allowedRequestMethods(methods).maxAge(((Integer)HttpTransportSettings.SETTING_CORS_MAX_AGE.get(settings)).intValue()).allowedRequestHeaders(Strings.tokenizeToStringArray((String)((String)HttpTransportSettings.SETTING_CORS_ALLOW_HEADERS.get(settings)), (String)",")).shortCircuit().build();
    }

    protected void acceptChannel(NioSocketChannel socketChannel) {
        super.serverAcceptedChannel((HttpChannel)socketChannel);
    }

    private class HttpChannelFactory
    extends ChannelFactory<NioHttpServerChannel, NioHttpChannel> {
        private HttpChannelFactory() {
            super(new ChannelFactory.RawChannelFactory(NioHttpServerTransport.this.tcpNoDelay, NioHttpServerTransport.this.tcpKeepAlive, NioHttpServerTransport.this.reuseAddress, NioHttpServerTransport.this.tcpSendBufferSize, NioHttpServerTransport.this.tcpReceiveBufferSize));
        }

        public NioHttpChannel createChannel(NioSelector selector, SocketChannel channel) throws IOException {
            NioHttpChannel httpChannel = new NioHttpChannel(channel);
            Supplier<InboundChannelBuffer.Page> pageSupplier = () -> {
                Recycler.V bytes = NioHttpServerTransport.this.pageCacheRecycler.bytePage(false);
                return new InboundChannelBuffer.Page(ByteBuffer.wrap((byte[])bytes.v()), () -> ((Recycler.V)bytes).close());
            };
            HttpReadWriteHandler httpReadWritePipeline = new HttpReadWriteHandler(httpChannel, NioHttpServerTransport.this, NioHttpServerTransport.this.handlingSettings, NioHttpServerTransport.this.corsConfig);
            Consumer<Exception> exceptionHandler = e -> NioHttpServerTransport.this.onException(httpChannel, e);
            BytesChannelContext context = new BytesChannelContext((NioSocketChannel)httpChannel, selector, exceptionHandler, (ReadWriteHandler)httpReadWritePipeline, new InboundChannelBuffer(pageSupplier));
            httpChannel.setContext((SocketChannelContext)context);
            return httpChannel;
        }

        public NioHttpServerChannel createServerChannel(NioSelector selector, ServerSocketChannel channel) throws IOException {
            NioHttpServerChannel httpServerChannel = new NioHttpServerChannel(channel);
            Consumer<Exception> exceptionHandler = e -> NioHttpServerTransport.this.onServerException(httpServerChannel, e);
            Consumer<NioSocketChannel> acceptor = NioHttpServerTransport.this::acceptChannel;
            ServerChannelContext context = new ServerChannelContext((NioServerSocketChannel)httpServerChannel, (ChannelFactory)this, selector, acceptor, exceptionHandler);
            httpServerChannel.setContext(context);
            return httpServerChannel;
        }
    }
}

